/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.explosions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.explosions.ExplosionEvent;
import xd.arkosammy.creeperhealing.handlers.ExplosionListHandler;

public class ExplosionListCodec {
    private final List<ExplosionEvent> storedExplosionEvents;
    public static final Codec<ExplosionListCodec> CODEC = RecordCodecBuilder.create(scheduledCreeperExplosionsInstance -> scheduledCreeperExplosionsInstance.group((App)Codec.list(ExplosionEvent.getCodec()).fieldOf("Scheduled_Creeper_Explosions").forGetter(ExplosionListCodec::getStoredExplosionEvents)).apply((Applicative)scheduledCreeperExplosionsInstance, ExplosionListCodec::new));

    public ExplosionListCodec(List<ExplosionEvent> events) {
        this.storedExplosionEvents = new CopyOnWriteArrayList<ExplosionEvent>(events);
    }

    private List<ExplosionEvent> getStoredExplosionEvents() {
        return this.storedExplosionEvents;
    }

    public static void rescheduleExplosionEvents(MinecraftServer server) throws IOException {
        List<ExplosionEvent> explosionEvents = ExplosionListCodec.deserializeExplosionEvents(server);
        if (!explosionEvents.isEmpty()) {
            ExplosionListHandler.getExplosionEventList().addAll(explosionEvents);
            CreeperHealing.LOGGER.info("Rescheduled " + explosionEvents.size() + " explosion event(s).");
        }
    }

    public void serializeExplosionEvents(@NotNull MinecraftServer server) {
        Path scheduledExplosionsFilePath = server.method_27050(class_5218.field_24188).resolve("scheduled-explosions.json");
        DataResult encodedScheduledExplosions = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this);
        if (encodedScheduledExplosions.result().isPresent()) {
            JsonElement scheduledExplosionsAsJson = (JsonElement)encodedScheduledExplosions.resultOrPartial(arg_0 -> ((Logger)CreeperHealing.LOGGER).error(arg_0)).orElseThrow();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String scheduledExplosionsAsJsonString = gson.toJson(scheduledExplosionsAsJson);
            try (BufferedWriter writer = Files.newBufferedWriter(scheduledExplosionsFilePath, new OpenOption[0]);){
                writer.write(scheduledExplosionsAsJsonString);
                CreeperHealing.LOGGER.info("Stored scheduled creeper explosion event(s) to " + scheduledExplosionsFilePath);
            }
            catch (IOException e) {
                CreeperHealing.LOGGER.error("Error storing creeper explosion(s): " + e.getMessage());
            }
        } else {
            CreeperHealing.LOGGER.error("Error storing explosions event(s) to " + scheduledExplosionsFilePath);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<ExplosionEvent> deserializeExplosionEvents(@NotNull MinecraftServer server) throws IOException {
        Path scheduledExplosionsFilePath = server.method_27050(class_5218.field_24188).resolve("scheduled-explosions.json");
        ArrayList<ExplosionEvent> scheduledExplosionEvents = new ArrayList<ExplosionEvent>();
        if (!Files.exists(scheduledExplosionsFilePath, new LinkOption[0])) {
            Files.createFile(scheduledExplosionsFilePath, new FileAttribute[0]);
            return scheduledExplosionEvents;
        }
        try (BufferedReader reader = Files.newBufferedReader(scheduledExplosionsFilePath);){
            JsonElement scheduledExplosionsAsJson = JsonParser.parseReader((Reader)reader);
            DataResult decodedScheduledExplosions = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)scheduledExplosionsAsJson);
            if (decodedScheduledExplosions.result().isPresent()) {
                List<ExplosionEvent> list = ((ExplosionListCodec)decodedScheduledExplosions.resultOrPartial(error -> CreeperHealing.LOGGER.error("Error reading scheduled-explosions.json: " + error)).orElseThrow()).getStoredExplosionEvents();
                return list;
            }
            CreeperHealing.LOGGER.error("Error reading scheduled explosions: " + decodedScheduledExplosions.error());
            return scheduledExplosionEvents;
        }
        catch (JsonParseException | IOException e) {
            CreeperHealing.LOGGER.error("Error reading scheduled explosions: " + (Exception)e);
            return scheduledExplosionEvents;
        }
    }
}

