/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.handlers;

import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;
import xd.arkosammy.creeperhealing.configuration.tables.PreferencesConfig;
import xd.arkosammy.creeperhealing.explosions.ExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.ExplosionUtils;

public final class DoubleBlockHandler {
    private DoubleBlockHandler() {
    }

    public static boolean isDoubleBlock(class_2680 state) {
        return state.method_28498((class_2769)class_2741.field_12533) || state.method_28498((class_2769)class_2741.field_12483);
    }

    public static void handleDoubleBlock(class_1937 world, class_2680 state, class_2338 pos, ExplosionEvent currentExplosionEvent) {
        if (state.method_28498((class_2769)class_2741.field_12533)) {
            DoubleBlockHandler.handleDoubleBlocks(world, state, pos, currentExplosionEvent);
        } else if (state.method_28498((class_2769)class_2741.field_12483)) {
            DoubleBlockHandler.handleBedPart(world, state, pos, currentExplosionEvent);
        }
    }

    private static void handleDoubleBlocks(class_1937 world, class_2680 firstHalfState, class_2338 firstHalfPos, ExplosionEvent currentExplosionEvent) {
        class_2338 secondHalfPos;
        class_2756 secondHalf = ((class_2756)firstHalfState.method_11654((class_2769)class_2741.field_12533)).equals((Object)class_2756.field_12609) ? class_2756.field_12607 : class_2756.field_12609;
        class_2680 secondHalfState = (class_2680)firstHalfState.method_26204().method_34725(firstHalfState).method_11657((class_2769)class_2741.field_12533, (Comparable)secondHalf);
        class_2338 class_23382 = secondHalfPos = ((class_2756)secondHalfState.method_11654((class_2769)class_2741.field_12533)).equals((Object)class_2756.field_12609) ? firstHalfPos.method_30513(class_2350.class_2351.field_11052, 1) : firstHalfPos.method_30513(class_2350.class_2351.field_11052, -1);
        if (DoubleBlockHandler.shouldHealDoubleBlock(world, firstHalfPos, secondHalfPos)) {
            class_2338 posToPushFrom;
            class_2680 stateToPushFrom = ((class_2756)firstHalfState.method_11654((class_2769)class_2741.field_12533)).equals((Object)class_2756.field_12607) ? firstHalfState : secondHalfState;
            class_2338 class_23383 = posToPushFrom = ((class_2756)firstHalfState.method_11654((class_2769)class_2741.field_12533)).equals((Object)class_2756.field_12607) ? firstHalfPos : firstHalfPos.method_30513(class_2350.class_2351.field_11052, -1);
            if (stateToPushFrom.method_26212((class_1922)world, posToPushFrom)) {
                ExplosionUtils.pushEntitiesUpwards(world, posToPushFrom, true);
            }
            world.method_8501(firstHalfPos, firstHalfState);
            world.method_8501(secondHalfPos, secondHalfState);
            if (ExplosionUtils.shouldPlaySoundOnBlockHeal(world, firstHalfState)) {
                world.method_8396(null, firstHalfPos, firstHalfState.method_26231().method_10598(), class_3419.field_15245, firstHalfState.method_26231().method_10597(), firstHalfState.method_26231().method_10599());
            }
        }
        currentExplosionEvent.markAffectedBlockAsPlaced(secondHalfState, secondHalfPos, world);
    }

    private static void handleBedPart(class_1937 world, class_2680 firstHalfState, class_2338 firstHalfPos, ExplosionEvent currentExplosionEvent) {
        class_2338 secondHalfPos;
        class_2742 secondBedPart = ((class_2742)firstHalfState.method_11654((class_2769)class_2741.field_12483)).equals((Object)class_2742.field_12560) ? class_2742.field_12557 : class_2742.field_12560;
        class_2680 secondHalfState = (class_2680)firstHalfState.method_26204().method_34725(firstHalfState).method_11657((class_2769)class_2741.field_12483, (Comparable)secondBedPart);
        if (secondBedPart.equals((Object)class_2742.field_12560)) {
            switch ((class_2350)firstHalfState.method_11654((class_2769)class_2741.field_12481)) {
                case field_11043: {
                    secondHalfPos = firstHalfPos.method_30513(class_2350.class_2351.field_11051, -1);
                    break;
                }
                case field_11035: {
                    secondHalfPos = firstHalfPos.method_30513(class_2350.class_2351.field_11051, 1);
                    break;
                }
                case field_11034: {
                    secondHalfPos = firstHalfPos.method_30513(class_2350.class_2351.field_11048, 1);
                    break;
                }
                default: {
                    secondHalfPos = firstHalfPos.method_30513(class_2350.class_2351.field_11048, -1);
                    break;
                }
            }
        } else {
            switch ((class_2350)firstHalfState.method_11654((class_2769)class_2741.field_12481)) {
                case field_11043: {
                    secondHalfPos = firstHalfPos.method_30513(class_2350.class_2351.field_11051, 1);
                    break;
                }
                case field_11035: {
                    secondHalfPos = firstHalfPos.method_30513(class_2350.class_2351.field_11051, -1);
                    break;
                }
                case field_11034: {
                    secondHalfPos = firstHalfPos.method_30513(class_2350.class_2351.field_11048, -1);
                    break;
                }
                default: {
                    secondHalfPos = firstHalfPos.method_30513(class_2350.class_2351.field_11048, 1);
                }
            }
        }
        if (DoubleBlockHandler.shouldHealDoubleBlock(world, firstHalfPos, secondHalfPos)) {
            if (firstHalfState.method_26212((class_1922)world, firstHalfPos)) {
                ExplosionUtils.pushEntitiesUpwards(world, firstHalfPos, false);
            }
            if (secondHalfState.method_26212((class_1922)world, secondHalfPos)) {
                ExplosionUtils.pushEntitiesUpwards(world, secondHalfPos, false);
            }
            world.method_8501(firstHalfPos, firstHalfState);
            world.method_8501(secondHalfPos, secondHalfState);
            if (ExplosionUtils.shouldPlaySoundOnBlockHeal(world, firstHalfState)) {
                world.method_8396(null, firstHalfPos, firstHalfState.method_26231().method_10598(), class_3419.field_15245, firstHalfState.method_26231().method_10597(), firstHalfState.method_26231().method_10599());
            }
        }
        currentExplosionEvent.markAffectedBlockAsPlaced(secondHalfState, secondHalfPos, world);
    }

    private static boolean shouldHealDoubleBlock(@NotNull class_1937 world, class_2338 firstHalfPos, class_2338 secondHalfPos) {
        class_2680 firstHalfState = world.method_8320(firstHalfPos);
        class_2680 secondHalfState = world.method_8320(secondHalfPos);
        class_3610 firstHalfFluidState = firstHalfState.method_26227();
        class_3610 secondHalfFluidState = secondHalfState.method_26227();
        if (ExplosionUtils.isStateAirOrFire(firstHalfState) && ExplosionUtils.isStateAirOrFire(secondHalfState)) {
            return true;
        }
        if ((firstHalfFluidState.method_15772().equals(class_3612.field_15909) && ExplosionUtils.isStateAirOrFire(secondHalfState) || ExplosionUtils.isStateAirOrFire(firstHalfState) && secondHalfFluidState.method_15772().equals(class_3612.field_15909) || firstHalfFluidState.method_15772().equals(class_3612.field_15909) && secondHalfFluidState.method_15772().equals(class_3612.field_15909)) && PreferencesConfig.HEAL_ON_FLOWING_WATER.getEntry().getValue().booleanValue()) {
            return true;
        }
        if ((firstHalfFluidState.method_15772().equals(class_3612.field_15910) && ExplosionUtils.isStateAirOrFire(secondHalfState) || ExplosionUtils.isStateAirOrFire(firstHalfState) && secondHalfFluidState.method_15772().equals(class_3612.field_15910) || firstHalfFluidState.method_15772().equals(class_3612.field_15910) && secondHalfFluidState.method_15772().equals(class_3612.field_15910)) && PreferencesConfig.HEAL_ON_SOURCE_WATER.getEntry().getValue().booleanValue()) {
            return true;
        }
        if ((firstHalfFluidState.method_15772().equals(class_3612.field_15907) && ExplosionUtils.isStateAirOrFire(secondHalfState) || ExplosionUtils.isStateAirOrFire(firstHalfState) && secondHalfFluidState.method_15772().equals(class_3612.field_15907) || firstHalfFluidState.method_15772().equals(class_3612.field_15907) && secondHalfFluidState.method_15772().equals(class_3612.field_15907)) && PreferencesConfig.HEAL_ON_FLOWING_LAVA.getEntry().getValue().booleanValue()) {
            return true;
        }
        return (firstHalfFluidState.method_15772().equals(class_3612.field_15908) && ExplosionUtils.isStateAirOrFire(secondHalfState) || ExplosionUtils.isStateAirOrFire(firstHalfState) && secondHalfFluidState.method_15772().equals(class_3612.field_15908) || firstHalfFluidState.method_15772().equals(class_3612.field_15908) && secondHalfFluidState.method_15772().equals(class_3612.field_15908)) && PreferencesConfig.HEAL_ON_SOURCE_LAVA.getEntry().getValue() != false;
    }
}

