/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.handlers;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.server.MinecraftServer;
import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.explosions.AffectedBlock;
import xd.arkosammy.creeperhealing.explosions.ExplosionEvent;

public final class ExplosionListHandler {
    private static final List<ExplosionEvent> explosionEventList = new CopyOnWriteArrayList<ExplosionEvent>();

    private ExplosionListHandler() {
    }

    public static List<ExplosionEvent> getExplosionEventList() {
        return explosionEventList;
    }

    public static void handleExplosionList(MinecraftServer server) {
        if (!CreeperHealing.isExplosionHandlingUnlocked() || ExplosionListHandler.getExplosionEventList().isEmpty()) {
            return;
        }
        ExplosionEvent.tickExplosions();
        for (ExplosionEvent currentExplosionEvent : ExplosionListHandler.getExplosionEventList()) {
            if (currentExplosionEvent.getExplosionTimer() >= 0L) continue;
            ExplosionListHandler.processExplosionEvent(currentExplosionEvent, server);
        }
    }

    private static void processExplosionEvent(ExplosionEvent currentExplosionEvent, MinecraftServer server) {
        Optional<AffectedBlock> optionalAffectedBlock = currentExplosionEvent.getCurrentAffectedBlock();
        if (optionalAffectedBlock.isEmpty()) {
            ExplosionListHandler.getExplosionEventList().remove(currentExplosionEvent);
            return;
        }
        AffectedBlock currentAffectedBlock = optionalAffectedBlock.get();
        if (currentAffectedBlock.isAlreadyPlaced()) {
            currentExplosionEvent.incrementCounter();
            return;
        }
        if (!currentAffectedBlock.canBePlaced(server)) {
            currentExplosionEvent.delayAffectedBlock(currentAffectedBlock, server);
            return;
        }
        currentAffectedBlock.tickAffectedBlock();
        if (currentAffectedBlock.getAffectedBlockTimer() < 0L) {
            ExplosionListHandler.handleBlockPlacement(currentAffectedBlock, currentExplosionEvent, server);
        }
    }

    private static void handleBlockPlacement(AffectedBlock currentAffectedBlock, ExplosionEvent currentExplosionEvent, MinecraftServer server) {
        if (!currentExplosionEvent.hasEnoughLightIfDaytimeHealingMode(server)) {
            ExplosionListHandler.getExplosionEventList().remove(currentExplosionEvent);
            return;
        }
        if (!currentExplosionEvent.shouldKeepHealingIfDifficultyBasedHealingMode(currentAffectedBlock.getWorld(server))) {
            ExplosionListHandler.getExplosionEventList().remove(currentExplosionEvent);
            return;
        }
        currentAffectedBlock.tryHealing(server, currentExplosionEvent);
        currentAffectedBlock.setPlaced(true);
        currentExplosionEvent.incrementCounter();
    }
}

