/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.mixin;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1511;
import net.minecraft.class_1528;
import net.minecraft.class_1541;
import net.minecraft.class_1548;
import net.minecraft.class_1571;
import net.minecraft.class_1701;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_7923;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xd.arkosammy.creeperhealing.configuration.tables.ExplosionSourceConfig;
import xd.arkosammy.creeperhealing.configuration.tables.PreferencesConfig;
import xd.arkosammy.creeperhealing.configuration.tables.WhitelistConfig;
import xd.arkosammy.creeperhealing.explosions.AffectedBlock;
import xd.arkosammy.creeperhealing.explosions.ExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.ExplosionUtils;
import xd.arkosammy.creeperhealing.handlers.ExplosionListHandler;

@Mixin(value={class_1927.class})
public abstract class ExplosionListenerMixin {
    @Shadow
    @Final
    private class_1937 field_9187;

    @Shadow
    @Nullable
    public abstract class_1309 method_8347();

    @Shadow
    public abstract List<class_2338> method_8346();

    @Shadow
    @Nullable
    public abstract class_1297 method_46406();

    @Shadow
    public abstract class_1282 method_8349();

    @Inject(method={"collectBlocksAndDamageEntities"}, at={@At(value="RETURN")})
    private void storeCurrentExplosionIfNeeded(CallbackInfo ci) {
        if (this.shouldStoreExplosionFromSourceType(this.method_8347(), this.method_46406(), this.method_8349())) {
            this.storeExplosion(this.method_8346());
        }
    }

    @Unique
    private void storeExplosion(List<class_2338> affectedBlocksPos) {
        if (affectedBlocksPos.isEmpty()) {
            return;
        }
        ArrayList<AffectedBlock> affectedBlocks = new ArrayList<AffectedBlock>();
        for (class_2338 pos : affectedBlocksPos) {
            if (this.field_9187.method_8320(pos).method_26215() || this.field_9187.method_8320(pos).method_26204().equals(class_2246.field_10375) || this.field_9187.method_8320(pos).method_26204().equals(class_2246.field_10036) || this.field_9187.method_8320(pos).method_26204().equals(class_2246.field_22089)) continue;
            String blockIdentifier = class_7923.field_41175.method_10221((Object)this.field_9187.method_8320(pos).method_26204()).toString();
            if (PreferencesConfig.ENABLE_WHITELIST.getEntry().getValue().booleanValue() && !WhitelistConfig.getWhitelist().contains(blockIdentifier)) continue;
            affectedBlocks.add(AffectedBlock.newAffectedBlock(pos, this.field_9187));
        }
        if (affectedBlocks.isEmpty()) {
            return;
        }
        ExplosionListHandler.getExplosionEventList().add(ExplosionEvent.newExplosionEvent(affectedBlocks, this.field_9187));
    }

    @Unique
    private boolean shouldStoreExplosionFromSourceType(class_1309 causingLivingEntity, class_1297 causingEntity, class_1282 damageSource) {
        return causingLivingEntity instanceof class_1548 && ExplosionSourceConfig.HEAL_CREEPER_EXPLOSIONS.getEntry().getValue() != false || causingLivingEntity instanceof class_1571 && ExplosionSourceConfig.HEAL_GHAST_EXPLOSIONS.getEntry().getValue() != false || causingLivingEntity instanceof class_1528 && ExplosionSourceConfig.HEAL_WITHER_EXPLOSIONS.getEntry().getValue() != false || causingEntity instanceof class_1541 && ExplosionSourceConfig.HEAL_TNT_EXPLOSIONS.getEntry().getValue() != false || causingEntity instanceof class_1701 && ExplosionSourceConfig.HEAL_TNT_MINECART_EXPLOSIONS.getEntry().getValue() != false || damageSource.method_49708(class_8111.field_42334) && ExplosionSourceConfig.HEAL_BED_AND_RESPAWN_ANCHOR_EXPLOSIONS.getEntry().getValue() != false || causingEntity instanceof class_1511 && ExplosionSourceConfig.HEAL_END_CRYSTAL_EXPLOSIONS.getEntry().getValue() != false;
    }

    @Inject(method={"affectWorld"}, at={@At(value="HEAD")})
    private void setDropItemsThreadLocal(boolean particles, CallbackInfo ci) {
        ExplosionUtils.SHOULD_NOT_DROP_ITEMS.set(false);
    }

    @Inject(method={"affectWorld"}, at={@At(value="RETURN")})
    private void clearDropItemsThreadLocal(boolean particles, CallbackInfo ci) {
        ExplosionUtils.SHOULD_NOT_DROP_ITEMS.set(false);
    }
}

