/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.blocks;

import java.util.Objects;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import xd.arkosammy.creeperhealing.blocks.DoubleAffectedBlock;
import xd.arkosammy.creeperhealing.config.DelaysConfig;
import xd.arkosammy.creeperhealing.config.ReplaceMapConfig;
import xd.arkosammy.creeperhealing.explosions.AbstractExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.ducks.BlockAccessor;
import xd.arkosammy.creeperhealing.util.ExplosionUtils;
import xd.arkosammy.creeperhealing.util.SerializedAffectedBlock;

public class AffectedBlock {
    public static final String TYPE = "single_affected_block";
    private final class_2338 pos;
    private final class_2680 state;
    private final class_5321<class_1937> worldRegistryKey;
    private long timer;
    private boolean placed;

    public AffectedBlock(class_2338 pos, class_2680 state, class_5321<class_1937> registryKey, long timer, boolean placed) {
        this.pos = pos;
        this.state = state;
        this.worldRegistryKey = registryKey;
        this.placed = placed;
        this.timer = timer;
    }

    public static AffectedBlock newAffectedBlock(class_2338 pos, class_2680 state, class_1937 world) {
        return state.method_28498((class_2769)class_2741.field_12533) || state.method_28498((class_2769)class_2741.field_12483) ? new DoubleAffectedBlock(pos, state, (class_5321<class_1937>)world.method_27983(), DelaysConfig.getBlockPlacementDelayAsTicks(), false) : new AffectedBlock(pos, state, (class_5321<class_1937>)world.method_27983(), DelaysConfig.getBlockPlacementDelayAsTicks(), false);
    }

    public void setTimer(long delay) {
        this.timer = delay;
    }

    public class_5321<class_1937> getWorldRegistryKey() {
        return this.worldRegistryKey;
    }

    public class_1937 getWorld(@NotNull MinecraftServer server) {
        return server.method_3847(this.getWorldRegistryKey());
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_2680 getState() {
        return this.state;
    }

    public void setPlaced() {
        this.placed = true;
    }

    public long getTimer() {
        return this.timer;
    }

    public boolean isPlaced() {
        return this.placed;
    }

    public void tickAffectedBlock() {
        --this.timer;
    }

    public boolean canBePlaced(MinecraftServer server) {
        return this.getState().method_26184((class_4538)this.getWorld(server), this.getPos());
    }

    String getAffectedBlockType() {
        return TYPE;
    }

    public SerializedAffectedBlock toSerialized() {
        return new SerializedAffectedBlock(this.getAffectedBlockType(), this.pos, this.state, this.worldRegistryKey, this.timer, this.placed);
    }

    public void tryHealing(MinecraftServer server, AbstractExplosionEvent currentExplosionEvent) {
        class_2680 state = this.getState();
        class_2338 pos = this.getPos();
        class_1937 world = this.getWorld(server);
        String blockIdentifier = class_2378.field_11146.method_10221((Object)state.method_26204()).toString();
        if (ReplaceMapConfig.getReplaceMap().containsKey(blockIdentifier)) {
            state = ((class_2248)class_2378.field_11146.method_10223(new class_2960(ReplaceMapConfig.getReplaceMap().get(blockIdentifier)))).method_34725(state);
        }
        if (this.shouldHealBlock(world, this.pos)) {
            if (state.method_26212((class_1922)world, pos)) {
                ExplosionUtils.pushEntitiesUpwards(world, pos, false);
            }
            world.method_8501(pos, state);
            if (ExplosionUtils.shouldPlayBlockPlacementSound(world, state)) {
                world.method_8396(null, pos, state.method_26231().method_10598(), class_3419.field_15245, state.method_26231().method_10597(), state.method_26231().method_10599());
            }
        }
    }

    boolean shouldHealBlock(class_1937 world, class_2338 pos) {
        return ((BlockAccessor)world.method_8320(pos).method_26204()).creeper_healing$isReplaceable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AffectedBlock)) {
            return false;
        }
        AffectedBlock that = (AffectedBlock)o;
        return Objects.equals(this.getPos(), that.getPos()) && Objects.equals(this.getState(), that.getState()) && Objects.equals(this.getWorldRegistryKey(), that.getWorldRegistryKey());
    }

    public int hashCode() {
        return Objects.hash(this.getPos(), this.getState(), this.getWorldRegistryKey());
    }
}

