/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.blocks;

import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import xd.arkosammy.creeperhealing.blocks.AffectedBlock;
import xd.arkosammy.creeperhealing.config.ReplaceMapConfig;
import xd.arkosammy.creeperhealing.explosions.AbstractExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.ducks.BlockAccessor;
import xd.arkosammy.creeperhealing.util.ExplosionUtils;

public class DoubleAffectedBlock
extends AffectedBlock {
    public static final String TYPE = "double_affected_block";

    public DoubleAffectedBlock(class_2338 pos, class_2680 state, class_5321<class_1937> registryKey, long affectedBlockTimer, boolean placed) {
        super(pos, state, registryKey, affectedBlockTimer, placed);
    }

    @Override
    String getAffectedBlockType() {
        return TYPE;
    }

    @Override
    public void tryHealing(MinecraftServer server, AbstractExplosionEvent currentExplosionEvent) {
        class_2680 state = this.getState();
        String blockIdentifier = class_2378.field_11146.method_10221((Object)state.method_26204()).toString();
        if (ReplaceMapConfig.getReplaceMap().containsKey(blockIdentifier)) {
            super.tryHealing(server, currentExplosionEvent);
            return;
        }
        if (state.method_28498((class_2769)class_2741.field_12533)) {
            this.handleDoubleBlocks(server, currentExplosionEvent);
        } else if (state.method_28498((class_2769)class_2741.field_12483)) {
            this.handleBedPart(server, currentExplosionEvent);
        } else {
            super.tryHealing(server, currentExplosionEvent);
        }
    }

    private void handleDoubleBlocks(MinecraftServer server, AbstractExplosionEvent currentExplosionEvent) {
        class_2338 secondHalfPos;
        class_2680 firstHalfState = this.getState();
        class_2338 firstHalfPos = this.getPos();
        class_1937 world = this.getWorld(server);
        class_2756 secondHalf = ((class_2756)firstHalfState.method_11654((class_2769)class_2741.field_12533)).equals((Object)class_2756.field_12609) ? class_2756.field_12607 : class_2756.field_12609;
        class_2680 secondHalfState = (class_2680)firstHalfState.method_26204().method_34725(firstHalfState).method_11657((class_2769)class_2741.field_12533, (Comparable)secondHalf);
        class_2338 class_23382 = secondHalfPos = ((class_2756)secondHalfState.method_11654((class_2769)class_2741.field_12533)).equals((Object)class_2756.field_12609) ? firstHalfPos.method_10084() : firstHalfPos.method_10074();
        if (this.shouldHealBlock(world, secondHalfPos)) {
            class_2338 posToPushFrom;
            class_2680 stateToPushFrom = ((class_2756)firstHalfState.method_11654((class_2769)class_2741.field_12533)).equals((Object)class_2756.field_12607) ? firstHalfState : secondHalfState;
            class_2338 class_23383 = posToPushFrom = ((class_2756)firstHalfState.method_11654((class_2769)class_2741.field_12533)).equals((Object)class_2756.field_12607) ? firstHalfPos : firstHalfPos.method_10074();
            if (stateToPushFrom.method_26212((class_1922)world, posToPushFrom)) {
                ExplosionUtils.pushEntitiesUpwards(world, posToPushFrom, true);
            }
            world.method_8501(firstHalfPos, firstHalfState);
            world.method_8501(secondHalfPos, secondHalfState);
            if (ExplosionUtils.shouldPlayBlockPlacementSound(world, firstHalfState)) {
                world.method_8396(null, firstHalfPos, firstHalfState.method_26231().method_10598(), class_3419.field_15245, firstHalfState.method_26231().method_10597(), firstHalfState.method_26231().method_10599());
            }
        }
        currentExplosionEvent.markAsPlaced(secondHalfState, secondHalfPos, world);
    }

    private void handleBedPart(MinecraftServer server, AbstractExplosionEvent currentExplosionEvent) {
        class_2338 secondHalfPos;
        class_2680 firstHalfState = this.getState();
        class_2338 firstHalfPos = this.getPos();
        class_1937 world = this.getWorld(server);
        class_2742 secondBedPart = ((class_2742)firstHalfState.method_11654((class_2769)class_2741.field_12483)).equals((Object)class_2742.field_12560) ? class_2742.field_12557 : class_2742.field_12560;
        class_2680 secondHalfState = (class_2680)firstHalfState.method_26204().method_34725(firstHalfState).method_11657((class_2769)class_2741.field_12483, (Comparable)secondBedPart);
        class_2350 firstBedPartOrientation = (class_2350)firstHalfState.method_11654((class_2769)class_2741.field_12481);
        if (secondBedPart.equals((Object)class_2742.field_12560)) {
            switch (firstBedPartOrientation) {
                case field_11043: {
                    secondHalfPos = firstHalfPos.method_10095();
                    break;
                }
                case field_11035: {
                    secondHalfPos = firstHalfPos.method_10072();
                    break;
                }
                case field_11034: {
                    secondHalfPos = firstHalfPos.method_10078();
                    break;
                }
                default: {
                    secondHalfPos = firstHalfPos.method_10067();
                    break;
                }
            }
        } else {
            switch (firstBedPartOrientation) {
                case field_11043: {
                    secondHalfPos = firstHalfPos.method_10072();
                    break;
                }
                case field_11035: {
                    secondHalfPos = firstHalfPos.method_10095();
                    break;
                }
                case field_11034: {
                    secondHalfPos = firstHalfPos.method_10067();
                    break;
                }
                default: {
                    secondHalfPos = firstHalfPos.method_10078();
                }
            }
        }
        if (this.shouldHealBlock(world, secondHalfPos)) {
            if (firstHalfState.method_26212((class_1922)world, firstHalfPos)) {
                ExplosionUtils.pushEntitiesUpwards(world, firstHalfPos, false);
            }
            if (secondHalfState.method_26212((class_1922)world, secondHalfPos)) {
                ExplosionUtils.pushEntitiesUpwards(world, secondHalfPos, false);
            }
            world.method_8501(firstHalfPos, firstHalfState);
            world.method_8501(secondHalfPos, secondHalfState);
            if (ExplosionUtils.shouldPlayBlockPlacementSound(world, firstHalfState)) {
                world.method_8396(null, firstHalfPos, firstHalfState.method_26231().method_10598(), class_3419.field_15245, firstHalfState.method_26231().method_10597(), firstHalfState.method_26231().method_10599());
            }
        }
        currentExplosionEvent.markAsPlaced(secondHalfState, secondHalfPos, world);
    }

    @Override
    boolean shouldHealBlock(class_1937 world, class_2338 secondBlockPos) {
        return ((BlockAccessor)world.method_8320(this.getPos()).method_26204()).creeper_healing$isReplaceable() && ((BlockAccessor)world.method_8320(secondBlockPos).method_26204()).creeper_healing$isReplaceable();
    }
}

