/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.GenericBuilder;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mojang.brigadier.context.CommandContext;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;
import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.config.DelaysConfig;
import xd.arkosammy.creeperhealing.config.ExplosionItemDropConfig;
import xd.arkosammy.creeperhealing.config.ExplosionSourceConfig;
import xd.arkosammy.creeperhealing.config.ModeConfig;
import xd.arkosammy.creeperhealing.config.PreferencesConfig;
import xd.arkosammy.creeperhealing.config.ReplaceMapConfig;
import xd.arkosammy.creeperhealing.config.WhitelistConfig;
import xd.arkosammy.creeperhealing.util.ExplosionManager;

public final class ConfigManager {
    private static final Path CONFIG_PATH;
    @Nullable
    private static final GenericBuilder<CommentedConfig, CommentedFileConfig> CONFIG_BUILDER;

    private ConfigManager() {
    }

    public static void init() {
        if (CONFIG_BUILDER == null) {
            return;
        }
        try (CommentedFileConfig fileConfig = (CommentedFileConfig)CONFIG_BUILDER.build();){
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                fileConfig.load();
                ConfigManager.getValuesFromConfig(fileConfig);
                ConfigManager.updateConfigFile();
                if (Math.round(Math.max(DelaysConfig.EXPLOSION_HEAL_DELAY.getEntry().getValue(), 0.0) * 20.0) == 0L) {
                    CreeperHealing.LOGGER.warn("Explosion heal delay set to a very low value in the config file. A value of 1 second will be used instead. Please set a valid value in the config file");
                }
                if (Math.round(Math.max(DelaysConfig.BLOCK_PLACEMENT_DELAY.getEntry().getValue(), 0.0) * 20.0) == 0L) {
                    CreeperHealing.LOGGER.warn("Block placement delay set to a very low value in the config file. A value of 1 second will be used instead. Please set a valid value in the config file");
                }
                CreeperHealing.LOGGER.info("Applied custom config settings");
            } else {
                CreeperHealing.LOGGER.warn("Found no preexisting config to load settings from. Creating a new config with default values in " + CONFIG_PATH);
                CreeperHealing.LOGGER.warn("Change the settings in the config file, then reload the config by using /creeper-healing reload_config, or restart the server.");
                ConfigManager.setDefaultValuesToConfig(fileConfig);
                fileConfig.save();
            }
        }
    }

    public static void updateConfigFile() {
        if (CONFIG_BUILDER == null) {
            return;
        }
        try (CommentedFileConfig fileConfig = (CommentedFileConfig)CONFIG_BUILDER.build();){
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                fileConfig.load();
                ReplaceMapConfig.getValues(fileConfig);
                WhitelistConfig.getValues(fileConfig);
                ConfigManager.setValuesToConfig(fileConfig);
                fileConfig.save();
            } else {
                CreeperHealing.LOGGER.warn("Found no preexisting config to load settings from. Creating a new config with default values in " + CONFIG_PATH);
                CreeperHealing.LOGGER.warn("Change the settings in the config file, then reload the config by using /creeper-healing reload_config, or restart the server.");
                ConfigManager.setDefaultValuesToConfig(fileConfig);
                fileConfig.save();
            }
        }
    }

    public static boolean reloadValuesFromConfig(CommandContext<class_2168> ctx) {
        if (CONFIG_BUILDER == null) {
            return false;
        }
        try (CommentedFileConfig fileConfig = (CommentedFileConfig)CONFIG_BUILDER.build();){
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                fileConfig.load();
                ConfigManager.getValuesFromConfig(fileConfig);
                ExplosionManager.getInstance().updateAffectedBlocksTimers();
                if (Math.round(Math.max(DelaysConfig.EXPLOSION_HEAL_DELAY.getEntry().getValue(), 0.0) * 20.0) == 0L) {
                    ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Explosion heal delay set to a very low value in the config file. A value of 1 second will be used instead. Please set a valid value in the config file").method_27692(class_124.field_1054));
                }
                if (Math.round(Math.max(DelaysConfig.BLOCK_PLACEMENT_DELAY.getEntry().getValue(), 0.0) * 20.0) == 0L) {
                    ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Block placement delay set to a very low value in the config file. A value of 1 second will be used instead. Please set a valid value in the config file").method_27692(class_124.field_1054));
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private static void setDefaultValuesToConfig(CommentedFileConfig fileConfig) {
        ModeConfig.setDefaultValues(fileConfig);
        ExplosionSourceConfig.setDefaultValues(fileConfig);
        ExplosionItemDropConfig.setDefaultValues(fileConfig);
        DelaysConfig.setDefaultValues(fileConfig);
        PreferencesConfig.setDefaultValues(fileConfig);
        WhitelistConfig.setDefaultValues(fileConfig);
        ReplaceMapConfig.setDefaultValues(fileConfig);
    }

    private static void setValuesToConfig(CommentedFileConfig fileConfig) {
        ModeConfig.setValues(fileConfig);
        ExplosionSourceConfig.setValues(fileConfig);
        ExplosionItemDropConfig.setValues(fileConfig);
        DelaysConfig.setValues(fileConfig);
        PreferencesConfig.setValues(fileConfig);
        WhitelistConfig.setValues(fileConfig);
        ReplaceMapConfig.setValues(fileConfig);
    }

    private static void getValuesFromConfig(CommentedFileConfig fileConfig) {
        ModeConfig.getValues(fileConfig);
        ExplosionSourceConfig.getValues(fileConfig);
        ExplosionItemDropConfig.getValues(fileConfig);
        DelaysConfig.getValues(fileConfig);
        PreferencesConfig.getValues(fileConfig);
        WhitelistConfig.getValues(fileConfig);
        ReplaceMapConfig.getValues(fileConfig);
    }

    static {
        GenericBuilder builder;
        CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("creeper-healing.toml");
        System.setProperty("nightconfig.preserveInsertionOrder", "true");
        try {
            builder = CommentedFileConfig.builder((Path)CONFIG_PATH, (ConfigFormat)TomlFormat.instance()).preserveInsertionOrder().concurrent().sync();
        }
        catch (Throwable throwable) {
            CreeperHealing.LOGGER.info("Unable to initialize config: {}", (Object)throwable.getMessage());
            CreeperHealing.LOGGER.info("The config will be unable to be used.");
            builder = null;
        }
        CONFIG_BUILDER = builder;
    }
}

