/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.Arrays;
import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.config.ConfigEntry;
import xd.arkosammy.creeperhealing.explosions.ExplosionHealingMode;

public enum ModeConfig {
    MODE(new ConfigEntry<String>("mode", ExplosionHealingMode.DEFAULT_MODE.getName(), "(Default = \"default_mode\") Choose any of the following healing modes by copying one of the strings and pasting it into the value of the \"mode\" setting below:\n- \"%s\", \"%s\", \"%s\", \"%s\" ".formatted(ExplosionHealingMode.DEFAULT_MODE.getName(), ExplosionHealingMode.DAYTIME_HEALING_MODE.getName(), ExplosionHealingMode.DIFFICULTY_BASED_HEALING_MODE.getName(), ExplosionHealingMode.BLAST_RESISTANCE_BASED_HEALING_MODE.getName())));

    private final ConfigEntry<String> entry;
    private static final String TABLE_NAME = "explosion_healing_mode";
    private static final String TABLE_COMMENT = "Choose between different special modes for explosion healing. Note that certain healing modes will not follow the explosion delay and block delay settings.";

    private ModeConfig(ConfigEntry<String> entry) {
        this.entry = entry;
    }

    public ConfigEntry<String> getEntry() {
        return this.entry;
    }

    static void setDefaultValues(CommentedFileConfig fileConfig) {
        for (ConfigEntry configEntry : Arrays.stream(ModeConfig.values()).map(ModeConfig::getEntry).toList()) {
            configEntry.resetValue();
        }
        ModeConfig.setValues(fileConfig);
    }

    static void setValues(CommentedFileConfig fileConfig) {
        for (ConfigEntry entry2 : Arrays.stream(ModeConfig.values()).map(ModeConfig::getEntry).toList()) {
            fileConfig.set("explosion_healing_mode." + entry2.getName(), entry2.getValue());
            String entryComment = entry2.getComment();
            if (entryComment == null) continue;
            fileConfig.setComment("explosion_healing_mode." + entry2.getName(), entryComment);
        }
        fileConfig.setComment(TABLE_NAME, TABLE_COMMENT);
        ((CommentedConfig)fileConfig.get(TABLE_NAME)).entrySet().removeIf(entry -> !ModeConfig.isEntryKeyInEnum(entry.getKey()));
    }

    static void getValues(CommentedFileConfig fileConfig) {
        for (ConfigEntry configEntry : Arrays.stream(ModeConfig.values()).map(ModeConfig::getEntry).toList()) {
            Object value = fileConfig.getOrElse("explosion_healing_mode." + configEntry.getName(), (Object)((String)configEntry.getDefaultValue()));
            if (value instanceof String) {
                String stringValue = (String)value;
                configEntry.setValue(stringValue);
                continue;
            }
            CreeperHealing.LOGGER.error("Invalid value in config file for setting: " + configEntry.getName());
        }
    }

    private static boolean isEntryKeyInEnum(String key) {
        return Arrays.stream(ModeConfig.values()).anyMatch(configEntry -> configEntry.getEntry().getName().equals(key));
    }
}

