/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.Arrays;
import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.config.ConfigEntry;

public enum PreferencesConfig {
    BLOCK_PLACEMENT_SOUND_EFFECT(new ConfigEntry<Boolean>("block_placement_sound_effect", true, "(Default = true) Whether a block placement sound effect should be played when a block is healed.")),
    HEAL_ON_HEALING_POTION_SPLASH(new ConfigEntry<Boolean>("heal_on_healing_potion_splash", true, "(Default = true) Makes explosion heal immediately when a potion of Healing is thrown on them.")),
    HEAL_ON_REGENERATION_POTION_SPLASH(new ConfigEntry<Boolean>("heal_on_regeneration_potion_splash", true, "(Default = true) Makes explosions begin their healing process when a potion of Regeneration is thrown on them.")),
    ENABLE_WHITELIST(new ConfigEntry<Boolean>("enable_whitelist", false, "(Default = false) Toggle the usage of the whitelist."));

    private final ConfigEntry<Boolean> entry;
    private static final String TABLE_NAME = "preferences";
    private static final String TABLE_COMMENT = "Toggleable settings for extra features.";

    private PreferencesConfig(ConfigEntry<Boolean> entry) {
        this.entry = entry;
    }

    public ConfigEntry<Boolean> getEntry() {
        return this.entry;
    }

    static void setDefaultValues(CommentedFileConfig fileConfig) {
        for (ConfigEntry configEntry : Arrays.stream(PreferencesConfig.values()).map(PreferencesConfig::getEntry).toList()) {
            configEntry.resetValue();
        }
        PreferencesConfig.setValues(fileConfig);
    }

    static void setValues(CommentedFileConfig fileConfig) {
        for (ConfigEntry entry2 : Arrays.stream(PreferencesConfig.values()).map(PreferencesConfig::getEntry).toList()) {
            fileConfig.set("preferences." + entry2.getName(), entry2.getValue());
            String entryComment = entry2.getComment();
            if (entryComment == null) continue;
            fileConfig.setComment("preferences." + entry2.getName(), entryComment);
        }
        fileConfig.setComment(TABLE_NAME, TABLE_COMMENT);
        ((CommentedConfig)fileConfig.get(TABLE_NAME)).entrySet().removeIf(entry -> !PreferencesConfig.isEntryKeyInEnum(entry.getKey()));
    }

    static void getValues(CommentedFileConfig fileConfig) {
        for (ConfigEntry configEntry : Arrays.stream(PreferencesConfig.values()).map(PreferencesConfig::getEntry).toList()) {
            Object value = fileConfig.getOrElse("preferences." + configEntry.getName(), (Object)((Boolean)configEntry.getDefaultValue()));
            if (value instanceof Boolean) {
                Boolean boolValue = (Boolean)value;
                configEntry.setValue(boolValue);
                continue;
            }
            CreeperHealing.LOGGER.error("Invalid value in config file for setting: " + configEntry.getName());
        }
    }

    private static boolean isEntryKeyInEnum(String key) {
        return Arrays.stream(PreferencesConfig.values()).anyMatch(configEntry -> configEntry.getEntry().getName().equals(key));
    }
}

