/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.ArrayList;
import java.util.List;
import xd.arkosammy.creeperhealing.CreeperHealing;

public final class WhitelistConfig {
    private static final List<String> whitelist = new ArrayList<String>();
    private static final String TABLE_NAME = "whitelist";
    private static final String TABLE_COMMENT = "Use an optional whitelist to customize which blocks are allowed to heal. To add an entry, specify the block's namespace\nalong with its identifier, separated by a colon and enclosed in double quotes, and add it in-between the square brackets below. Separate each entry with a comma.\nExample entries:\nwhitelist_entries = [\"minecraft:grass\",  \"minecraft:stone\", \"minecraft:sand\"]";

    private WhitelistConfig() {
    }

    public static List<String> getWhitelist() {
        return whitelist;
    }

    static void setDefaultValues(CommentedFileConfig fileConfig) {
        WhitelistConfig.getWhitelist().clear();
        WhitelistConfig.getWhitelist().add("minecraft:placeholder");
        WhitelistConfig.setValues(fileConfig);
    }

    static void setValues(CommentedFileConfig fileConfig) {
        if (!WhitelistConfig.getWhitelist().isEmpty()) {
            fileConfig.set("whitelist.whitelist_entries", WhitelistConfig.getWhitelist());
        } else {
            fileConfig.set("whitelist.whitelist_entries", List.of("minecraft:placeholder"));
        }
        fileConfig.setComment(TABLE_NAME, TABLE_COMMENT);
    }

    static void getValues(CommentedFileConfig fileConfig) {
        List list = (List)fileConfig.getOrElse("whitelist.whitelist_entries", List.of("minecraft:placeholder"));
        ArrayList<String> tempWhitelist = new ArrayList<String>();
        if (list != null) {
            for (Object entry : list) {
                if (entry instanceof String) {
                    String stringEntry = (String)entry;
                    tempWhitelist.add(stringEntry);
                    continue;
                }
                CreeperHealing.LOGGER.error("Found non-string entry in the whitelist. Please make sure to only include string entries in the whitelist.");
            }
            WhitelistConfig.getWhitelist().clear();
            WhitelistConfig.getWhitelist().addAll(tempWhitelist);
        } else {
            CreeperHealing.LOGGER.error("Error attempting to read the whitelist from the config. Whitelist config section not found");
        }
    }
}

