/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.explosions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.server.MinecraftServer;
import xd.arkosammy.creeperhealing.blocks.AffectedBlock;
import xd.arkosammy.creeperhealing.config.DelaysConfig;
import xd.arkosammy.creeperhealing.config.ModeConfig;
import xd.arkosammy.creeperhealing.explosions.BlastResistanceBasedExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.DaytimeExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.DefaultExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.DifficultyBasedExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.ExplosionHealingMode;
import xd.arkosammy.creeperhealing.util.SerializedExplosionEvent;

public abstract class AbstractExplosionEvent {
    private final List<AffectedBlock> affectedBlocks;
    private long healTimer;
    private int blockCounter;

    protected AbstractExplosionEvent(List<AffectedBlock> affectedBlocks, long healTimer, int blockCounter) {
        this.affectedBlocks = affectedBlocks;
        this.healTimer = healTimer;
        this.blockCounter = blockCounter;
    }

    protected AbstractExplosionEvent(List<AffectedBlock> affectedBlocks) {
        this.affectedBlocks = affectedBlocks;
        this.healTimer = DelaysConfig.getExplosionHealDelayAsTicks();
        this.blockCounter = 0;
    }

    public static AbstractExplosionEvent newExplosionEvent(List<AffectedBlock> affectedBlocks, class_1937 world) {
        ExplosionHealingMode explosionHealingMode = ExplosionHealingMode.getFromName(ModeConfig.MODE.getEntry().getValue());
        AbstractExplosionEvent explosionEvent = switch (explosionHealingMode) {
            case ExplosionHealingMode.DAYTIME_HEALING_MODE -> new DaytimeExplosionEvent(affectedBlocks);
            case ExplosionHealingMode.DIFFICULTY_BASED_HEALING_MODE -> new DifficultyBasedExplosionEvent(affectedBlocks);
            case ExplosionHealingMode.BLAST_RESISTANCE_BASED_HEALING_MODE -> new BlastResistanceBasedExplosionEvent(affectedBlocks);
            default -> new DefaultExplosionEvent(affectedBlocks);
        };
        explosionEvent.setupExplosion(world);
        return explosionEvent;
    }

    public final void setHealTimer(long healTimer) {
        this.healTimer = healTimer;
    }

    public final void incrementCounter() {
        ++this.blockCounter;
    }

    public final List<AffectedBlock> getAffectedBlocks() {
        return this.affectedBlocks;
    }

    public final long getHealTimer() {
        return this.healTimer;
    }

    public final int getBlockCounter() {
        return this.blockCounter;
    }

    abstract ExplosionHealingMode getHealingMode();

    public final void tick() {
        --this.healTimer;
    }

    public abstract void setupExplosion(class_1937 var1);

    public final SerializedExplosionEvent toSerialized() {
        return new SerializedExplosionEvent(this.getHealingMode().getName(), this.affectedBlocks.stream().map(AffectedBlock::toSerialized).toList(), this.healTimer, this.blockCounter);
    }

    public final Optional<AffectedBlock> getCurrentAffectedBlock() {
        return this.blockCounter < this.affectedBlocks.size() ? Optional.of(this.affectedBlocks.get(this.blockCounter)) : Optional.empty();
    }

    public final void delayAffectedBlock(AffectedBlock affectedBlockToDelay, MinecraftServer server) {
        int indexOfDelayedBlock = this.affectedBlocks.indexOf(affectedBlockToDelay);
        if (indexOfDelayedBlock < 0) {
            this.incrementCounter();
            affectedBlockToDelay.setPlaced();
            return;
        }
        int indexOfNextPlaceable = this.findNextPlaceableBlockIndex(server);
        if (indexOfNextPlaceable >= 0) {
            Collections.swap(this.affectedBlocks, indexOfDelayedBlock, indexOfNextPlaceable);
        } else {
            this.incrementCounter();
            affectedBlockToDelay.setPlaced();
        }
    }

    private int findNextPlaceableBlockIndex(MinecraftServer server) {
        for (int i = this.blockCounter; i < this.affectedBlocks.size(); ++i) {
            if (!this.affectedBlocks.get(i).canBePlaced(server)) continue;
            return i;
        }
        return -1;
    }

    public abstract boolean shouldKeepHealing(class_1937 var1);

    public final void markAsPlaced(class_2680 secondHalfState, class_2338 secondHalfPos, class_1937 world) {
        for (AffectedBlock affectedBlock : this.getAffectedBlocks()) {
            if (!affectedBlock.getState().equals(secondHalfState) || !affectedBlock.getPos().equals((Object)secondHalfPos) || !affectedBlock.getWorldRegistryKey().equals((Object)world.method_27983())) continue;
            affectedBlock.setPlaced();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractExplosionEvent)) {
            return false;
        }
        AbstractExplosionEvent that = (AbstractExplosionEvent)o;
        return Objects.equals(this.getAffectedBlocks(), that.getAffectedBlocks());
    }

    public int hashCode() {
        return Objects.hash(this.getAffectedBlocks());
    }
}

