/*
 * Decompiled with CFR 0.152.
 */
package xd.arkosammy.creeperhealing.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import net.minecraft.class_1282;
import net.minecraft.class_1286;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1511;
import net.minecraft.class_1528;
import net.minecraft.class_1541;
import net.minecraft.class_1548;
import net.minecraft.class_1571;
import net.minecraft.class_1701;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import xd.arkosammy.creeperhealing.CreeperHealing;
import xd.arkosammy.creeperhealing.blocks.AffectedBlock;
import xd.arkosammy.creeperhealing.config.DelaysConfig;
import xd.arkosammy.creeperhealing.config.ExplosionSourceConfig;
import xd.arkosammy.creeperhealing.config.PreferencesConfig;
import xd.arkosammy.creeperhealing.config.WhitelistConfig;
import xd.arkosammy.creeperhealing.explosions.AbstractExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.BlastResistanceBasedExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.DaytimeExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.DefaultExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.DifficultyBasedExplosionEvent;
import xd.arkosammy.creeperhealing.explosions.ducks.ExplosionAccessor;
import xd.arkosammy.creeperhealing.util.ExplosionUtils;
import xd.arkosammy.creeperhealing.util.SerializedExplosionEvent;

public class ExplosionManager {
    private static final Codec<ExplosionManager> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list(SerializedExplosionEvent.CODEC).fieldOf("scheduled_explosions").forGetter(explosionManager -> explosionManager.explosionEvents.stream().map(AbstractExplosionEvent::toSerialized).toList())).apply((Applicative)instance, ExplosionManager::new));
    private static ExplosionManager instance;
    private final List<AbstractExplosionEvent> explosionEvents = new CopyOnWriteArrayList<AbstractExplosionEvent>();

    public static ExplosionManager getInstance() {
        if (instance == null) {
            instance = new ExplosionManager();
        }
        return instance;
    }

    private ExplosionManager() {
    }

    private ExplosionManager(List<SerializedExplosionEvent> serializedExplosionEvents) {
        List<AbstractExplosionEvent> explosionEvents = serializedExplosionEvents.stream().map(SerializedExplosionEvent::toDeserialized).toList();
        this.explosionEvents.clear();
        this.explosionEvents.addAll(explosionEvents);
        CreeperHealing.LOGGER.info("Rescheduled {} explosion event(s)", (Object)explosionEvents.size());
    }

    public List<AbstractExplosionEvent> getExplosionEvents() {
        return this.explosionEvents;
    }

    public void processExplosion(class_1927 explosion) {
        if (!this.shouldHealExplosion(explosion)) {
            return;
        }
        class_1937 world = ((ExplosionAccessor)explosion).creeper_healing$getWorld();
        ArrayList<AffectedBlock> affectedBlocks = new ArrayList<AffectedBlock>();
        for (class_2338 affectedPos : explosion.method_8346()) {
            class_2680 affectedState = world.method_8320(affectedPos);
            if (affectedState.method_26215() || affectedState.method_26204().equals(class_2246.field_10375) || affectedState.method_26164(class_3481.field_21952)) continue;
            String blockIdentifier = class_2378.field_11146.method_10221((Object)affectedState.method_26204()).toString();
            if (PreferencesConfig.ENABLE_WHITELIST.getEntry().getValue().booleanValue() && !WhitelistConfig.getWhitelist().contains(blockIdentifier)) continue;
            affectedBlocks.add(AffectedBlock.newAffectedBlock(affectedPos, affectedState, world));
        }
        if (affectedBlocks.isEmpty()) {
            return;
        }
        List<AffectedBlock> sortedAffectedBlocks = ExplosionUtils.sortAffectedBlocksList(affectedBlocks, world);
        AbstractExplosionEvent explosionEvent = AbstractExplosionEvent.newExplosionEvent(sortedAffectedBlocks, world);
        Set<AbstractExplosionEvent> collidingExplosions = this.getCollidingExplosions(affectedBlocks.stream().map(AffectedBlock::getPos).toList());
        if (collidingExplosions.isEmpty()) {
            this.explosionEvents.add(explosionEvent);
        } else {
            this.explosionEvents.removeIf(collidingExplosions::contains);
            collidingExplosions.add(explosionEvent);
            this.explosionEvents.add(this.combineCollidingExplosions(collidingExplosions, explosionEvent, world));
        }
    }

    private boolean shouldHealExplosion(class_1927 explosion) {
        class_1309 causingLivingEntity = explosion.method_8347();
        class_1297 causingEntity = ((ExplosionAccessor)explosion).creeper_healing$getEntity();
        class_1282 damageSource = ((ExplosionAccessor)explosion).creeper_healing$getDamageSource();
        if (explosion.method_8346().isEmpty()) {
            return false;
        }
        boolean shouldHealExplosion = false;
        if (causingLivingEntity instanceof class_1548 && ExplosionSourceConfig.HEAL_CREEPER_EXPLOSIONS.getEntry().getValue().booleanValue()) {
            shouldHealExplosion = true;
        } else if (causingLivingEntity instanceof class_1571 && ExplosionSourceConfig.HEAL_GHAST_EXPLOSIONS.getEntry().getValue().booleanValue()) {
            shouldHealExplosion = true;
        } else if (causingLivingEntity instanceof class_1528 && ExplosionSourceConfig.HEAL_WITHER_EXPLOSIONS.getEntry().getValue().booleanValue()) {
            shouldHealExplosion = true;
        } else if (causingEntity instanceof class_1541 && ExplosionSourceConfig.HEAL_TNT_EXPLOSIONS.getEntry().getValue().booleanValue()) {
            shouldHealExplosion = true;
        } else if (causingEntity instanceof class_1701 && ExplosionSourceConfig.HEAL_TNT_MINECART_EXPLOSIONS.getEntry().getValue().booleanValue()) {
            shouldHealExplosion = true;
        } else if (damageSource instanceof class_1286 && ExplosionSourceConfig.HEAL_BED_AND_RESPAWN_ANCHOR_EXPLOSIONS.getEntry().getValue().booleanValue()) {
            shouldHealExplosion = true;
        } else if (causingEntity instanceof class_1511 && ExplosionSourceConfig.HEAL_END_CRYSTAL_EXPLOSIONS.getEntry().getValue().booleanValue()) {
            shouldHealExplosion = true;
        }
        return shouldHealExplosion;
    }

    private Set<AbstractExplosionEvent> getCollidingExplosions(List<class_2338> affectedPositions) {
        LinkedHashSet<AbstractExplosionEvent> collidingExplosions = new LinkedHashSet<AbstractExplosionEvent>();
        class_2338 centerOfNewExplosion = new class_2338(ExplosionUtils.getCenterXCoordinate(affectedPositions), ExplosionUtils.getCenterYCoordinate(affectedPositions), ExplosionUtils.getCenterZCoordinate(affectedPositions));
        int newExplosionAverageRadius = ExplosionUtils.getMaxExplosionRadius(affectedPositions);
        for (AbstractExplosionEvent explosionEvent : this.explosionEvents) {
            if (explosionEvent.getHealTimer() <= 0L) continue;
            List<class_2338> affectedBlocksAsPositions = explosionEvent.getAffectedBlocks().stream().map(AffectedBlock::getPos).toList();
            class_2338 centerOfCurrentExplosion = new class_2338(ExplosionUtils.getCenterXCoordinate(affectedBlocksAsPositions), ExplosionUtils.getCenterYCoordinate(affectedBlocksAsPositions), ExplosionUtils.getCenterZCoordinate(affectedBlocksAsPositions));
            int currentExplosionAverageRadius = ExplosionUtils.getMaxExplosionRadius(affectedBlocksAsPositions);
            if (!(Math.floor(Math.sqrt(centerOfNewExplosion.method_10262((class_2382)centerOfCurrentExplosion))) <= (double)(newExplosionAverageRadius + currentExplosionAverageRadius))) continue;
            collidingExplosions.add(explosionEvent);
        }
        return collidingExplosions;
    }

    private AbstractExplosionEvent combineCollidingExplosions(Set<AbstractExplosionEvent> collidingExplosions, AbstractExplosionEvent newestExplosion, class_1937 world) {
        List<AffectedBlock> combinedAffectedBlockList = collidingExplosions.stream().flatMap(explosionEvent -> explosionEvent.getAffectedBlocks().stream()).collect(Collectors.toList());
        List<AffectedBlock> sortedAffectedBlocks = ExplosionUtils.sortAffectedBlocksList(combinedAffectedBlockList, world);
        AbstractExplosionEvent combinedExplosionEvent = newestExplosion instanceof DaytimeExplosionEvent ? new DaytimeExplosionEvent(sortedAffectedBlocks, newestExplosion.getHealTimer(), newestExplosion.getBlockCounter()) : (newestExplosion instanceof DifficultyBasedExplosionEvent ? new DifficultyBasedExplosionEvent(sortedAffectedBlocks, newestExplosion.getHealTimer(), newestExplosion.getBlockCounter()) : (newestExplosion instanceof BlastResistanceBasedExplosionEvent ? new BlastResistanceBasedExplosionEvent(sortedAffectedBlocks, newestExplosion.getHealTimer(), newestExplosion.getBlockCounter()) : new DefaultExplosionEvent(sortedAffectedBlocks, newestExplosion.getHealTimer(), newestExplosion.getBlockCounter())));
        combinedExplosionEvent.getAffectedBlocks().forEach(affectedBlock -> affectedBlock.setTimer(DelaysConfig.getBlockPlacementDelayAsTicks()));
        ((AbstractExplosionEvent)combinedExplosionEvent).setupExplosion(world);
        return combinedExplosionEvent;
    }

    public void tick(MinecraftServer server) {
        if (this.explosionEvents.isEmpty()) {
            return;
        }
        this.explosionEvents.forEach(AbstractExplosionEvent::tick);
        for (AbstractExplosionEvent explosionEvent : this.explosionEvents) {
            if (explosionEvent.getHealTimer() >= 0L) continue;
            this.onExplosionEventFinishedTimer(explosionEvent, server);
        }
    }

    private void onExplosionEventFinishedTimer(AbstractExplosionEvent currentExplosion, MinecraftServer server) {
        Optional<AffectedBlock> optionalAffectedBlock = currentExplosion.getCurrentAffectedBlock();
        if (optionalAffectedBlock.isEmpty()) {
            this.explosionEvents.remove(currentExplosion);
            return;
        }
        AffectedBlock affectedBlock = optionalAffectedBlock.get();
        if (affectedBlock.isPlaced()) {
            currentExplosion.incrementCounter();
            return;
        }
        if (!affectedBlock.canBePlaced(server)) {
            currentExplosion.delayAffectedBlock(affectedBlock, server);
            return;
        }
        affectedBlock.tickAffectedBlock();
        if (affectedBlock.getTimer() < 0L) {
            this.onAffectedBlockFinishedTimer(affectedBlock, currentExplosion, server);
        }
    }

    private void onAffectedBlockFinishedTimer(AffectedBlock currentedAffectedBlock, AbstractExplosionEvent currentExplosion, MinecraftServer server) {
        if (!currentExplosion.shouldKeepHealing(currentedAffectedBlock.getWorld(server))) {
            this.explosionEvents.remove(currentExplosion);
            return;
        }
        currentedAffectedBlock.tryHealing(server, currentExplosion);
        currentedAffectedBlock.setPlaced();
        currentExplosion.incrementCounter();
    }

    public void storeExplosions(MinecraftServer server) {
        Path scheduledExplosionsFilePath = server.method_27050(class_5218.field_24188).resolve("scheduled-explosions.json");
        DataResult encodedScheduledExplosions = CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this);
        if (encodedScheduledExplosions.result().isPresent()) {
            JsonElement scheduledExplosionsJson = (JsonElement)encodedScheduledExplosions.resultOrPartial(arg_0 -> ((Logger)CreeperHealing.LOGGER).error(arg_0)).orElseThrow();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String jsonString = gson.toJson(scheduledExplosionsJson);
            try (BufferedWriter bf = Files.newBufferedWriter(scheduledExplosionsFilePath, new OpenOption[0]);){
                bf.write(jsonString);
                CreeperHealing.LOGGER.info("Stored {} explosion event(s) to {}", (Object)this.explosionEvents.size(), (Object)scheduledExplosionsFilePath);
            }
            catch (IOException e) {
                CreeperHealing.LOGGER.error("Error storing explosion event(s): " + e);
            }
        } else {
            CreeperHealing.LOGGER.error("Error storing creeper explosion(s): No value present");
        }
    }

    public void readExplosionEvents(MinecraftServer server) {
        block9: {
            Path scheduledExplosionsFilePath = server.method_27050(class_5218.field_24188).resolve("scheduled-explosions.json");
            try {
                if (Files.exists(scheduledExplosionsFilePath, new LinkOption[0])) {
                    try (BufferedReader br = Files.newBufferedReader(scheduledExplosionsFilePath);){
                        JsonElement scheduledExplosionsJson = JsonParser.parseReader((Reader)br);
                        DataResult decodedExplosionManger = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)scheduledExplosionsJson);
                        decodedExplosionManger.resultOrPartial(error -> CreeperHealing.LOGGER.error("Error reading scheduled explosions: {}", error)).ifPresent(explosionManager -> {
                            instance = explosionManager;
                        });
                        break block9;
                    }
                }
                CreeperHealing.LOGGER.warn("Scheduled explosions file not found. Creating new one at {}", (Object)scheduledExplosionsFilePath);
                Files.createFile(scheduledExplosionsFilePath, new FileAttribute[0]);
            }
            catch (IOException e) {
                CreeperHealing.LOGGER.error("Error reading scheduled explosions: " + e);
            }
        }
    }

    public void updateAffectedBlocksTimers() {
        for (AbstractExplosionEvent explosionEvent : this.explosionEvents) {
            if (!(explosionEvent instanceof DefaultExplosionEvent)) continue;
            for (int i = explosionEvent.getBlockCounter() + 1; i < explosionEvent.getAffectedBlocks().size(); ++i) {
                explosionEvent.getAffectedBlocks().get(i).setTimer(DelaysConfig.getBlockPlacementDelayAsTicks());
            }
        }
    }
}

