/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ipi.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.lopymine.mossylib.loader.MossyLoader;
import net.lopymine.mossylib.utils.CodecUtils;
import net.lopymine.mossylib.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryInteractionsConfig {
    public static final Codec<InventoryInteractionsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.option((String)"mod_enabled", (Object)true, (Codec)Codec.BOOL, InventoryInteractionsConfig::isModEnabled), (App)CodecUtils.option((String)"debug_mode_enabled", (Object)false, (Codec)Codec.BOOL, InventoryInteractionsConfig::isDebugModeEnabled)).apply((Applicative)instance, InventoryInteractionsConfig::new));
    private static final File CONFIG_FILE = MossyLoader.getConfigDir().resolve("inventory_interactions.json5").toFile();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Inventory Interactions/Config");
    private static InventoryInteractionsConfig INSTANCE;
    private boolean modEnabled;
    private boolean debugModeEnabled;

    private InventoryInteractionsConfig() {
        throw new IllegalArgumentException();
    }

    public static InventoryInteractionsConfig getInstance() {
        return INSTANCE == null ? InventoryInteractionsConfig.reload() : INSTANCE;
    }

    public static InventoryInteractionsConfig reload() {
        INSTANCE = InventoryInteractionsConfig.read();
        return INSTANCE;
    }

    public static InventoryInteractionsConfig getNewInstance() {
        return (InventoryInteractionsConfig)CodecUtils.parseNewInstanceHacky(CODEC);
    }

    private static InventoryInteractionsConfig read() {
        return (InventoryInteractionsConfig)ConfigUtils.readConfig(CODEC, (File)CONFIG_FILE, (Logger)LOGGER);
    }

    public void saveAsync() {
        CompletableFuture.runAsync(this::save);
    }

    public void save() {
        ConfigUtils.saveConfig((Object)this, CODEC, (File)CONFIG_FILE, (Logger)LOGGER);
    }

    @Generated
    public boolean isModEnabled() {
        return this.modEnabled;
    }

    @Generated
    public boolean isDebugModeEnabled() {
        return this.debugModeEnabled;
    }

    @Generated
    public void setModEnabled(boolean modEnabled) {
        this.modEnabled = modEnabled;
    }

    @Generated
    public void setDebugModeEnabled(boolean debugModeEnabled) {
        this.debugModeEnabled = debugModeEnabled;
    }

    @Generated
    public InventoryInteractionsConfig(boolean modEnabled, boolean debugModeEnabled) {
        this.modEnabled = modEnabled;
        this.debugModeEnabled = debugModeEnabled;
    }
}

