/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ipi.config.base.model;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import lombok.Generated;
import net.lopymine.ipi.InventoryInteractions;
import net.lopymine.ipi.config.base.RawItemBaseConfig;
import net.lopymine.ipi.config.physics.ItemPhysicsConfig;
import net.lopymine.mossylib.utils.CodecUtils;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class RawItemModelConfig {
    public static final ResourceLocation NO_MODEL_TEXTURE = InventoryInteractions.id("raw_item_model_no_texture");
    public static final Codec<RawItemModelConfig> CODEC = CodecUtils.recursive((String)"custom model config codec", codec -> RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.option((String)"model_texture", (Object)NO_MODEL_TEXTURE, (Codec)ResourceLocation.CODEC, RawItemModelConfig::getModelTexture), (App)CodecUtils.option((String)"base_texture", (Object)RawItemBaseConfig.DEFAULT_BASE_TEXTURE, (Codec)ResourceLocation.CODEC, RawItemModelConfig::getBaseTexture), (App)CodecUtils.option((String)"physics", ItemPhysicsConfig.getNewInstance(), ItemPhysicsConfig.CODEC, RawItemModelConfig::getPhysicsConfig), (App)CodecUtils.option((String)"model_part", (Object)new RawItemModelConfig(), (Codec)codec, RawItemModelConfig::getModelPartConfig)).apply((Applicative)instance, RawItemModelConfig::new)));
    public static RawItemModelConfig DUMMY_MODEL = RawItemModelConfig.getNewInstance().get();
    private ResourceLocation modelTexture;
    private ResourceLocation baseTexture;
    private ItemPhysicsConfig physicsConfig;
    @Nullable
    private RawItemModelConfig modelPartConfig;

    public RawItemModelConfig() {
        this.modelTexture = NO_MODEL_TEXTURE;
        this.baseTexture = RawItemBaseConfig.DEFAULT_BASE_TEXTURE;
        this.physicsConfig = ItemPhysicsConfig.getNewInstance().get();
        this.modelPartConfig = null;
    }

    public static Supplier<RawItemModelConfig> getNewInstance() {
        return () -> (RawItemModelConfig)CodecUtils.parseNewInstanceHacky(CODEC);
    }

    public ResourceLocation getBaseTextureInFolder() {
        return InventoryInteractions.id("textures/i-interactions/%s".formatted(this.baseTexture.getPath()));
    }

    @Generated
    public ResourceLocation getModelTexture() {
        return this.modelTexture;
    }

    @Generated
    public ResourceLocation getBaseTexture() {
        return this.baseTexture;
    }

    @Generated
    public ItemPhysicsConfig getPhysicsConfig() {
        return this.physicsConfig;
    }

    @Nullable
    @Generated
    public RawItemModelConfig getModelPartConfig() {
        return this.modelPartConfig;
    }

    @Generated
    public void setModelTexture(ResourceLocation modelTexture) {
        this.modelTexture = modelTexture;
    }

    @Generated
    public void setBaseTexture(ResourceLocation baseTexture) {
        this.baseTexture = baseTexture;
    }

    @Generated
    public void setPhysicsConfig(ItemPhysicsConfig physicsConfig) {
        this.physicsConfig = physicsConfig;
    }

    @Generated
    public void setModelPartConfig(@Nullable RawItemModelConfig modelPartConfig) {
        this.modelPartConfig = modelPartConfig;
    }

    @Generated
    public RawItemModelConfig(ResourceLocation modelTexture, ResourceLocation baseTexture, ItemPhysicsConfig physicsConfig, @Nullable RawItemModelConfig modelPartConfig) {
        this.modelTexture = modelTexture;
        this.baseTexture = baseTexture;
        this.physicsConfig = physicsConfig;
        this.modelPartConfig = modelPartConfig;
    }
}

