/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ipi.renderer;

import lombok.Generated;
import net.lopymine.ip.element.InventoryCursor;
import net.lopymine.ip.element.base.IMovableElement;
import net.lopymine.ip.renderer.InventoryParticlesRenderer;
import net.lopymine.ipi.base.BaseConfigsManager;
import net.lopymine.ipi.config.base.model.CursorItemModel;
import net.lopymine.ipi.renderer.CursorItemPart;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class CursorItemRenderer {
    private static final CursorItemRenderer INSTANCE = new CursorItemRenderer();
    private final CursorItemPart cursorItem = new CursorItemPart();

    private CursorItemRenderer() {
    }

    public static CursorItemRenderer getInstance() {
        return INSTANCE;
    }

    public void render(GuiGraphics context, ItemStack stack, int mouseX, int mouseY, int originalX, int originalY, Renderer drawItem) {
        Item item = stack.getItem();
        if (item == Items.AIR) {
            drawItem.run(originalX, originalY);
            return;
        }
        InventoryCursor cursor = InventoryParticlesRenderer.getInstance().getCursor();
        cursor.setMouseX((double)mouseX);
        cursor.setMouseY((double)mouseY);
        this.update(stack.getItem(), (IMovableElement)cursor);
        float tickProgress = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        this.cursorItem.render(context, tickProgress, drawItem);
    }

    public void update(Item item, IMovableElement pivot) {
        if (!this.cursorItem.isItemChanged(item)) {
            return;
        }
        CursorItemModel config = item == Items.AIR ? BaseConfigsManager.STANDARD_MODEL : BaseConfigsManager.get(item);
        this.cursorItem.reset(item, config, pivot.getX(), pivot.getY());
    }

    public void tick(ItemStack stack, IMovableElement pivot) {
        boolean empty;
        CursorItemRenderer.getInstance().update(stack.getItem(), pivot);
        boolean bl = empty = this.cursorItem.getItem() == Items.AIR || stack.isEmpty();
        if (empty) {
            return;
        }
        this.cursorItem.tick(pivot);
    }

    @Generated
    public CursorItemPart getCursorItem() {
        return this.cursorItem;
    }

    public static interface Renderer {
        public void run(int var1, int var2);
    }
}

