/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ipi.renderer;

import lombok.Generated;
import net.lopymine.ip.element.InventoryCursor;
import net.lopymine.ip.element.base.IMovableElement;
import net.lopymine.ip.renderer.InventoryParticlesRenderer;
import net.lopymine.ipi.base.BaseConfigsManager;
import net.lopymine.ipi.config.base.model.CursorItemModel;
import net.lopymine.ipi.renderer.CursorItemPart;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class CursorItemRenderer {
    private static final CursorItemRenderer INSTANCE = new CursorItemRenderer();
    private final CursorItemPart cursorItem = new CursorItemPart();

    private CursorItemRenderer() {
    }

    public static CursorItemRenderer getInstance() {
        return INSTANCE;
    }

    public void render(class_332 context, class_1799 stack, int mouseX, int mouseY, int originalX, int originalY, Renderer drawItem) {
        class_1792 item = stack.method_7909();
        if (item == class_1802.field_8162) {
            drawItem.run(originalX, originalY);
            return;
        }
        InventoryCursor cursor = InventoryParticlesRenderer.getInstance().getCursor();
        cursor.setMouseX((double)mouseX);
        cursor.setMouseY((double)mouseY);
        this.update(stack.method_7909(), (IMovableElement)cursor);
        float tickProgress = class_310.method_1551().method_60646().method_60637(true);
        this.cursorItem.render(context, tickProgress, drawItem);
    }

    public void update(class_1792 item, IMovableElement pivot) {
        if (!this.cursorItem.isItemChanged(item)) {
            return;
        }
        CursorItemModel config = item == class_1802.field_8162 ? BaseConfigsManager.STANDARD_MODEL : BaseConfigsManager.get(item);
        this.cursorItem.reset(item, config, pivot.getX(), pivot.getY());
    }

    public void tick(class_1799 stack, IMovableElement pivot) {
        boolean empty;
        CursorItemRenderer.getInstance().update(stack.method_7909(), pivot);
        boolean bl = empty = this.cursorItem.getItem() == class_1802.field_8162 || stack.method_7960();
        if (empty) {
            return;
        }
        this.cursorItem.tick(pivot);
    }

    @Generated
    public CursorItemPart getCursorItem() {
        return this.cursorItem;
    }

    public static interface Renderer {
        public void run(int var1, int var2);
    }
}

