/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ipi.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.lopymine.ip.element.InventoryParticle;
import net.lopymine.ip.spawner.IParticleSpawnPos;
import net.lopymine.ip.spawner.ParticleSpawnArea;
import net.lopymine.ip.spawner.ParticleSpawner;
import net.lopymine.ip.spawner.context.ParticleSpawnContext;
import net.lopymine.ipi.config.InventoryInteractionsConfig;
import net.lopymine.ipi.config.base.ItemOffset;
import net.lopymine.ipi.renderer.CursorItemPart;
import net.lopymine.ipi.renderer.CursorItemRenderer;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={ParticleSpawner.class})
public class InventoryParticleMixin {
    @Shadow
    @Nullable
    private ParticleSpawnArea spawnArea;

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/lopymine/ip/spawner/ParticleSpawner;offsetParticlePos(Lnet/lopymine/ip/element/InventoryParticle;)V", remap=false)}, method={"createParticles(ILnet/lopymine/ip/spawner/context/ParticleSpawnContext;Ljava/util/function/Consumer;)Ljava/util/List;"}, remap=false)
    private void offsetParticlePosWithRotation(ParticleSpawner instance, InventoryParticle particle, Operation<Void> original, @Local(argsOnly=true) ParticleSpawnContext context) {
        if (!InventoryInteractionsConfig.getInstance().isModEnabled()) {
            original.call(new Object[]{instance, particle});
            return;
        }
        if (context != ParticleSpawnContext.CURSOR_CONTEXT) {
            original.call(new Object[]{instance, particle});
            return;
        }
        CursorItemPart cursorItem = CursorItemRenderer.getInstance().getCursorItem();
        ItemOffset massCenter = cursorItem.getMassCenter();
        IParticleSpawnPos particleSpawnPos = this.spawnArea == null ? null : this.spawnArea.getRandomPos(particle.getRandom());
        double xOffset = (double)(4.0f - (float)massCenter.getOffsetX()) - particle.getWidth() / 2.0 + (double)(particleSpawnPos != null ? -particleSpawnPos.getXOffset() + particleSpawnPos.x() : 0);
        double yOffset = (double)(4.0f - (float)massCenter.getOffsetY()) - particle.getHeight() / 2.0 + (double)(particleSpawnPos != null ? -particleSpawnPos.getYOffset() + particleSpawnPos.y() : 0);
        float tickProgress = Minecraft.m_91087_().m_91296_();
        double radians = Math.toRadians(cursorItem.getRenderAngle(tickProgress));
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double x = cursorItem.getRenderX(tickProgress);
        double y = cursorItem.getRenderY(tickProgress);
        double rotatedX = xOffset * cos - yOffset * sin;
        double rotatedY = xOffset * sin + yOffset * cos;
        particle.setX(x - 4.0 + rotatedX);
        particle.setY(y - 4.0 + rotatedY);
        particle.setLastX(particle.getX());
        particle.setLastY(particle.getY());
    }
}

