/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.ipi.renderer;

import lombok.Generated;
import net.lopymine.ip.element.base.IMovableElement;
import net.lopymine.ip.element.base.IRotatableElement;
import net.lopymine.ip.element.base.TickElement;
import net.lopymine.ipi.base.BaseConfigsManager;
import net.lopymine.ipi.config.InventoryInteractionsConfig;
import net.lopymine.ipi.config.base.ItemOffset;
import net.lopymine.ipi.config.base.RawItemBaseConfig;
import net.lopymine.ipi.config.base.model.CursorItemModel;
import net.lopymine.ipi.config.physics.ItemPhysicsConfig;
import net.lopymine.ipi.renderer.CursorItemRenderer;
import net.lopymine.mossylib.extension.DrawContextExtension;
import net.lopymine.mossylib.utils.ArgbUtils;
import net.lopymine.mossylib.utils.DrawUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class CursorItemPart
extends TickElement
implements IMovableElement,
IRotatableElement {
    protected ItemPhysicsConfig physicsConfig = BaseConfigsManager.STANDARD_MODEL.getPhysicsConfig();
    protected ItemOffset massCenter = BaseConfigsManager.STANDARD_MODEL.getMassCenter();
    protected ItemOffset partConnectionCenter = BaseConfigsManager.STANDARD_MODEL.getPartConnectionCenter();
    @Nullable
    protected ItemOffset nextPartConnectionCenter = BaseConfigsManager.STANDARD_MODEL.getNextPartConnectionCenter();
    protected double radius = 0.0;
    protected Item item = Items.f_41852_;
    protected double x = 0.0;
    protected double y = 0.0;
    protected double lastX = 0.0;
    protected double lastY = 0.0;
    protected double speedX = 0.0;
    protected double speedY = 0.0;
    protected double angle = 0.0;
    protected double lastAngle = 0.0;
    protected double lastCursorSpeedX = 0.0;
    protected double lastCursorSpeedY = 0.0;
    @Nullable
    private CursorItemPart part;
    @Nullable
    private ResourceLocation overrideTexture;

    public void reset(Item item, CursorItemModel model, double pivotX, double pivotY) {
        this.physicsConfig = model.getPhysicsConfig();
        this.massCenter = model.getMassCenter();
        this.partConnectionCenter = model.getPartConnectionCenter();
        this.nextPartConnectionCenter = model.getNextPartConnectionCenter();
        this.radius = model.getRadius();
        this.item = item;
        double radius = model.getRadius();
        ItemOffset massCenter = model.getMassCenter();
        ItemOffset grabCenter = model.getPartConnectionCenter();
        double cos = (double)(massCenter.x() - grabCenter.x()) / radius;
        double sin = (double)(massCenter.y() - grabCenter.y()) / radius;
        this.x = pivotX + cos * radius;
        this.y = pivotY + sin * radius;
        this.lastX = this.x;
        this.lastY = this.y;
        this.speedX = 0.0;
        this.speedY = 0.0;
        double angleDeg = Math.toDegrees(Math.atan2(this.y - pivotY, this.x - pivotX));
        this.lastAngle = this.angle = this.normalize360(angleDeg);
        this.part = null;
        CursorItemModel partModel = model.getPartModel();
        if (partModel != null) {
            CursorItemPart part = new CursorItemPart();
            ItemOffset offset = this.nextPartConnectionCenter == null ? BaseConfigsManager.NO_PART_CONNECTION_POS : this.nextPartConnectionCenter;
            part.reset(item, partModel, this.x + (double)offset.getOffsetX(), this.y + (double)offset.getOffsetY());
            this.part = part;
        }
        this.overrideTexture = model.getModelTexture();
    }

    public void render(GuiGraphics context, float tickProgress, CursorItemRenderer.Renderer drawItem) {
        float renderX = this.getRenderX(tickProgress);
        float renderY = this.getRenderY(tickProgress);
        float renderAngle = this.getRenderAngle(tickProgress);
        DrawContextExtension.push((GuiGraphics)context);
        DrawContextExtension.translate((GuiGraphics)context, (float)renderX, (float)renderY, (float)0.0f);
        DrawContextExtension.rotateZ((GuiGraphics)context, (float)renderAngle);
        DrawContextExtension.translate((GuiGraphics)context, (float)((float)(-this.massCenter.getOffsetX()) - 0.5f), (float)((float)(-this.massCenter.getOffsetY()) - 0.5f), (float)0.0f);
        if (this.overrideTexture == null) {
            drawItem.run(0, 0);
        } else {
            DrawUtils.drawTexture((GuiGraphics)context, (ResourceLocation)this.overrideTexture, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
        this.renderDebugDots(context, this.massCenter, this.partConnectionCenter);
        DrawContextExtension.pop((GuiGraphics)context);
        this.renderDebugItemPosition(context, renderX, renderY);
        if (this.part != null) {
            this.part.render(context, tickProgress, drawItem);
        }
    }

    private void renderDebugDots(GuiGraphics context, ItemOffset massCenter, ItemOffset grabCenter) {
        if (!InventoryInteractionsConfig.getInstance().isDebugModeEnabled()) {
            return;
        }
        context.m_280509_(0, 0, 1, 1, ArgbUtils.getArgb((int)255, (int)255, (int)255, (int)0));
        context.m_280509_(massCenter.getOffsetX(), massCenter.getOffsetY(), massCenter.getOffsetX() + 2, massCenter.getOffsetY() + 2, RawItemBaseConfig.SHAPE_COLOR);
        context.m_280509_(grabCenter.getOffsetX(), grabCenter.getOffsetY(), grabCenter.getOffsetX() + 1, grabCenter.getOffsetY() + 1, RawItemBaseConfig.PART_CONNECTION_COLOR);
    }

    private void renderDebugItemPosition(GuiGraphics context, float renderX, float renderY) {
        if (!InventoryInteractionsConfig.getInstance().isDebugModeEnabled()) {
            return;
        }
        DrawContextExtension.push((GuiGraphics)context);
        DrawContextExtension.translate((GuiGraphics)context, (float)renderX, (float)renderY, (float)0.0f);
        context.m_280509_(0, 0, 3, 3, ArgbUtils.getArgb((int)255, (int)255, (int)255, (int)255));
        DrawContextExtension.pop((GuiGraphics)context);
    }

    public float getRenderAngle(float tickProgress) {
        float angle = (float)(this.lastAngle + Mth.m_14175_((double)(this.angle - this.lastAngle)) * (double)tickProgress);
        double localX = this.massCenter.x() - this.partConnectionCenter.x();
        double localY = this.massCenter.y() - this.partConnectionCenter.y();
        double localAngle = Math.toDegrees(Math.atan2(localY, localX));
        return (float)this.normalize360((double)angle - localAngle);
    }

    public float getRenderX(float tickProgress) {
        return (float)Mth.m_14139_((double)tickProgress, (double)this.lastX, (double)this.x);
    }

    public float getRenderY(float tickProgress) {
        return (float)Mth.m_14139_((double)tickProgress, (double)this.lastY, (double)this.y);
    }

    private double normalize360(double angle) {
        if ((angle %= 360.0) < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public void tick(IMovableElement pivot) {
        this.lastAngle = this.angle;
        super.tick();
        this.applyNativeSpeed();
        this.applyPivotImpulse(pivot);
        this.goBack(pivot);
        this.angle = this.normalize360(this.calculateAngleFromCursor2Item(pivot));
        if (this.part != null) {
            this.part.tick(this);
        }
    }

    private void applyNativeSpeed() {
        this.speedX = this.x - this.lastX;
        this.speedY = this.y - this.lastY;
        double braking = this.physicsConfig.getBraking();
        this.speedX *= braking;
        this.speedY *= braking;
        this.speedY += 0.5 * this.physicsConfig.getGravity();
        this.lastX = this.x;
        this.lastY = this.y;
        this.x += this.speedX;
        this.y += this.speedY;
    }

    private float calculateAngleFromCursor2Item(IMovableElement pivot) {
        double pivotX = pivot.getX();
        double pivotY = pivot.getY();
        double relativeX = this.x - pivotX;
        double relativeY = this.y - pivotY;
        return (float)Math.toDegrees(Math.atan2(relativeY, relativeX));
    }

    private void goBack(IMovableElement pivot) {
        double pivotY;
        double relativeY;
        double pivotX = pivot.getX();
        double relativeX = this.x - pivotX;
        double distance = Math.sqrt(relativeX * relativeX + (relativeY = this.y - (pivotY = pivot.getY())) * relativeY);
        if (distance != 0.0) {
            double difference = (this.radius - distance) / distance;
            this.x += relativeX * difference;
            this.y += relativeY * difference;
        }
    }

    private void applyPivotImpulse(IMovableElement pivot) {
        double cursorSpeedX = pivot.getSpeedX();
        double cursorSpeedY = pivot.getSpeedY();
        double pivotX = pivot.getX();
        double pivotY = pivot.getY();
        double cursorAccelerationX = cursorSpeedX - this.lastCursorSpeedX;
        double cursorAccelerationY = cursorSpeedY - this.lastCursorSpeedY;
        this.lastCursorSpeedX = cursorSpeedX;
        this.lastCursorSpeedY = cursorSpeedY;
        double relativeX = this.x - pivotX;
        double relativeY = this.y - pivotY;
        double distance = Math.sqrt(relativeX * relativeX + relativeY * relativeY);
        if (distance > 1.0E-6) {
            double dx = -(relativeY /= distance);
            double dy = relativeX /= distance;
            double acceleration = cursorAccelerationX * dx + cursorAccelerationY * dy;
            double impulse = 0.1 * this.physicsConfig.getCursorImpulseInheritCoefficient();
            this.x += dx * acceleration * impulse;
            this.y += dy * acceleration * impulse;
        }
    }

    public boolean isItemChanged(Item item) {
        return this.item != item;
    }

    @Generated
    public ItemPhysicsConfig getPhysicsConfig() {
        return this.physicsConfig;
    }

    @Generated
    public ItemOffset getMassCenter() {
        return this.massCenter;
    }

    @Generated
    public ItemOffset getPartConnectionCenter() {
        return this.partConnectionCenter;
    }

    @Nullable
    @Generated
    public ItemOffset getNextPartConnectionCenter() {
        return this.nextPartConnectionCenter;
    }

    @Generated
    public double getRadius() {
        return this.radius;
    }

    @Generated
    public Item getItem() {
        return this.item;
    }

    @Generated
    public double getX() {
        return this.x;
    }

    @Generated
    public double getY() {
        return this.y;
    }

    @Generated
    public double getLastX() {
        return this.lastX;
    }

    @Generated
    public double getLastY() {
        return this.lastY;
    }

    @Generated
    public double getSpeedX() {
        return this.speedX;
    }

    @Generated
    public double getSpeedY() {
        return this.speedY;
    }

    @Generated
    public double getAngle() {
        return this.angle;
    }

    @Generated
    public double getLastAngle() {
        return this.lastAngle;
    }

    @Generated
    public double getLastCursorSpeedX() {
        return this.lastCursorSpeedX;
    }

    @Generated
    public double getLastCursorSpeedY() {
        return this.lastCursorSpeedY;
    }

    @Nullable
    @Generated
    public CursorItemPart getPart() {
        return this.part;
    }

    @Nullable
    @Generated
    public ResourceLocation getOverrideTexture() {
        return this.overrideTexture;
    }

    @Generated
    public void setPhysicsConfig(ItemPhysicsConfig physicsConfig) {
        this.physicsConfig = physicsConfig;
    }

    @Generated
    public void setMassCenter(ItemOffset massCenter) {
        this.massCenter = massCenter;
    }

    @Generated
    public void setPartConnectionCenter(ItemOffset partConnectionCenter) {
        this.partConnectionCenter = partConnectionCenter;
    }

    @Generated
    public void setNextPartConnectionCenter(@Nullable ItemOffset nextPartConnectionCenter) {
        this.nextPartConnectionCenter = nextPartConnectionCenter;
    }

    @Generated
    public void setRadius(double radius) {
        this.radius = radius;
    }

    @Generated
    public void setItem(Item item) {
        this.item = item;
    }

    @Generated
    public void setX(double x) {
        this.x = x;
    }

    @Generated
    public void setY(double y) {
        this.y = y;
    }

    @Generated
    public void setLastX(double lastX) {
        this.lastX = lastX;
    }

    @Generated
    public void setLastY(double lastY) {
        this.lastY = lastY;
    }

    @Generated
    public void setSpeedX(double speedX) {
        this.speedX = speedX;
    }

    @Generated
    public void setSpeedY(double speedY) {
        this.speedY = speedY;
    }

    @Generated
    public void setAngle(double angle) {
        this.angle = angle;
    }

    @Generated
    public void setLastAngle(double lastAngle) {
        this.lastAngle = lastAngle;
    }

    @Generated
    public void setLastCursorSpeedX(double lastCursorSpeedX) {
        this.lastCursorSpeedX = lastCursorSpeedX;
    }

    @Generated
    public void setLastCursorSpeedY(double lastCursorSpeedY) {
        this.lastCursorSpeedY = lastCursorSpeedY;
    }

    @Generated
    public void setPart(@Nullable CursorItemPart part) {
        this.part = part;
    }

    @Generated
    public void setOverrideTexture(@Nullable ResourceLocation overrideTexture) {
        this.overrideTexture = overrideTexture;
    }
}

