/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.api.primitive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import org.confluence.terra_curio.api.primitive.CombineRule;
import org.confluence.terra_curio.api.primitive.PrimitiveValue;

public record AttributeModifiersValue(ImmutableListMultimap<Holder<Attribute>, AttributeModifier> value) implements PrimitiveValue<ImmutableListMultimap<Holder<Attribute>, AttributeModifier>>
{
    public static final AttributeModifiersValue EMPTY = new AttributeModifiersValue((ImmutableListMultimap<Holder<Attribute>, AttributeModifier>)ImmutableListMultimap.of());
    public static final Codec<AttributeModifiersValue> CODEC = Codec.unboundedMap((Codec)RegistryFixedCodec.create((ResourceKey)Registries.ATTRIBUTE), (Codec)AttributeModifier.MAP_CODEC.codec().listOf()).xmap(map -> {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Map.Entry entry : map.entrySet()) {
            builder.putAll((Object)((Holder)entry.getKey()), (Iterable)entry.getValue());
        }
        return new AttributeModifiersValue((ImmutableListMultimap<Holder<Attribute>, AttributeModifier>)builder.build());
    }, pv -> {
        Hashtable<Holder, ImmutableList> map = new Hashtable<Holder, ImmutableList>();
        for (Holder holder : pv.value.keySet()) {
            map.put(holder, pv.value.get((Object)holder));
        }
        return map;
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, AttributeModifiersValue> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, AttributeModifiersValue>(){

        public AttributeModifiersValue decode(RegistryFriendlyByteBuf buffer) {
            int size = buffer.readInt();
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (int i = 0; i < size; ++i) {
                Holder holder = (Holder)Attribute.STREAM_CODEC.decode((Object)buffer);
                int amount = buffer.readInt();
                for (int j = 0; j < amount; ++j) {
                    builder.put((Object)holder, (Object)((AttributeModifier)AttributeModifier.STREAM_CODEC.decode((Object)buffer)));
                }
            }
            return new AttributeModifiersValue((ImmutableListMultimap<Holder<Attribute>, AttributeModifier>)builder.build());
        }

        public void encode(RegistryFriendlyByteBuf buffer, AttributeModifiersValue value) {
            buffer.writeInt(value.value.keySet().size());
            for (Map.Entry entry : value.value.asMap().entrySet()) {
                Attribute.STREAM_CODEC.encode((Object)buffer, (Object)((Holder)entry.getKey()));
                buffer.writeInt(((Collection)entry.getValue()).size());
                for (AttributeModifier modifier : (Collection)entry.getValue()) {
                    AttributeModifier.STREAM_CODEC.encode((Object)buffer, (Object)modifier);
                }
            }
        }
    };
    public static final CombineRule<ImmutableListMultimap<Holder<Attribute>, AttributeModifier>, AttributeModifiersValue> GET_SELF = CombineRule.register(PrimitiveValue.identity(), "attributes_modifiers_get_self");

    @Override
    public ImmutableListMultimap<Holder<Attribute>, AttributeModifier> get() {
        return this.value;
    }

    @Override
    public Codec<AttributeModifiersValue> codec() {
        return CODEC;
    }

    @Override
    public List<String> getDescription() {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : this.value.asMap().entrySet()) {
            list.add(BuiltInRegistries.ATTRIBUTE.getKey((Object)((Attribute)((Holder)entry.getKey()).value())).toString());
            for (AttributeModifier modifier : (Collection)entry.getValue()) {
                list.add("    " + String.valueOf(modifier));
            }
        }
        return list;
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        ImmutableListMultimap<Holder<Attribute>, AttributeModifier> value1;
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeModifiersValue)) return false;
        AttributeModifiersValue attributeModifiersValue = (AttributeModifiersValue)o;
        try {
            ImmutableListMultimap<Holder<Attribute>, AttributeModifier> immutableListMultimap;
            value1 = immutableListMultimap = attributeModifiersValue.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (!value1.equals(this.value)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.value);
    }
}

