/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.api.primitive;

import com.mojang.serialization.Codec;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.BiFunction;
import org.confluence.terra_curio.api.primitive.PrimitiveValue;

public abstract class CombineRule<T, V extends PrimitiveValue<T>> {
    public static final Map<String, CombineRule<?, ?>> RULES = new Hashtable();
    public static final Codec<CombineRule<?, ?>> CODEC = Codec.STRING.xmap(RULES::get, CombineRule::name);

    public abstract T combine(T var1, T var2);

    public T combineValue(V valueA, V valueB) {
        return this.combine(valueA.get(), valueB.get());
    }

    public T combineFromValue(V valueA, T componentB) {
        return this.combine(valueA.get(), componentB);
    }

    public T combineWithValue(T componentA, V valueB) {
        return this.combine(componentA, valueB.get());
    }

    public abstract String name();

    public static <T, V extends PrimitiveValue<T>> CombineRule<T, V> register(CombineRule<T, V> combineRule) {
        RULES.put(combineRule.name(), combineRule);
        return combineRule;
    }

    public static <T, V extends PrimitiveValue<T>> CombineRule<T, V> register(final BiFunction<T, T, T> combineFunc, final String name) {
        CombineRule combineRule = new CombineRule<T, V>(){

            @Override
            public T combine(T componentA, T componentB) {
                return combineFunc.apply(componentA, componentB);
            }

            @Override
            public String name() {
                return name;
            }
        };
        RULES.put(name, combineRule);
        return combineRule;
    }
}

