/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.api.primitive;

import com.mojang.serialization.Codec;
import net.minecraft.util.Mth;
import org.confluence.terra_curio.api.primitive.CombineRule;
import org.confluence.terra_curio.api.primitive.PrimitiveValue;

public final class FloatValue
implements PrimitiveValue<Float> {
    public static final Codec<FloatValue> CODEC = Codec.FLOAT.xmap(FloatValue::new, FloatValue::get);
    public static final CombineRule<Float, FloatValue> GET_SELF = CombineRule.register(PrimitiveValue.identity(), "float_get_self");
    public static final CombineRule<Float, FloatValue> GET_MAX = CombineRule.register(Math::max, "float_get_max");
    public static final CombineRule<Float, FloatValue> GET_MAX_WITHIN_0_TO_1 = CombineRule.register((a, b) -> Float.valueOf(Mth.clamp((float)Math.max(a.floatValue(), b.floatValue()), (float)0.0f, (float)1.0f)), "float_get_max_within_0_to_1");
    public static final CombineRule<Float, FloatValue> GET_MAX_WITHIN_0_TO_100 = CombineRule.register((a, b) -> Float.valueOf(Mth.clamp((float)Math.max(a.floatValue(), b.floatValue()), (float)0.0f, (float)100.0f)), "float_get_max_within_0_to_100");
    public static final CombineRule<Float, FloatValue> ADDITION = CombineRule.register(Float::sum, "float_addition");
    public static final CombineRule<Float, FloatValue> ADDITION_WITHIN_0_TO_1 = CombineRule.register((a, b) -> Float.valueOf(Mth.clamp((float)(a.floatValue() + b.floatValue()), (float)0.0f, (float)1.0f)), "float_addition_within_0_to_1");
    private final float value;

    public FloatValue(float value) {
        this.value = value;
    }

    @Override
    public Float get() {
        return Float.valueOf(this.value);
    }

    @Override
    public Codec<FloatValue> codec() {
        return CODEC;
    }
}

