/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.api.primitive;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import org.confluence.terra_curio.api.primitive.CombineRule;
import org.confluence.terra_curio.api.primitive.PrimitiveValue;

public record FluidTagsValue(Set<TagKey<Fluid>> tags) implements PrimitiveValue<Set<TagKey<Fluid>>>
{
    public static final Codec<FluidTagsValue> CODEC = TagKey.codec((ResourceKey)Registries.FLUID).listOf().xmap(values -> new FluidTagsValue(new HashSet<TagKey<Fluid>>((Collection<TagKey<Fluid>>)values)), value -> new ArrayList<TagKey<Fluid>>(value.tags));
    public static final CombineRule<Set<TagKey<Fluid>>, FluidTagsValue> EXPANSION = CombineRule.register((a, b) -> {
        HashSet combined = new HashSet(a);
        combined.addAll(b);
        return combined;
    }, "fluid_tags_expansion");

    @SafeVarargs
    public FluidTagsValue(TagKey<Fluid> ... tags) {
        this(Arrays.stream(tags).collect(Collectors.toSet()));
    }

    @Override
    public Set<TagKey<Fluid>> get() {
        return this.tags;
    }

    @Override
    public Codec<FluidTagsValue> codec() {
        return CODEC;
    }

    @Override
    public List<String> getDescription() {
        ArrayList<String> list = new ArrayList<String>();
        for (TagKey<Fluid> tag : this.tags) {
            list.add(tag.toString());
        }
        return list;
    }
}

