/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.api.primitive;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import org.confluence.terra_curio.api.primitive.CombineRule;
import org.confluence.terra_curio.api.primitive.PrimitiveValue;

public record MobEffectsValue(Set<Holder<MobEffect>> effects) implements PrimitiveValue<Set<Holder<MobEffect>>>
{
    public static final Codec<MobEffectsValue> CODEC = MobEffect.CODEC.listOf().xmap(holders -> new MobEffectsValue(new HashSet<Holder<MobEffect>>((Collection<Holder<MobEffect>>)holders)), value -> new ArrayList<Holder<MobEffect>>(value.effects));
    public static final CombineRule<Set<Holder<MobEffect>>, MobEffectsValue> EXPANSION = CombineRule.register((a, b) -> {
        HashSet combined = new HashSet(a);
        combined.addAll(b);
        return combined;
    }, "mob_effects_expansion");

    @Override
    public Set<Holder<MobEffect>> get() {
        return this.effects;
    }

    @Override
    public Codec<MobEffectsValue> codec() {
        return CODEC;
    }

    @Override
    public List<String> getDescription() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("[");
        for (Holder<MobEffect> effect : this.effects) {
            list.add("    " + BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)effect.value())).toString());
        }
        list.add("]");
        return list;
    }
}

