/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.api.primitive;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.api.primitive.CombineRule;
import org.confluence.terra_curio.api.primitive.FloatValue;
import org.confluence.terra_curio.api.primitive.IntegerValue;
import org.confluence.terra_curio.api.primitive.PrimitiveValue;
import org.confluence.terra_curio.api.primitive.UnitValue;

public class ValueType<T, V extends PrimitiveValue<T>> {
    public static final Map<ResourceLocation, Codec<PrimitiveValue<?>>> VALUE_CODECS = new Hashtable();
    public static final Map<ResourceLocation, ValueType<?, ? extends PrimitiveValue<?>>> TYPES = new Hashtable();
    public static final Codec<ValueType<?, ? extends PrimitiveValue<?>>> CODEC = ResourceLocation.CODEC.xmap(TYPES::get, ValueType::key);
    public static final StreamCodec<ByteBuf, ValueType<?, ?>> STREAM_CODEC = ResourceLocation.STREAM_CODEC.map(TYPES::get, ValueType::key);
    private final ResourceLocation key;
    private final CombineRule<T, V> combineRule;
    private final T defaultValue;
    private final Function<T, V> factory;

    public ValueType(ResourceLocation key, CombineRule<T, V> combineRule, T defaultValue, Function<T, V> factory) {
        this.key = key;
        this.combineRule = combineRule;
        this.defaultValue = defaultValue;
        this.factory = factory;
    }

    private static <T, V extends PrimitiveValue<T>> void registerCodec(ResourceLocation id, Codec<V> codec) {
        if (codec instanceof Codec) {
            Codec<V> codec1 = codec;
            VALUE_CODECS.put(id, codec1);
        }
    }

    public static <T, V extends PrimitiveValue<T>> ValueType<T, V> create(String path, CombineRule<T, V> combineRule, Codec<V> codec, T defaultValue, Function<T, V> factory) {
        ResourceLocation id = TerraCurio.asResource(path);
        ValueType.registerCodec(id, codec);
        ValueType<T, V> type = new ValueType<T, V>(id, combineRule, defaultValue, factory);
        TYPES.put(id, type);
        return type;
    }

    public static ValueType<Unit, UnitValue> ofUnit(String path) {
        return ValueType.create(path, UnitValue.GET_SELF, UnitValue.CODEC, Unit.INSTANCE, UnitValue.UNIT_2_VALUE);
    }

    public static ValueType<Integer, IntegerValue> ofInteger(String path, CombineRule<Integer, IntegerValue> combineRule, int defaultValue) {
        return ValueType.create(path, combineRule, IntegerValue.CODEC, defaultValue, IntegerValue::new);
    }

    public static ValueType<Float, FloatValue> ofFloat(String path, CombineRule<Float, FloatValue> combineRule, float defaultValue) {
        return ValueType.create(path, combineRule, FloatValue.CODEC, Float.valueOf(defaultValue), FloatValue::new);
    }

    public ResourceLocation key() {
        return this.key;
    }

    public CombineRule<T, V> combineRule() {
        return this.combineRule;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public V newInstance(T t) {
        return (V)((PrimitiveValue)this.factory.apply(t));
    }

    public String toString() {
        return "Type{key=" + String.valueOf(this.key) + ", combineRule=" + String.valueOf(this.combineRule) + ", defaultValue=" + String.valueOf(this.defaultValue) + ", factory=" + String.valueOf(this.factory) + "}";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueType)) return false;
        ValueType valueType = (ValueType)o;
        if (!valueType.key.equals((Object)this.key)) return false;
        return true;
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

