/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.client;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.confluence.terra_curio.client.model.accessory.DuneriderBootsModel;
import org.confluence.terra_curio.client.model.accessory.FlurryBootsModel;
import org.confluence.terra_curio.client.model.accessory.HermesBootsModel;
import org.confluence.terra_curio.client.model.accessory.MagmaSkullModel;
import org.confluence.terra_curio.client.model.accessory.MermanModel;
import org.confluence.terra_curio.client.model.accessory.ShieldOfCthulhuModel;
import org.confluence.terra_curio.client.model.accessory.TerrasparkBootsModel;
import org.confluence.terra_curio.client.model.accessory.WerewolfModel;
import org.confluence.terra_curio.client.model.accessory.WormScarfModel;
import org.confluence.terra_curio.client.renderer.accessory.DuneriderBootsRenderer;
import org.confluence.terra_curio.client.renderer.accessory.FlurryBootsRenderer;
import org.confluence.terra_curio.client.renderer.accessory.HermesBootsRenderer;
import org.confluence.terra_curio.client.renderer.accessory.MagmaSkullRenderer;
import org.confluence.terra_curio.client.renderer.accessory.MermanRenderer;
import org.confluence.terra_curio.client.renderer.accessory.MoonShellRenderer;
import org.confluence.terra_curio.client.renderer.accessory.ShieldOfCthulhuRenderer;
import org.confluence.terra_curio.client.renderer.accessory.TerrasparkBootsRenderer;
import org.confluence.terra_curio.client.renderer.accessory.WerewolfRenderer;
import org.confluence.terra_curio.client.renderer.accessory.WormScarfRenderer;
import org.confluence.terra_curio.common.init.TCItems;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@OnlyIn(value=Dist.CLIENT)
public final class CuriosClient {
    public static void registerRenderers() {
        EntityModelSet entityModels = Minecraft.getInstance().getEntityModels();
        CuriosRendererRegistry.register((Item)((Item)TCItems.WORM_SCARF.get()), () -> new WormScarfRenderer(entityModels));
        CuriosRendererRegistry.register((Item)((Item)TCItems.TERRASPARK_BOOTS.get()), () -> new TerrasparkBootsRenderer(entityModels));
        CuriosRendererRegistry.register((Item)((Item)TCItems.DUNERIDER_BOOTS.get()), () -> new DuneriderBootsRenderer(entityModels));
        CuriosRendererRegistry.register((Item)((Item)TCItems.MAGMA_SKULL.get()), () -> new MagmaSkullRenderer(entityModels));
        CuriosRendererRegistry.register((Item)((Item)TCItems.FLURRY_BOOTS.get()), () -> new FlurryBootsRenderer(entityModels));
        CuriosRendererRegistry.register((Item)((Item)TCItems.HERMES_BOOTS.get()), () -> new HermesBootsRenderer(entityModels));
        CuriosRendererRegistry.register((Item)((Item)TCItems.SHIELD_OF_CTHULHU.get()), () -> new ShieldOfCthulhuRenderer(entityModels));
        CuriosRendererRegistry.register((Item)((Item)TCItems.NEPTUNES_SHELL.get()), () -> new MermanRenderer(entityModels));
        CuriosRendererRegistry.register((Item)((Item)TCItems.MOON_CHARM.get()), () -> new WerewolfRenderer(entityModels));
        CuriosRendererRegistry.register((Item)((Item)TCItems.MOON_SHELL.get()), () -> new MoonShellRenderer(entityModels));
        CuriosRendererRegistry.register((Item)((Item)TCItems.CELESTIAL_SHELL.get()), () -> new MoonShellRenderer(entityModels));
    }

    public static void registerLayers(BiConsumer<ModelLayerLocation, Supplier<LayerDefinition>> layerDefinition) {
        layerDefinition.accept(WormScarfModel.LAYER_LOCATION, WormScarfModel::createBodyLayer);
        layerDefinition.accept(TerrasparkBootsModel.LAYER_LOCATION, TerrasparkBootsModel::createBodyLayer);
        layerDefinition.accept(DuneriderBootsModel.LAYER_LOCATION, DuneriderBootsModel::createBodyLayer);
        layerDefinition.accept(MagmaSkullModel.LAYER_LOCATION, MagmaSkullModel::createBodyLayer);
        layerDefinition.accept(FlurryBootsModel.LAYER_LOCATION, FlurryBootsModel::createBodyLayer);
        layerDefinition.accept(HermesBootsModel.LAYER_LOCATION, HermesBootsModel::createBodyLayer);
        layerDefinition.accept(ShieldOfCthulhuModel.LAYER_LOCATION, ShieldOfCthulhuModel::createBodyLayer);
        layerDefinition.accept(MermanModel.LAYER_LOCATION, MermanModel::createBodyLayer);
        layerDefinition.accept(WerewolfModel.LAYER_LOCATION, WerewolfModel::createBodyLayer);
    }

    public static void onlyFollowMainBody(LivingEntity livingEntity, ModelPart ... renderers) {
        LivingEntityRenderer livingRenderer;
        ModelPart[] modelPartArray;
        EntityRenderer render = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)livingEntity);
        if (render instanceof LivingEntityRenderer && (modelPartArray = (livingRenderer = (LivingEntityRenderer)render).getModel()) instanceof HumanoidModel) {
            HumanoidModel humanoidModel = (HumanoidModel)modelPartArray;
            for (ModelPart renderer : renderers) {
                renderer.copyFrom(humanoidModel.body);
            }
        }
    }
}

