/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.client.event;

import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.MovementInputUpdateEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.terra_curio.api.event.PerformJumpingEvent;
import org.confluence.terra_curio.client.TCClientConfigs;
import org.confluence.terra_curio.client.TCKeyBindings;
import org.confluence.terra_curio.client.handler.DPSMeter;
import org.confluence.terra_curio.client.handler.GravitationHandler;
import org.confluence.terra_curio.client.handler.InformationHandler;
import org.confluence.terra_curio.client.handler.PlayerClimbHandler;
import org.confluence.terra_curio.client.handler.PlayerJumpHandler;
import org.confluence.terra_curio.client.handler.PlayerSprintingHandler;
import org.confluence.terra_curio.client.handler.ScopeFovHandler;
import org.confluence.terra_curio.client.handler.StepStoolHandler;
import org.confluence.terra_curio.client.handler.TCClientPacketHandler;
import org.confluence.terra_curio.client.renderer.tooltip.MultiFunctionTooltip;
import org.confluence.terra_curio.common.init.TCEffects;
import org.confluence.terra_curio.mixin.client.accessor.MinecraftAccessor;
import org.confluence.terra_curio.network.c2s.ShootXBonePacketC2S;
import org.confluence.terra_curio.util.TCUtils;

@EventBusSubscriber(modid="terra_curio", value={Dist.CLIENT})
public final class GameClientEvents {
    @SubscribeEvent
    public static void clientTick$Post(ClientTickEvent.Pre event) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer == null) {
            GravitationHandler.reset();
            StepStoolHandler.reset();
            TCClientPacketHandler.reset();
            InformationHandler.reset();
            PlayerJumpHandler.reset(true);
            PlayerClimbHandler.reset();
            PlayerSprintingHandler.reset();
            ScopeFovHandler.reset();
        } else {
            DPSMeter.checkDPSTime(localPlayer.level().getGameTime());
            GravitationHandler.handle(localPlayer);
            StepStoolHandler.handle(localPlayer);
            TCClientPacketHandler.handle(minecraft, localPlayer);
            InformationHandler.handle(localPlayer);
            ScopeFovHandler.handle((Player)localPlayer);
            TCUtils.applyCthulhuSprinting(((KeyMapping)TCKeyBindings.CTHULHU_SPRINTING.get()).isDown(), (Player)localPlayer);
        }
    }

    @SubscribeEvent
    public static void movementInputUpdate(MovementInputUpdateEvent event) {
        LocalPlayer localPlayer = (LocalPlayer)event.getEntity();
        Input input = event.getInput();
        boolean jumping = input.jumping;
        if (jumping && !localPlayer.mayFly() && !((PerformJumpingEvent)NeoForge.EVENT_BUS.post((Event)new PerformJumpingEvent(localPlayer))).isCanPerform()) {
            input.jumping = false;
        } else if (GravitationHandler.isHasGlobe()) {
            GravitationHandler.handle(localPlayer, jumping);
        } else {
            MobEffectInstance effect = localPlayer.getEffect(TCEffects.GRAVITATION);
            if (effect == null) {
                GravitationHandler.expire();
                PlayerJumpHandler.handle(localPlayer, jumping);
                PlayerClimbHandler.handle(localPlayer, input.getMoveVector(), jumping);
            } else if (effect.getAmplifier() > 0) {
                GravitationHandler.force(localPlayer);
            } else {
                GravitationHandler.handle(localPlayer, jumping);
            }
        }
        if (TCClientPacketHandler.isHasTabi()) {
            PlayerSprintingHandler.handle(localPlayer, input);
        }
    }

    @SubscribeEvent
    public static void cameraSetup(ViewportEvent.ComputeCameraAngles event) {
        if (GravitationHandler.isShouldRot()) {
            event.setRoll(180.0f);
        }
    }

    @SubscribeEvent
    public static void fov(ComputeFovModifierEvent event) {
        if (ScopeFovHandler.isScoping()) {
            event.setNewFovModifier(ScopeFovHandler.getFovModifier());
        }
    }

    @SubscribeEvent
    public static void interactionKeyMappingTriggered(InputEvent.InteractionKeyMappingTriggered event) {
        if (TCClientConfigs.rightClickDelay && event.isUseItem()) {
            MinecraftAccessor instance = (MinecraftAccessor)Minecraft.getInstance();
            int delay = instance.getRightClickDelay() - TCClientPacketHandler.getRightClickSubtractor();
            instance.setRightClickDelay(Math.max(0, delay));
        }
        if (TCClientPacketHandler.isBoneGlove() && Minecraft.getInstance().player.getMainHandItem().is(Tags.Items.TOOLS)) {
            PacketDistributor.sendToServer((CustomPacketPayload)ShootXBonePacketC2S.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void input$MouseScrolling(InputEvent.MouseScrollingEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && ScopeFovHandler.isScoping()) {
            ScopeFovHandler.handleScroll((Player)player, event.getScrollDeltaY());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void screen$MouseScrolled$Pre(ScreenEvent.MouseScrolled.Pre event) {
        MultiFunctionTooltip.mouseScrollY = MultiFunctionTooltip.isShowing ? (MultiFunctionTooltip.mouseScrollY -= (int)event.getScrollDeltaY()) : 0;
    }
}

