/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Objects;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.confluence.terra_curio.api.primitive.TooltipComponentsValue;
import org.confluence.terra_curio.client.TCClientConfigs;
import org.confluence.terra_curio.client.handler.InformationHandler;
import org.confluence.terra_curio.common.init.TCItems;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class InfoHudOverlay
implements LayeredDraw.Layer {
    private static final int background = -1873784752;
    private static final int textColor = 0xE0E0E0;
    private static final ResourceLocation[] INFO_ICON = (ResourceLocation[])TCItems.FULL_INFO.stream().map(TooltipComponentsValue.Storage::texture).toArray(ResourceLocation[]::new);

    public void render(@NotNull GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.options.hideGui || minecraft.getDebugOverlay().showDebugScreen()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        minecraft.getProfiler().push("info");
        int screenWidth = guiGraphics.guiWidth();
        int top = (int)((float)guiGraphics.guiHeight() * TCClientConfigs.informationHudTop);
        Font font = minecraft.font;
        PoseStack pose = guiGraphics.pose();
        for (Int2ObjectMap.Entry entry : InformationHandler.getInformation().int2ObjectEntrySet()) {
            int iconLeft;
            int left;
            Component info = (Component)entry.getValue();
            int w = font.width((FormattedText)info);
            if (TCClientConfigs.informationIsLeft) {
                left = 12;
                iconLeft = 1;
            } else {
                left = screenWidth - 12 - w;
                iconLeft = screenWidth - 10;
            }
            pose.pushPose();
            pose.translate((float)iconLeft, (float)top - 0.5f, 0.0f);
            Objects.requireNonNull(font);
            float scale = 9.0f * 0.0555556f;
            pose.scale(scale, scale, scale);
            guiGraphics.blit(INFO_ICON[entry.getIntKey()], 0, 0, 0.0f, 0.0f, 18, 18, 18, 18);
            pose.popPose();
            Objects.requireNonNull(font);
            guiGraphics.fill(left - 1, top - 1, left + w + 1, top + 9 - 1, -1873784752);
            guiGraphics.drawString(font, info, left, top, 0xE0E0E0, false);
            Objects.requireNonNull(font);
            top += 9;
        }
        minecraft.getProfiler().pop();
    }
}

