/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.client.gui;

import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.common.menu.WorkshopMenu;
import org.jetbrains.annotations.NotNull;

public class WorkshopScreen
extends AbstractContainerScreen<WorkshopMenu> {
    private static final ResourceLocation BACKGROUND = TerraCurio.asResource("textures/gui/container/workshop.png");
    private boolean upButtonClicked = false;
    private ItemStack upItem = null;
    private boolean downButtonClicked = false;
    private ItemStack downItem = null;

    public WorkshopScreen(WorkshopMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void init() {
        super.init();
        this.titleLabelX = this.imageWidth - this.font.width((FormattedText)this.title) - 8;
        this.inventoryLabelX = this.imageWidth - this.font.width((FormattedText)this.playerInventoryTitle) - 8;
    }

    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
        if (WorkshopScreen.isOverUpButton(pMouseX - this.leftPos, pMouseY - this.topPos)) {
            if (this.upItem == null) {
                this.upItem = ((WorkshopMenu)this.menu).getUpResult();
            }
            pGuiGraphics.renderFakeItem(this.upItem, this.leftPos + 125, this.topPos + 35);
            this.downItem = null;
        } else if (WorkshopScreen.isOverDownButton(pMouseX - this.leftPos, pMouseY - this.topPos)) {
            if (this.downItem == null) {
                this.downItem = ((WorkshopMenu)this.menu).getDownResult();
            }
            pGuiGraphics.renderFakeItem(this.downItem, this.leftPos + 125, this.topPos + 35);
            this.upItem = null;
        } else {
            pGuiGraphics.renderFakeItem(((WorkshopMenu)this.menu).getSlot(0).getItem(), this.leftPos + 125, this.topPos + 35);
            this.upItem = null;
            this.downItem = null;
        }
        if (((WorkshopMenu)this.menu).getRecipesAmount() > 0) {
            String text = ((WorkshopMenu)this.menu).getCurrentIndex() + 1 + "/" + ((WorkshopMenu)this.menu).getRecipesAmount();
            Objects.requireNonNull(this.font);
            pGuiGraphics.drawString(this.font, text, this.leftPos + 144, this.topPos + 37 + (16 - 9) / 2, 0x404040, false);
        }
    }

    protected void renderBg(@NotNull GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        pGuiGraphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (this.upButtonClicked) {
            pGuiGraphics.blit(BACKGROUND, this.leftPos + 128, this.topPos + 23, 177, 0, 10, 8);
        } else if (this.downButtonClicked) {
            pGuiGraphics.blit(BACKGROUND, this.leftPos + 128, this.topPos + 54, 177, 8, 10, 9);
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (WorkshopScreen.isOverUpButton((int)pMouseX - this.leftPos, (int)pMouseY - this.topPos)) {
            int upIndex = ((WorkshopMenu)this.menu).getUpIndex();
            if (((WorkshopMenu)this.menu).clickMenuButton((Player)this.minecraft.player, upIndex)) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                this.minecraft.gameMode.handleInventoryButtonClick(((WorkshopMenu)this.menu).containerId, upIndex);
                this.upButtonClicked = true;
                this.downButtonClicked = false;
                this.upItem = null;
                return true;
            }
            return false;
        }
        if (WorkshopScreen.isOverDownButton((int)pMouseX - this.leftPos, (int)pMouseY - this.topPos)) {
            int downIndex = ((WorkshopMenu)this.menu).getDownIndex();
            if (((WorkshopMenu)this.menu).clickMenuButton((Player)this.minecraft.player, downIndex)) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                this.minecraft.gameMode.handleInventoryButtonClick(((WorkshopMenu)this.menu).containerId, downIndex);
                this.upButtonClicked = false;
                this.downButtonClicked = true;
                this.downItem = null;
                return true;
            }
            return false;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.upButtonClicked = false;
        this.downButtonClicked = false;
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    private static boolean isOverUpButton(int x, int y) {
        return x >= 128 && x <= 138 && y >= 23 && y <= 30;
    }

    private static boolean isOverDownButton(int x, int y) {
        return x >= 128 && x <= 138 && y >= 54 && y <= 61;
    }
}

