/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.client.handler;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongFunction;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;
import org.confluence.lib.util.LibUtils;
import org.confluence.terra_curio.client.TCKeyBindings;
import org.confluence.terra_curio.client.handler.DPSMeter;
import org.confluence.terra_curio.common.init.TCCommonConfigs;
import org.confluence.terra_curio.network.s2c.AttackDamagePacketS2C;
import org.confluence.terra_curio.network.s2c.EntityKilledPacketS2C;
import org.confluence.terra_curio.network.s2c.InfoCurioCheckPacketS2C;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class InformationHandler {
    public static final int WATCH = 0;
    public static final int WEATHER_RADIO = 1;
    public static final int SEXTANT = 2;
    public static final int FISHERMANS_POCKET_GUIDE = 3;
    public static final int METAL_DETECTOR = 4;
    public static final int LIFE_FORM_ANALYZER = 5;
    public static final int RADAR = 6;
    public static final int TALLY_COUNTER = 7;
    public static final int DPS_METER = 8;
    public static final int STOPWATCH = 9;
    public static final int COMPASS = 10;
    public static final int DEPTH_METER = 11;
    public static final int MECHANICAL_LENS = 12;
    public static final boolean[] DISABLE = new boolean[13];
    private static final Int2ObjectMap<Component> INFORMATION = new Int2ObjectArrayMap();
    private static final byte[] INFO_DATA = new byte[13];
    private static final Int2ObjectOpenHashMap<byte[]> REMOTE_DATA = new Int2ObjectOpenHashMap();
    @Nullable
    private static LongFunction<Component> timeInfo = null;
    private static Component weatherRadioInfo = Component.translatable((String)"info.terra_curio.weather_radio.clear", (Object[])new Object[]{"0.00"});
    private static boolean detectorPressed = false;
    private static Component metalDetectorInfo = Component.translatable((String)"info.terra_curio.metal_detector.none");
    private static Component lifeFormAnalyzerInfo = Component.translatable((String)"info.terra_curio.life_form_analyzer.none");
    private static Component radarInfo = Component.translatable((String)"info.terra_curio.radar", (Object[])new Object[]{0});
    private static Component tallyCounterInfo = Component.translatable((String)"info.terra_curio.tally_counter.unknown");
    private static Component dpsMeterInfo = Component.translatable((String)"info.terra_curio.dps_meter", (Object[])new Object[]{Float.valueOf(0.0f)});

    public static void handle(LocalPlayer localPlayer) {
        INFORMATION.clear();
        long gameTime = localPlayer.level().getGameTime();
        byte b = INFO_DATA[0];
        if (!DISABLE[0] && b != 0 && timeInfo != null) {
            INFORMATION.put(0, (Object)timeInfo.apply(localPlayer.level().dayTime()));
        }
        long tenSec = gameTime % 200L;
        if (!DISABLE[1] && INFO_DATA[1] != 0) {
            if (tenSec == 1L) {
                weatherRadioInfo = InformationHandler.getWeatherInfo((Player)localPlayer);
            }
            INFORMATION.put(1, (Object)weatherRadioInfo);
        }
        if (!DISABLE[2] && INFO_DATA[2] != 0) {
            INFORMATION.put(2, (Object)Component.translatable((String)("info.terra_curio.sextant." + localPlayer.level().getMoonPhase())));
        }
        if (!DISABLE[3] && INFO_DATA[3] != 0) {
            INFORMATION.put(3, (Object)InformationHandler.getFishingPowerInfo((Player)localPlayer));
        }
        if (!DISABLE[4]) {
            b = INFO_DATA[4];
            if (((KeyMapping)TCKeyBindings.METAL_DETECTOR.get()).isDown()) {
                if (!detectorPressed && b != 0) {
                    detectorPressed = true;
                    metalDetectorInfo = InformationHandler.getMetalDetectorInfo((Player)localPlayer);
                }
            } else {
                detectorPressed = false;
            }
            if (b != 0) {
                INFORMATION.put(4, (Object)metalDetectorInfo);
            }
        }
        if (!DISABLE[5] && INFO_DATA[5] != 0) {
            if (tenSec == 5L) {
                lifeFormAnalyzerInfo = InformationHandler.getLifeFormAnalyzerInfo((Player)localPlayer);
            }
            INFORMATION.put(5, (Object)lifeFormAnalyzerInfo);
        }
        if (!DISABLE[6] && INFO_DATA[6] != 0) {
            if (tenSec == 6L) {
                radarInfo = Component.translatable((String)"info.terra_curio.radar", (Object[])new Object[]{localPlayer.level().getEntities((Entity)localPlayer, new AABB(localPlayer.getOnPos()).inflate(63.5), entity -> entity instanceof Enemy).size()});
            }
            INFORMATION.put(6, (Object)radarInfo);
        }
        if (!DISABLE[7] && INFO_DATA[7] != 0) {
            INFORMATION.put(7, (Object)tallyCounterInfo);
        }
        if (!DISABLE[8] && INFO_DATA[8] != 0) {
            INFORMATION.put(8, (Object)Component.translatable((String)"info.terra_curio.dps_meter", (Object[])new Object[]{"%.2f".formatted(Float.valueOf(DPSMeter.getDPS(gameTime)))}));
        }
        if (!DISABLE[9] && INFO_DATA[9] != 0) {
            INFORMATION.put(9, (Object)Component.translatable((String)"info.terra_curio.stopwatch", (Object[])new Object[]{"%.2f".formatted(Mth.length((double)(localPlayer.getX() - localPlayer.xOld), (double)(localPlayer.getY() - localPlayer.yOld), (double)(localPlayer.getZ() - localPlayer.zOld)) * 20.0)}));
        }
        if (!DISABLE[10] && INFO_DATA[10] != 0) {
            INFORMATION.put(10, (Object)InformationHandler.getCompassInfo((Player)localPlayer));
        }
        if (!DISABLE[11] && INFO_DATA[11] != 0) {
            INFORMATION.put(11, (Object)InformationHandler.getDepthMeterInfo((Player)localPlayer));
        }
        if (tenSec == 0L) {
            for (int i = 0; i < INFO_DATA.length; ++i) {
                if (INFO_DATA[i] >= 0) continue;
                boolean match = false;
                for (Player player : localPlayer.level().players()) {
                    byte[] data;
                    if (player == localPlayer || player.distanceToSqr((Entity)localPlayer) > 1024.0 || (data = (byte[])REMOTE_DATA.get(player.getId())) == null || data[i] <= -125) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                InformationHandler.INFO_DATA[i] = 0;
            }
        }
    }

    public static void reset() {
        if (!INFORMATION.isEmpty()) {
            INFORMATION.clear();
            Arrays.fill(INFO_DATA, (byte)0);
            REMOTE_DATA.clear();
        }
    }

    private static Component getWeatherInfo(Player player) {
        String weather;
        Level level = player.level();
        String string = weather = level.dimension() == Level.OVERWORLD ? "clear" : "cloudy";
        if (level.isRaining()) {
            weather = level.getBiome(player.blockPosition()).is(Tags.Biomes.IS_COLD) ? "snow" : "rain";
            if (level.isThundering()) {
                weather = "snow".equals(weather) ? "thunder_snow" : "thunder";
            }
        } else if (level.isThundering()) {
            weather = "thunder";
        }
        LibUtils.forMixin$Inject();
        return Component.translatable((String)("info.terra_curio.weather_radio." + weather));
    }

    private static Component getFishingPowerInfo(Player player) {
        float fishingPower = ((Float)LibUtils.forMixin$ModifyExpression((Object)Float.valueOf(player.getLuck()))).floatValue();
        return Component.translatable((String)"info.terra_curio.fishermans_pocket_guide", (Object[])new Object[]{"%.2f".formatted(Float.valueOf(fishingPower))});
    }

    private static Component getMetalDetectorInfo(Player localPlayer) {
        AtomicReference<MutableComponent> atomic = new AtomicReference<MutableComponent>(Component.translatable((String)"info.terra_curio.metal_detector.none"));
        localPlayer.level().getBlockStates(new AABB(localPlayer.getOnPos()).inflate(15.5)).filter(arg_0 -> TCCommonConfigs.rareBlocks.containsKey(arg_0)).min(Comparator.comparingInt(arg_0 -> TCCommonConfigs.rareBlocks.getInt(arg_0))).ifPresent(blockState -> atomic.set(Component.translatable((String)"info.terra_curio.metal_detector", (Object[])new Object[]{blockState.getBlock().getName()})));
        return (Component)atomic.get();
    }

    private static Component getLifeFormAnalyzerInfo(Player localPlayer) {
        AtomicReference<MutableComponent> atomic = new AtomicReference<MutableComponent>(Component.translatable((String)"info.terra_curio.life_form_analyzer.none"));
        localPlayer.level().getEntities((Entity)localPlayer, new AABB(localPlayer.getOnPos()).inflate(47.5), entity -> TCCommonConfigs.rareCreatures.containsKey((Object)entity.getType())).stream().min(Comparator.comparingInt(entity -> TCCommonConfigs.rareCreatures.getInt((Object)entity.getType()))).ifPresent(entity -> atomic.set(Component.translatable((String)"info.terra_curio.life_form_analyzer", (Object[])new Object[]{entity.getType().getDescription()})));
        return (Component)atomic.get();
    }

    private static Component getCompassInfo(Player localPlayer) {
        double x = localPlayer.getX();
        double z = localPlayer.getZ();
        return Component.translatable((String)("info.terra_curio.compass." + (x > 0.0 ? "east" : "west")), (Object[])new Object[]{"%.2f".formatted(x)}).append((Component)Component.translatable((String)("info.terra_curio.compass." + (z > 0.0 ? "south" : "north")), (Object[])new Object[]{"%.2f".formatted(z)}));
    }

    private static Component getDepthMeterInfo(Player localPlayer) {
        double y = localPlayer.getY();
        return Component.translatable((String)("info.terra_curio.depth_meter." + (y > 63.0 ? "surface" : "underground")), (Object[])new Object[]{"%.2f".formatted(y)});
    }

    public static boolean hasMechanicalView() {
        return INFO_DATA[12] != 0;
    }

    public static Int2ObjectMap<Component> getInformation() {
        return INFORMATION;
    }

    public static void handlePacket(InfoCurioCheckPacketS2C packet, Player player) {
        byte[] enabled = packet.enabled();
        if (player != null && packet.playerId() != player.getId()) {
            REMOTE_DATA.put(packet.playerId(), (Object)packet.enabled());
        }
        byte b = enabled[0];
        byte c = INFO_DATA[0];
        if (b >= 0 && c >= 0 || b != -125 && c <= 0) {
            InformationHandler.INFO_DATA[0] = b;
        }
        timeInfo = switch (INFO_DATA[0]) {
            case -126, 1 -> InformationHandler::wrapHour;
            case -127, 2 -> InformationHandler::wrapHalfHour;
            case -128, 3 -> InformationHandler::wrapMinute;
            default -> null;
        };
        InformationHandler.setInfoData(enabled, 1);
        InformationHandler.setInfoData(enabled, 2);
        InformationHandler.setInfoData(enabled, 3);
        InformationHandler.setInfoData(enabled, 4);
        InformationHandler.setInfoData(enabled, 5);
        InformationHandler.setInfoData(enabled, 6);
        InformationHandler.setInfoData(enabled, 7);
        InformationHandler.setInfoData(enabled, 8);
        InformationHandler.setInfoData(enabled, 9);
        InformationHandler.setInfoData(enabled, 10);
        InformationHandler.setInfoData(enabled, 11);
        InformationHandler.setInfoData(enabled, 12);
    }

    private static Component wrapHour(long dayTime) {
        long hour = dayTime % 24000L / 1000L + 6L;
        if (hour > 23L) {
            hour -= 24L;
        }
        return Component.translatable((String)"info.terra_curio.time", (Object[])new Object[]{InformationHandler.format(hour), "00"});
    }

    private static Component wrapHalfHour(long dayTime) {
        long hour = (dayTime %= 24000L) / 1000L + 6L;
        if (hour > 23L) {
            hour -= 24L;
        }
        String half = dayTime % 1000L > 499L ? "30" : "00";
        return Component.translatable((String)"info.terra_curio.time", (Object[])new Object[]{InformationHandler.format(hour), half});
    }

    private static Component wrapMinute(long dayTime) {
        long hour = (dayTime %= 24000L) / 1000L + 6L;
        if (hour > 23L) {
            hour -= 24L;
        }
        long minute = (long)((float)(dayTime % 1000L) * 0.06f);
        return Component.translatable((String)"info.terra_curio.time", (Object[])new Object[]{InformationHandler.format(hour), InformationHandler.format(minute)});
    }

    private static String format(long time) {
        return (time < 10L ? "0" : "") + time;
    }

    private static void setInfoData(byte[] enabled, int index) {
        byte b = enabled[index];
        byte c = INFO_DATA[index];
        if (b >= 0 && c >= 0 || b != -128 && c <= 0) {
            InformationHandler.INFO_DATA[index] = b;
        }
    }

    public static void handleEntityKilled(EntityKilledPacketS2C packet) {
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(packet.entityType());
        tallyCounterInfo = Component.translatable((String)"info.terra_curio.tally_counter").append(entityType.getDescription()).append("': " + (packet.amount() + 1));
    }

    public static void handleAttackDamage(AttackDamagePacketS2C packet, Player player) {
        DPSMeter.addDPS(packet.amount(), player.level().getGameTime());
    }
}

