/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.client.handler;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.terra_curio.client.handler.PlayerJumpHandler;
import org.confluence.terra_curio.mixin.accessor.LivingEntityAccessor;
import org.confluence.terra_curio.network.c2s.PlayerJumpPacketC2S;
import org.confluence.terra_curio.network.s2c.PlayerClimbPacketS2C;

@OnlyIn(value=Dist.CLIENT)
public final class PlayerClimbHandler {
    private static boolean wallJumped = false;
    private static byte climberAmount = 0;

    public static void handle(LocalPlayer localPlayer, Vec2 vector, boolean jumping) {
        double z;
        float sin;
        if (climberAmount <= 0 || localPlayer.onGround() || (double)vector.x == 0.0 && (double)vector.y == 0.0) {
            wallJumped = true;
            return;
        }
        Vec3 motion = localPlayer.getDeltaMovement();
        double motionY = motion.y;
        if (motionY > 0.0) {
            return;
        }
        float rad = localPlayer.getYRot() * ((float)Math.PI / 180);
        float cos = Mth.cos((float)rad);
        double x = vector.x * cos + vector.y * -(sin = Mth.sin((float)rad));
        if (PlayerClimbHandler.hasMotionToWall(localPlayer, x, z = (double)(vector.x * sin + vector.y * cos))) {
            if (jumping) {
                if (!wallJumped) {
                    PlayerClimbHandler.wallJump(localPlayer, x, z);
                    wallJumped = true;
                    return;
                }
            } else {
                wallJumped = false;
            }
            if (localPlayer.isShiftKeyDown()) {
                motionY = -0.1;
            } else if (climberAmount == 1) {
                motionY = -0.05;
            } else if (climberAmount >= 2) {
                motionY = 0.0;
            }
            localPlayer.hasImpulse = true;
            localPlayer.fallDistance = 0.0f;
            localPlayer.setDeltaMovement(motion.x * 0.93, motionY, motion.z * 0.93);
            PlayerJumpHandler.reset(true);
            PacketDistributor.sendToServer((CustomPacketPayload)new PlayerJumpPacketC2S(2, (float)motionY), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void reset() {
        wallJumped = false;
        climberAmount = 0;
    }

    private static boolean hasMotionToWall(LocalPlayer localPlayer, double x, double z) {
        AABB aabb = localPlayer.getDimensions(localPlayer.getPose()).makeBoundingBox(localPlayer.position());
        double u = x * 0.1;
        double v = z * 0.1;
        return !localPlayer.level().noCollision(new AABB(aabb.minX - 0.01 + u, localPlayer.getEyeY(), aabb.minZ - 0.01 + v, aabb.maxX + 0.01 + u, aabb.maxY, aabb.maxZ + 0.01 + v));
    }

    private static void wallJump(LocalPlayer localPlayer, double x, double z) {
        double motionY = (double)((LivingEntityAccessor)localPlayer).callGetJumpPower() * 1.1;
        Vec3 vec3 = localPlayer.getDeltaMovement();
        localPlayer.setDeltaMovement(vec3.add(vec3.x - x * 0.11, motionY, vec3.z - z * 0.11));
        localPlayer.hasImpulse = true;
        PacketDistributor.sendToServer((CustomPacketPayload)new PlayerJumpPacketC2S(1, (float)motionY), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void handlePacket(PlayerClimbPacketS2C packet) {
        climberAmount = packet.climberAmount();
    }
}

