/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.client.handler;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.confluence.terra_curio.api.primitive.MayFlyAbilityValue;
import org.confluence.terra_curio.client.handler.StepStoolHandler;
import org.confluence.terra_curio.client.sound.RocketBootsBoostSoundInstance;
import org.confluence.terra_curio.client.sound.RocketBootsStopSoundInstance;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.common.init.TCSoundEvents;
import org.confluence.terra_curio.integration.airhop.AirHopHelper;
import org.confluence.terra_curio.mixin.accessor.LivingEntityAccessor;
import org.confluence.terra_curio.network.c2s.PlayerJumpPacketC2S;
import org.confluence.terra_curio.network.s2c.InfiniteFlightPacketS2C;
import org.confluence.terra_curio.network.s2c.PlayerJumpPacketS2C;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class PlayerJumpHandler {
    private static boolean jumpKeyDown = true;
    private static float fartSpeed = 0.0f;
    private static boolean fartFinished = false;
    private static float sandstormSpeed = 0.0f;
    private static int maxSandstormTicks = 0;
    private static int remainSandstormTicks = 0;
    private static boolean sandstormFinished = false;
    public static boolean isOnSandstormJump = false;
    private static float blizzardSpeed = 0.0f;
    private static int maxBlizzardTicks = 0;
    private static int remainBlizzardTicks = 0;
    private static boolean blizzardFinished = false;
    public static boolean isOnBlizzardJump = false;
    private static float tsunamiSpeed = 0.0f;
    private static boolean tsunamiFinished = false;
    public static boolean isOnTsunamiJump = false;
    private static float cloudSpeed = 0.0f;
    private static boolean cloudFinished = false;
    public static boolean isOnCloudJump = false;
    private static Map<ResourceKey<Item>, MayFlyAbilityValue.FlyStack> flyStacks = Map.of();
    private static Object2IntMap<ResourceKey<Item>> remainFlyTicks = new Object2IntOpenHashMap();
    private static boolean couldGlide = false;
    private static boolean horizontalFlight = false;
    private static boolean infiniteFlight = false;
    private static float infiniteFlightSpeed = 0.0f;
    private static ResourceKey<Item> currentFlight;
    private static ResourceKey<Item> lastFlight;
    private static boolean onFlight;

    public static void handle(LocalPlayer localPlayer, boolean jumping) {
        if (StepStoolHandler.onStool()) {
            return;
        }
        if (lastFlight != currentFlight) {
            if (currentFlight == TCItems.ROCKET_BOOTS.getKey()) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)new RocketBootsBoostSoundInstance(localPlayer));
            } else if (lastFlight == TCItems.ROCKET_BOOTS.getKey()) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)new RocketBootsStopSoundInstance(localPlayer));
            }
            lastFlight = currentFlight;
        }
        if (localPlayer.onGround()) {
            PlayerJumpHandler.reset(true);
        } else if (jumping) {
            int i;
            if (AirHopHelper.LOADED && AirHopHelper.notFinishJump((Player)localPlayer)) {
                jumpKeyDown = true;
                return;
            }
            if (couldGlide) {
                for (Map.Entry<ResourceKey<Item>, MayFlyAbilityValue.FlyStack> entry : flyStacks.entrySet()) {
                    i = remainFlyTicks.getInt(entry.getKey());
                    if (infiniteFlight || i > 0) {
                        PlayerJumpHandler.fly(horizontalFlight && localPlayer.isShiftKeyDown(), localPlayer, infiniteFlight ? infiniteFlightSpeed : entry.getValue().flySpeed());
                        if (!infiniteFlight) {
                            currentFlight = entry.getKey();
                        }
                        if (!horizontalFlight || localPlayer.level().getGameTime() % 2L == 0L) {
                            remainFlyTicks.put(currentFlight, --i);
                        }
                        if (!infiniteFlight && i <= 0) continue;
                        return;
                    }
                    if (localPlayer.getAbilities().flying || !(localPlayer.getDeltaMovement().y < -0.15)) continue;
                    onFlight = false;
                    PlayerJumpHandler.glide(localPlayer);
                }
                currentFlight = null;
            }
            if (jumpKeyDown) {
                return;
            }
            if (!fartFinished && (double)fartSpeed > 0.0) {
                fartFinished = true;
                jumpKeyDown = true;
                PlayerJumpHandler.multiJump(localPlayer, fartSpeed);
                localPlayer.playSound(TCSoundEvents.FART_SOUND.get());
            } else if (!sandstormFinished && (double)sandstormSpeed > 0.0) {
                if (remainSandstormTicks-- > 0) {
                    PlayerJumpHandler.oneTimeJump(localPlayer, sandstormSpeed);
                    isOnSandstormJump = true;
                } else {
                    jumpKeyDown = true;
                    isOnSandstormJump = false;
                }
            } else if (!blizzardFinished && (double)blizzardSpeed > 0.0) {
                if (remainBlizzardTicks-- > 0) {
                    PlayerJumpHandler.oneTimeJump(localPlayer, blizzardSpeed);
                    isOnBlizzardJump = true;
                } else {
                    jumpKeyDown = true;
                    isOnBlizzardJump = false;
                }
            } else if (!tsunamiFinished && (double)tsunamiSpeed > 0.0) {
                tsunamiFinished = true;
                isOnTsunamiJump = true;
                jumpKeyDown = true;
                PlayerJumpHandler.multiJump(localPlayer, tsunamiSpeed);
                localPlayer.playSound(TCSoundEvents.DOUBLE_JUMP.get());
            } else if (!cloudFinished && (double)cloudSpeed > 0.0) {
                cloudFinished = true;
                isOnCloudJump = true;
                jumpKeyDown = true;
                PlayerJumpHandler.multiJump(localPlayer, cloudSpeed);
                localPlayer.playSound(TCSoundEvents.DOUBLE_JUMP.get());
            } else {
                for (Map.Entry<ResourceKey<Item>, MayFlyAbilityValue.FlyStack> entry : flyStacks.entrySet()) {
                    i = remainFlyTicks.getInt(entry.getKey());
                    if (!infiniteFlight && i <= 0) continue;
                    PlayerJumpHandler.fly(horizontalFlight, localPlayer, infiniteFlight ? infiniteFlightSpeed : entry.getValue().flySpeed());
                    if (!infiniteFlight) {
                        currentFlight = entry.getKey();
                    }
                    remainFlyTicks.put(entry.getKey(), --i);
                    if (!infiniteFlight && i <= 0) continue;
                    return;
                }
                currentFlight = null;
                jumpKeyDown = true;
            }
        } else {
            jumpKeyDown = false;
            sandstormFinished = remainSandstormTicks < maxSandstormTicks;
            blizzardFinished = remainBlizzardTicks < maxBlizzardTicks;
            isOnSandstormJump = false;
            isOnBlizzardJump = false;
            onFlight = false;
            currentFlight = null;
        }
    }

    @Nullable
    public static ResourceKey<Item> getCurrentFlight() {
        return currentFlight;
    }

    private static void fly(boolean horizontalFlight, LocalPlayer localPlayer, float flySpeed) {
        onFlight = true;
        if (horizontalFlight) {
            PlayerJumpHandler.horizontalFlight(localPlayer, flySpeed);
        } else {
            PlayerJumpHandler.fly(localPlayer, flySpeed);
        }
    }

    public static void reset(boolean jumpKey) {
        jumpKeyDown = jumpKey;
        fartFinished = false;
        remainSandstormTicks = maxSandstormTicks;
        sandstormFinished = false;
        remainBlizzardTicks = maxBlizzardTicks;
        blizzardFinished = false;
        tsunamiFinished = false;
        cloudFinished = false;
        PlayerJumpHandler.setupRemainFlyTicks(flyStacks);
        currentFlight = null;
        lastFlight = null;
    }

    public static void multiJump(LocalPlayer localPlayer, float speed) {
        Vec3 vec3 = localPlayer.getDeltaMovement();
        double motionY = ((LivingEntityAccessor)localPlayer).callGetJumpPower() * speed;
        localPlayer.setDeltaMovement(vec3.x, motionY, vec3.z);
        if (localPlayer.isSprinting()) {
            float f = localPlayer.getYRot() * ((float)Math.PI / 180);
            localPlayer.setDeltaMovement(localPlayer.getDeltaMovement().add((double)(-Mth.sin((float)f)) * 0.2, 0.0, (double)Mth.cos((float)f) * 0.2));
        }
        localPlayer.hasImpulse = true;
        localPlayer.resetFallDistance();
        PacketDistributor.sendToServer((CustomPacketPayload)new PlayerJumpPacketC2S(3, speed), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void oneTimeJump(LocalPlayer localPlayer, float speed) {
        Vec3 vec3 = localPlayer.getDeltaMovement();
        localPlayer.setDeltaMovement(vec3.x, (double)speed, vec3.z);
        localPlayer.hasImpulse = true;
        localPlayer.resetFallDistance();
        PacketDistributor.sendToServer((CustomPacketPayload)new PlayerJumpPacketC2S(2, speed), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void fly(LocalPlayer localPlayer, float speed) {
        float y = (float)localPlayer.getDeltaMovement().y;
        y = y < speed ? (y += speed / 2.5f) : speed;
        PlayerJumpHandler.airMove(localPlayer, y, localPlayer.getSpeed() + speed);
    }

    private static void glide(LocalPlayer localPlayer) {
        PlayerJumpHandler.airMove(localPlayer, -0.3f, localPlayer.getSpeed() + 0.4f);
    }

    private static void horizontalFlight(LocalPlayer localPlayer, float speed) {
        PlayerJumpHandler.airMove(localPlayer, 0.0f, Math.min(localPlayer.getSpeed() * 4.0f + speed - 0.5f, speed + speed));
    }

    private static void airMove(LocalPlayer localPlayer, float y, float h) {
        float rad = localPlayer.getYRot() * ((float)Math.PI / 180);
        float cos = Mth.cos((float)rad);
        float sin = Mth.sin((float)rad);
        float v = h * 0.15f;
        float x = localPlayer.xxa * v;
        float z = localPlayer.zza * v;
        double mx = x * cos + z * -sin;
        double mz = x * sin + z * cos;
        Vec3 motion = localPlayer.getDeltaMovement();
        localPlayer.setDeltaMovement(motion.x + mx, (double)y, motion.z + mz);
        localPlayer.hasImpulse = true;
        localPlayer.resetFallDistance();
        PacketDistributor.sendToServer((CustomPacketPayload)new PlayerJumpPacketC2S(2, y), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void handleJumpPacket(PlayerJumpPacketS2C packet) {
        if ((double)packet.fartSpeed() > -1.5) {
            fartSpeed = packet.fartSpeed();
        }
        sandstormSpeed = packet.sandstormSpeed();
        maxSandstormTicks = packet.sandstormTicks();
        blizzardSpeed = packet.blizzardSpeed();
        maxBlizzardTicks = packet.blizzardTicks();
        if ((double)packet.tsunamiSpeed() > -1.5) {
            tsunamiSpeed = packet.tsunamiSpeed();
        }
        cloudSpeed = packet.cloudSpeed();
    }

    public static void handleFlyPacket(Map<ResourceKey<Item>, MayFlyAbilityValue.FlyStack> map) {
        LinkedHashMap<ResourceKey<Item>, MayFlyAbilityValue.FlyStack> neo = new LinkedHashMap<ResourceKey<Item>, MayFlyAbilityValue.FlyStack>();
        MutableBoolean b1 = new MutableBoolean();
        MutableBoolean b2 = new MutableBoolean();
        MutableFloat f1 = new MutableFloat();
        map.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((MayFlyAbilityValue.FlyStack)entry.getValue()).older())).forEachOrdered(entry -> {
            MayFlyAbilityValue.FlyStack value = (MayFlyAbilityValue.FlyStack)entry.getValue();
            neo.put((ResourceKey)entry.getKey(), value);
            if (b1.isFalse() && value.couldGlide()) {
                b1.setTrue();
            }
            if (b2.isFalse() && value.horizontalFlight()) {
                b2.setTrue();
            }
            f1.setValue(Math.max(value.flySpeed(), f1.floatValue()));
        });
        flyStacks = neo;
        PlayerJumpHandler.setupRemainFlyTicks(map);
        couldGlide = b1.isTrue();
        horizontalFlight = b2.isTrue();
        infiniteFlightSpeed = f1.floatValue();
    }

    private static void setupRemainFlyTicks(Map<ResourceKey<Item>, MayFlyAbilityValue.FlyStack> map) {
        Object2IntOpenHashMap neo = new Object2IntOpenHashMap();
        map.forEach((arg_0, arg_1) -> PlayerJumpHandler.lambda$setupRemainFlyTicks$2((Object2IntMap)neo, arg_0, arg_1));
        remainFlyTicks = neo;
    }

    public static void handleInfiniteFlight(InfiniteFlightPacketS2C packet) {
        infiniteFlight = packet.enable();
    }

    public static boolean isOnFlight() {
        return onFlight;
    }

    public static boolean isOnHorizontalFlight() {
        return onFlight && horizontalFlight;
    }

    public static boolean isInfiniteFlight() {
        return infiniteFlight;
    }

    private static /* synthetic */ void lambda$setupRemainFlyTicks$2(Object2IntMap neo, ResourceKey key, MayFlyAbilityValue.FlyStack stack) {
        neo.put((Object)key, stack.flyTicks());
    }

    static {
        onFlight = false;
    }
}

