/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.client.handler;

import net.minecraft.client.Minecraft;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;

@OnlyIn(value=Dist.CLIENT)
public final class ScopeFovHandler {
    static boolean hasScope = false;
    private static boolean scoping = false;
    private static float fovModifier = 0.1f;
    private static double cameraMoveFactor = 0.125;

    public static void handle(Player player) {
        if (hasScope && player.isCrouching() && Minecraft.getInstance().options.getCameraType().isFirstPerson() && player.getItemInHand(InteractionHand.MAIN_HAND).is(Tags.Items.RANGED_WEAPON_TOOLS)) {
            if (!scoping) {
                if (fovModifier != 1.0f) {
                    player.playSound(SoundEvents.SPYGLASS_USE);
                }
                scoping = true;
            }
        } else {
            scoping = false;
        }
    }

    public static void reset() {
        scoping = false;
        hasScope = false;
        fovModifier = 0.1f;
        cameraMoveFactor = 0.125;
    }

    public static void handleScroll(Player player, double scrollDeltaY) {
        float cached = fovModifier;
        fovModifier = Mth.clamp((float)(fovModifier - (float)scrollDeltaY * 0.1f), (float)0.1f, (float)1.0f);
        cameraMoveFactor = Mth.lerp((double)(((double)fovModifier - 0.1) / 0.9), (double)0.125, (double)1.0);
        if (cached != fovModifier) {
            player.playSound(SoundEvents.SPYGLASS_USE);
        }
    }

    public static boolean isScoping() {
        return scoping;
    }

    public static float getFovModifier() {
        return fovModifier;
    }

    public static double getCameraMoveFactor() {
        return cameraMoveFactor;
    }
}

