/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.client.handler;

import net.minecraft.client.KeyMapping;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.terra_curio.client.TCKeyBindings;
import org.confluence.terra_curio.network.c2s.StepStoolSteppingPacketC2S;
import org.confluence.terra_curio.network.s2c.StepStoolSteppingPacketS2C;

@OnlyIn(value=Dist.CLIENT)
public final class StepStoolHandler {
    private static boolean upKeyDown = false;
    private static boolean shiftKeyDown = false;
    private static byte actualStep = 0;
    private static int maxStep = 0;
    private static int slot = -1;

    public static void handle(LocalPlayer localPlayer) {
        if (slot == -1 || actualStep == 0 && !localPlayer.onGround()) {
            actualStep = 0;
            return;
        }
        if (actualStep > 0) {
            if (localPlayer.input.jumping) {
                localPlayer.jumpFromGround();
                StepStoolHandler.setStep((byte)0, false);
                return;
            }
            if (localPlayer.getVehicle() != null) {
                StepStoolHandler.setStep((byte)0, false);
                return;
            }
        }
        if (((KeyMapping)TCKeyBindings.STEP_STOOL.get()).isDown()) {
            if (!upKeyDown && actualStep < maxStep) {
                StepStoolHandler.setStep((byte)(actualStep + 1), true);
                upKeyDown = true;
            }
        } else {
            upKeyDown = false;
        }
        if (!upKeyDown && localPlayer.isShiftKeyDown()) {
            if (!shiftKeyDown && actualStep > 0) {
                StepStoolHandler.setStep((byte)(actualStep - 1), false);
                shiftKeyDown = true;
            }
        } else {
            shiftKeyDown = false;
        }
        if (actualStep > 0) {
            localPlayer.setDeltaMovement(new Vec3(0.0, localPlayer.getDeltaMovement().y, 0.0));
        }
    }

    public static void reset() {
        actualStep = 0;
        maxStep = 0;
        slot = -1;
    }

    public static void setStep(byte actualStep, boolean increase) {
        StepStoolHandler.actualStep = actualStep;
        byte step = actualStep;
        if (increase) {
            step = (byte)(actualStep | 0x40);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new StepStoolSteppingPacketC2S(slot, step), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static int getActualStep() {
        return actualStep;
    }

    public static boolean onStool() {
        return actualStep > 0;
    }

    public static void handlePacket(StepStoolSteppingPacketS2C packet) {
        if (packet.slot() == -2) {
            actualStep = 0;
            maxStep = 0;
        } else {
            maxStep = packet.maxStep();
            slot = maxStep == 0 ? -1 : packet.slot();
        }
    }
}

