/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.client.handler;

import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import org.confluence.terra_curio.client.TCClientConfigs;
import org.confluence.terra_curio.client.handler.GravitationHandler;
import org.confluence.terra_curio.client.handler.ScopeFovHandler;
import org.confluence.terra_curio.integration.bettercombat.BetterCombatHelper;
import org.confluence.terra_curio.mixin.client.accessor.MinecraftAccessor;
import org.confluence.terra_curio.network.s2c.BroadcastRenderPacketS2C;
import org.confluence.terra_curio.network.s2c.CurioExistsPacketS2C;
import org.confluence.terra_curio.network.s2c.RightClickSubtractorPacketS2C;
import org.confluence.terra_curio.network.s2c.SetItemEntityPickupDelayPacketS2C;

@OnlyIn(value=Dist.CLIENT)
public final class TCClientPacketHandler {
    private static boolean autoAttack = false;
    private static boolean hasCthulhu = false;
    private static boolean hasTabi = false;
    private static boolean hasMagiluminescence = false;
    private static boolean canFloating = false;
    private static boolean iceSafe = false;
    private static boolean boneGlove = false;
    public static boolean floating = false;
    private static boolean hasNeptunesShell = false;
    private static final Int2BooleanMap remoteNeptuneShell = new Int2BooleanArrayMap();
    private static byte rightClickSubtractor = 0;
    private static int luminance = 0;
    private static final Int2IntMap remoteLuminance = new Int2IntArrayMap();
    private static final Int2IntMap pickupDelayStorage = new Int2IntArrayMap();
    private static final Int2IntMap pickupDelayCounter = (Int2IntMap)Util.make((Object)new Int2IntArrayMap(), map -> map.defaultReturnValue(0));

    public static boolean couldAutoAttack() {
        return autoAttack;
    }

    public static boolean isHasCthulhu() {
        return hasCthulhu;
    }

    public static boolean isHasTabi() {
        return hasTabi;
    }

    public static boolean isHasMagiluminescence() {
        return hasMagiluminescence;
    }

    public static boolean isCanFloating() {
        return canFloating;
    }

    public static boolean isIceSafe() {
        return iceSafe;
    }

    public static boolean isBoneGlove() {
        return boneGlove;
    }

    public static boolean isHasNeptunesShell() {
        return hasNeptunesShell;
    }

    public static boolean canShowNeptunesShell(LivingEntity living) {
        return (hasNeptunesShell && living.getClass() == LocalPlayer.class || living.getClass() == RemotePlayer.class && remoteNeptuneShell.get(living.getId())) && living.isInWaterOrBubble();
    }

    public static byte getRightClickSubtractor() {
        return rightClickSubtractor;
    }

    public static int getLuminance(Entity entity) {
        int ret;
        int n = ret = entity == Minecraft.getInstance().player ? luminance : remoteLuminance.getOrDefault(entity.getId(), 0);
        if (ret < 0) {
            return entity.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value()) ? -ret : 0;
        }
        return ret;
    }

    public static void handleSubstractor(RightClickSubtractorPacketS2C packet) {
        rightClickSubtractor = packet.amount();
    }

    public static void handleCurioExists(CurioExistsPacketS2C packet) {
        int item = packet.item();
        autoAttack = (item & CurioExistsPacketS2C.AUTO_ATTACK) != 0;
        hasCthulhu = (item & CurioExistsPacketS2C.SHIELD_OF_CTHULHU) != 0;
        hasTabi = (item & CurioExistsPacketS2C.TABI) != 0;
        ScopeFovHandler.hasScope = (item & CurioExistsPacketS2C.SCOPE) != 0;
        GravitationHandler.hasGlobe = (item & CurioExistsPacketS2C.GRAVITY_GLOBE) != 0;
        hasMagiluminescence = (item & CurioExistsPacketS2C.MAGILUMINESCENCE) != 0;
        canFloating = (item & CurioExistsPacketS2C.FLOAT_ON_LIQUID_SURFACE) != 0;
        iceSafe = (item & CurioExistsPacketS2C.ICE_SAFE) != 0;
        boneGlove = (item & CurioExistsPacketS2C.BONE_GLOVE) != 0;
    }

    public static void handleItemPickupDelay(SetItemEntityPickupDelayPacketS2C packet) {
        pickupDelayStorage.put(packet.id(), packet.delay());
    }

    public static void handle(Minecraft minecraft, LocalPlayer player) {
        TCClientPacketHandler.applyAutoAttack(minecraft, player);
        TCClientPacketHandler.setPickupDelay(player);
    }

    private static void setPickupDelay(LocalPlayer player) {
        if (pickupDelayStorage.isEmpty()) {
            return;
        }
        ObjectIterator iterator = pickupDelayStorage.int2IntEntrySet().iterator();
        while (iterator.hasNext()) {
            Int2IntMap.Entry next = (Int2IntMap.Entry)iterator.next();
            int id = next.getIntKey();
            Entity entity = player.level().getEntity(id);
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                itemEntity.setPickUpDelay(next.getIntValue());
                iterator.remove();
                pickupDelayCounter.remove(id);
                continue;
            }
            int count = pickupDelayCounter.get(id);
            if (count == 20) {
                iterator.remove();
                pickupDelayCounter.remove(id);
                continue;
            }
            pickupDelayCounter.put(id, count + 1);
        }
    }

    private static void applyAutoAttack(Minecraft minecraft, LocalPlayer localPlayer) {
        if (!TCClientConfigs.autoAttack || minecraft.gameMode == null || minecraft.gameMode.isDestroying()) {
            return;
        }
        ItemStack itemStack = localPlayer.getMainHandItem();
        if (itemStack.onEntitySwing((LivingEntity)localPlayer, InteractionHand.MAIN_HAND)) {
            return;
        }
        if (BetterCombatHelper.LOADED && BetterCombatHelper.hasWeaponAttributes(itemStack)) {
            return;
        }
        if (TCClientPacketHandler.couldAutoAttack() && minecraft.options.keyAttack.isDown()) {
            AABB aabb;
            if (localPlayer.getAttackStrengthScale(0.5f) < 0.99999f) {
                return;
            }
            MinecraftAccessor accessor = (MinecraftAccessor)minecraft;
            if (accessor.getMissTime() > 0) {
                accessor.setMissTime(0);
            }
            double reach = Math.max(localPlayer.entityInteractionRange(), localPlayer.blockInteractionRange());
            double squared = Mth.square((double)reach);
            Vec3 from = localPlayer.getEyePosition(1.0f);
            HitResult hitResult = localPlayer.pick(reach, 1.0f, false);
            double sqr = hitResult.getLocation().distanceToSqr(from);
            if (hitResult.getType() != HitResult.Type.MISS) {
                squared = sqr;
                reach = Math.sqrt(sqr);
            }
            Vec3 viewVector = localPlayer.getViewVector(1.0f);
            Vec3 to = from.add(viewVector.x * reach, viewVector.y * reach, viewVector.z * reach);
            EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Entity)localPlayer, (Vec3)from, (Vec3)to, (AABB)(aabb = localPlayer.getBoundingBox().expandTowards(viewVector.scale(reach)).inflate(1.0, 1.0, 1.0)), entity -> !entity.isSpectator() && entity.isPickable(), (double)squared);
            if (entityHitResult != null && entityHitResult.getLocation().distanceToSqr(from) < sqr) {
                minecraft.gameMode.attack((Player)localPlayer, entityHitResult.getEntity());
            }
            localPlayer.swing(InteractionHand.MAIN_HAND);
            CommonHooks.onEmptyLeftClick((Player)localPlayer);
        }
    }

    public static void handleRender(BroadcastRenderPacketS2C packet, Player player) {
        short render = packet.render();
        if (player == Minecraft.getInstance().player) {
            luminance = render & 0xF;
            hasNeptunesShell = (render & 0x10) == 16;
        } else {
            int playerId = packet.playerId();
            remoteLuminance.put(playerId, render & 0xF);
            remoteNeptuneShell.put(playerId, (render & 0x10) == 16);
        }
    }

    public static void reset() {
        autoAttack = false;
        hasCthulhu = false;
        hasTabi = false;
        hasMagiluminescence = false;
        rightClickSubtractor = 0;
        canFloating = false;
        hasNeptunesShell = false;
        floating = false;
        luminance = 0;
        pickupDelayStorage.clear();
        pickupDelayCounter.clear();
        remoteLuminance.clear();
        remoteNeptuneShell.clear();
    }
}

