/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.client.renderer.accessory;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.client.model.accessory.MermanModel;
import org.confluence.terra_curio.mixed.IClientLivingEntity;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class MermanRenderer
implements ICurioRenderer {
    static final RenderType CUTOUT = RenderType.entityCutout((ResourceLocation)TerraCurio.asResource("textures/curio/merman.png"));
    private final MermanModel model;

    public MermanRenderer(EntityModelSet entityModels) {
        this.model = new MermanModel(entityModels.bakeLayer(MermanModel.LAYER_LOCATION));
    }

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack itemStack, SlotContext slotContext, PoseStack poseStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource multiBufferSource, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity living = slotContext.entity();
        if (living.isInWaterOrBubble()) {
            ICurioRenderer.followBodyRotations((LivingEntity)living, (HumanoidModel[])new HumanoidModel[]{this.model});
            ICurioRenderer.followHeadRotations((LivingEntity)living, (ModelPart[])new ModelPart[]{this.model.head});
            this.model.renderToBuffer(poseStack, multiBufferSource.getBuffer(CUTOUT), light, OverlayTexture.NO_OVERLAY);
            ((IClientLivingEntity)living).terra_curio$setShowingCosmetic(true);
        }
    }
}

