/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.client.model.entity.BeeProjectileModel;
import org.confluence.terra_curio.common.entity.BeeProjectile;
import org.jetbrains.annotations.NotNull;

public class BeeProjectileRenderer
extends EntityRenderer<BeeProjectile> {
    private static final ResourceLocation TEXTURE = TerraCurio.asResource("textures/entity/bee_projectile.png");
    private final BeeProjectileModel model;

    public BeeProjectileRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new BeeProjectileModel(pContext.bakeLayer(BeeProjectileModel.LAYER_LOCATION));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull BeeProjectile pEntity) {
        return TEXTURE;
    }

    public void render(BeeProjectile entity, float entityYaw, float partialTick, PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.125f, -0.125f);
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTick, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTick, (float)entity.xRotO, (float)entity.getXRot())));
        poseStack.mulPose(Axis.YP.rotation(-1.5707964f));
        if (entity.isGiant()) {
            poseStack.scale(1.5f, 1.5f, 1.5f);
        }
        this.model.renderToBuffer(poseStack, multiBufferSource.getBuffer(this.model.renderType(TEXTURE)), packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

