/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.client.model.entity.StepStoolModel;
import org.confluence.terra_curio.common.entity.StepStoolEntity;

public class StepStoolRenderer
extends EntityRenderer<StepStoolEntity> {
    private static final ResourceLocation TEXTURE = TerraCurio.asResource("textures/entity/step_stool.png");
    private final StepStoolModel model;

    public StepStoolRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new StepStoolModel(pContext.bakeLayer(StepStoolModel.LAYER_LOCATION));
    }

    public ResourceLocation getTextureLocation(StepStoolEntity pEntity) {
        return TEXTURE;
    }

    public void render(StepStoolEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.pushPose();
        pPoseStack.translate(0.0f, 1.5f, 0.0f);
        pPoseStack.mulPose(Axis.ZP.rotation((float)Math.PI));
        for (int i = 0; i < pEntity.getStep(); ++i) {
            this.model.renderToBuffer(pPoseStack, pBuffer.getBuffer(this.model.renderType(this.getTextureLocation(pEntity))), pPackedLight, OverlayTexture.NO_OVERLAY);
            pPoseStack.translate(0.0f, -1.0f, 0.0f);
        }
        pPoseStack.popPose();
    }
}

