/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.client.renderer.tooltip;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.api.primitive.TooltipComponentsValue;
import org.confluence.terra_curio.client.handler.InformationHandler;
import org.confluence.terra_curio.common.item.IFunctionCouldEnable;
import org.confluence.terra_curio.network.InfoDisablePacket;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class MultiFunctionTooltip
implements ClientTooltipComponent {
    private static final Component TOOLTIP = Component.translatable((String)"tooltip.terra_curio.hold_and_scroll");
    private static final ResourceLocation ENABLED = TerraCurio.asResource("textures/gui/information/enabled.png");
    public static final float SCALE = 0.5555556f;
    public static int mouseScrollY = 0;
    public static boolean isShowing = false;
    private final List<TooltipComponentsValue.Storage> storages;
    private int mouseScrolledY = -1;
    private int width = 0;

    public MultiFunctionTooltip(List<TooltipComponentsValue.Storage> storages) {
        this.storages = storages;
    }

    public int getHeight() {
        return MultiFunctionTooltip.isShiftKeyDown() ? this.storages.size() * 10 : 10;
    }

    public int getWidth(@NotNull Font font) {
        if (MultiFunctionTooltip.isShiftKeyDown()) {
            isShowing = true;
            for (TooltipComponentsValue.Storage storage : this.storages) {
                int w = font.width((FormattedText)storage.text());
                if (w <= this.width) continue;
                this.width = w;
            }
            this.width += 10;
            return this.width;
        }
        isShowing = false;
        return font.width((FormattedText)TOOLTIP);
    }

    public void renderText(@NotNull Font font, int mouseX, int mouseY, @NotNull Matrix4f matrix, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull MultiBufferSource.BufferSource bufferSource) {
        if (isShowing) {
            int size = this.storages.size();
            for (int i = 0; i < size; ++i) {
                font.drawInBatch(this.storages.get(i).text(), (float)(mouseX + 10), (float)(mouseY + i * 10), -1, true, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            this.mouseScrolledY = Mth.clamp((int)mouseScrollY, (int)0, (int)size) - 1;
        } else {
            font.drawInBatch(TOOLTIP, (float)mouseX, (float)mouseY, -1431655766, true, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    public void renderImage(@NotNull Font font, int x, int y, @NotNull GuiGraphics guiGraphics) {
        int size = this.storages.size();
        if (mouseScrollY > size) {
            mouseScrollY = 0;
        } else if (mouseScrollY < 0) {
            mouseScrollY = size;
        }
        if (isShowing) {
            for (int i = 0; i < size; ++i) {
                PoseStack pose = guiGraphics.pose();
                pose.pushPose();
                pose.translate((float)x - 2.0f, (float)y - 1.0f + (float)i * 10.0f, 0.0f);
                pose.scale(0.5555556f, 0.5555556f, 0.5555556f);
                TooltipComponentsValue.Storage storage = this.storages.get(i);
                guiGraphics.blit(storage.texture(), 2, 2, 0.0f, 0.0f, 14, 14, 14, 14);
                int index = IFunctionCouldEnable.Multi.INDEX_MAP.getOrDefault((Object)storage, -1);
                if (index != -1 && !InformationHandler.DISABLE[index]) {
                    guiGraphics.blit(ENABLED, 0, 0, 0.0f, 0.0f, 18, 18, 18, 18);
                }
                pose.popPose();
            }
            if (this.mouseScrolledY >= 0) {
                guiGraphics.renderOutline(x - 2, y - 2 + this.mouseScrolledY * 10, this.width + 2, 12, -65536);
            }
        } else {
            if (mouseScrollY > 0) {
                int index = IFunctionCouldEnable.Multi.INDEX_MAP.getOrDefault((Object)this.storages.get(mouseScrollY - 1), -1);
                if (index != -1) {
                    InformationHandler.DISABLE[index] = !InformationHandler.DISABLE[index];
                }
                InfoDisablePacket.sendToServer(InformationHandler.DISABLE);
            }
            mouseScrollY = 0;
        }
    }

    private static boolean isShiftKeyDown() {
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)340);
    }
}

