/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.attachment;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.confluence.lib.util.LibUtils;
import org.confluence.terra_curio.api.event.AfterAccessoryAbilitiesFlushedEvent;
import org.confluence.terra_curio.api.event.RegisterAccessoriesComponentUpdateEvent;
import org.confluence.terra_curio.api.primitive.PrimitiveValue;
import org.confluence.terra_curio.api.primitive.UnitValue;
import org.confluence.terra_curio.api.primitive.ValueType;
import org.confluence.terra_curio.common.component.AccessoriesComponent;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.common.init.TCTags;
import org.confluence.terra_curio.common.item.curio.combat.PanicNecklace;
import org.confluence.terra_curio.util.TCUtils;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AccessoriesAttachment
implements INBTSerializable<CompoundTag> {
    public static final List<ValueType<Unit, UnitValue>> UNITS_REQUIRE_UPDATE = (List)Util.make(new ArrayList(), list -> {
        list.add(TCItems.FLOAT$ON$LIQUID$SURFACE);
        list.add(TCItems.FIRE$ATTACK);
        list.add(TCItems.BRAIN$OF$CONFUSION);
        list.add(TCItems.HIVE$PACK);
        list.add(TCItems.HONEY$COMB);
        list.add(TCItems.MAGIC$QUIVER);
        list.add(TCItems.IGNITE$ARROW);
        list.add(TCItems.FROZEN$TURTLE$SHELL);
        list.add(TCItems.FIRE$IMMUNE);
        list.add(TCItems.FLOWER$BOOTS);
        list.add(TCItems.FROZEN$IMMUNE);
        list.add(TCItems.ICE$SPEED);
        list.add(TCItems.DIVING);
        list.add(TCItems.INFINITE$FLIGHT);
        list.add(TCItems.ICE$SAFE);
        list.add(TCItems.SHIELD$OF$CTHULHU);
        ModLoader.postEvent((Event)new RegisterAccessoriesComponentUpdateEvent.UnitType((ArrayList<ValueType<Unit, UnitValue>>)list));
    });
    public static final List<ValueType<?, ? extends PrimitiveValue<?>>> OTHER_REQUIRE_UPDATE = (List)Util.make(new ArrayList(), list -> {
        list.add(TCItems.NEPTUNES$SHELL);
        list.add(TCItems.STAR$CLOCK);
        list.add(TCItems.INJURY$FREE);
        list.add(TCItems.INVULNERABLE$TICKS$MULTIPLIER);
        list.add(TCItems.LAVA$HURT$REDUCE);
        list.add(TCItems.LAVA$IMMUNE$TICKS);
        list.add(TCItems.RIGHT$CLICK$DELAY$SUBSTRACTOR);
        list.add(TCItems.MOB$IGNORE);
        list.add(TCItems.WALL$CLIMB);
        list.add(TCItems.FART);
        list.add(TCItems.SAND$STORM);
        list.add(TCItems.BLIZZARD);
        list.add(TCItems.TSUNAMI);
        list.add(TCItems.CLOUD);
        list.add(TCItems.MAY$FLY);
        list.add(TCItems.EFFECT$IMMUNITIES);
        list.add(TCItems.TOTEM$WITH$COOLDOWN);
        list.add(TCItems.LUMINANCE);
        ModLoader.postEvent((Event)new RegisterAccessoriesComponentUpdateEvent.OtherType((ArrayList<ValueType<?, ? extends PrimitiveValue<?>>>)list));
    });
    private final Map<ValueType<?, ? extends PrimitiveValue<?>>, PrimitiveValue<?>> valueMap = new HashMap();
    private boolean panicNecklace;
    private transient int remainLavaImmuneTicks;
    private transient int totalLavaImmuneTicks;

    public AccessoriesAttachment() {
        this.setToDefaultValue();
    }

    public void setToDefaultValue() {
        this.valueMap.clear();
        this.panicNecklace = false;
        this.remainLavaImmuneTicks = 0;
        this.totalLavaImmuneTicks = 0;
    }

    public <T, V extends PrimitiveValue<T>> T getValue(ValueType<T, V> type) {
        PrimitiveValue<?> value = this.valueMap.get(type);
        return (T)(value == null ? type.defaultValue() : value.get());
    }

    public <T, V extends PrimitiveValue<T>> List<String> getDescription(ValueType<T, V> type) {
        PrimitiveValue<?> value = this.valueMap.get(type);
        return value == null ? List.of("NONE") : value.getDescription();
    }

    public <T, V extends PrimitiveValue<T>> boolean contains(ValueType<T, V> type) {
        return this.valueMap.containsKey(type);
    }

    public boolean hasPanicNecklace() {
        return this.panicNecklace;
    }

    public void increaseLavaImmuneTicks() {
        if (this.remainLavaImmuneTicks < this.totalLavaImmuneTicks) {
            ++this.remainLavaImmuneTicks;
        }
    }

    public boolean decreaseLavaImmuneTicks() {
        if (this.remainLavaImmuneTicks > 0) {
            --this.remainLavaImmuneTicks;
            return true;
        }
        return false;
    }

    public void flushAbility(LivingEntity living) {
        this.setToDefaultValue();
        CuriosApi.getCuriosInventory((LivingEntity)living).ifPresent(handler -> {
            for (ICurioStacksHandler curioStacksHandler : handler.getCurios().values()) {
                IDynamicStackHandler stackHandler = curioStacksHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    AccessoriesComponent component;
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (stack.isEmpty() || (component = TCUtils.getAccessoriesComponent(stack)) == null) continue;
                    Item item = stack.getItem();
                    for (Map.Entry<ValueType<?, PrimitiveValue<?>>, PrimitiveValue<?>> entry : component.types().entrySet()) {
                        this.putUnitIfPresent(entry.getKey());
                        this.combineValue(entry.getKey(), TCUtils.tryCast(entry.getValue()));
                    }
                    if (!this.panicNecklace && item instanceof PanicNecklace) {
                        this.panicNecklace = true;
                    }
                    LibUtils.forMixin$Inject();
                }
            }
            TagKey<EntityType<?>> ignores = this.getValue(TCItems.MOB$IGNORE);
            if (!TCTags.NOTHING.equals(ignores)) {
                living.level().getEntitiesOfClass(Mob.class, new AABB(living.getOnPos()).inflate(31.5), mob -> mob.getType().is(ignores)).forEach(mob -> {
                    if (mob.getTarget() == living) {
                        mob.setTarget(null);
                    }
                });
            }
            this.totalLavaImmuneTicks = this.getValue(TCItems.LAVA$IMMUNE$TICKS);
        });
        NeoForge.EVENT_BUS.post((Event)new AfterAccessoryAbilitiesFlushedEvent(living));
    }

    private <T, V extends PrimitiveValue<T>> void putUnitIfPresent(ValueType<T, V> type) {
        if (UNITS_REQUIRE_UPDATE.contains(type)) {
            this.valueMap.put(type, UnitValue.INSTANCE);
        }
    }

    private <T, V extends PrimitiveValue<T>> void combineValue(ValueType<T, V> type, V value) {
        if (OTHER_REQUIRE_UPDATE.contains(type)) {
            PrimitiveValue<?> other = this.valueMap.get(type);
            if (other == null) {
                this.valueMap.put((ValueType<?, PrimitiveValue<?>>)type, (PrimitiveValue<?>)value);
            } else {
                PrimitiveValue<?> t = value.combine(other, type.combineRule());
                this.valueMap.put((ValueType<?, PrimitiveValue<?>>)type, (PrimitiveValue<?>)type.newInstance(t));
            }
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        ListTag listTag = new ListTag();
        for (Map.Entry<ValueType<?, PrimitiveValue<?>>, PrimitiveValue<?>> entry : this.valueMap.entrySet()) {
            PrimitiveValue<?> value = entry.getValue();
            value.codec().encodeStart((DynamicOps)NbtOps.INSTANCE, TCUtils.tryCast(value)).result().ifPresent(tag -> {
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.put(((ValueType)entry.getKey()).key().toString(), tag);
                listTag.add((Object)compoundTag);
            });
        }
        nbt.put("valueMap", (Tag)listTag);
        nbt.putBoolean("panicNecklace", this.panicNecklace);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.valueMap.clear();
        ListTag listTag = nbt.getList("valueMap", 10);
        for (Tag tag : listTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            String key = compoundTag.getAllKeys().stream().findFirst().orElse(null);
            if (key == null) continue;
            ResourceLocation location = ResourceLocation.parse((String)key);
            ValueType.VALUE_CODECS.get(location).parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.get(key)).result().ifPresent(value -> this.valueMap.put((ValueType<?, PrimitiveValue<?>>)ValueType.TYPES.get(location), (PrimitiveValue<?>)value));
        }
        this.panicNecklace = nbt.getBoolean("panicNecklace");
    }
}

