/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.attachment;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Unit;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.api.primitive.PrimitiveValue;
import org.confluence.terra_curio.api.primitive.ValueType;
import org.confluence.terra_curio.common.attachment.AccessoriesAttachment;
import org.confluence.terra_curio.common.init.TCAttachments;

public class AccessoriesValueCommand {
    public static final DeferredRegister<ArgumentTypeInfo<?, ?>> INFOS = DeferredRegister.create((ResourceKey)Registries.COMMAND_ARGUMENT_TYPE, (String)"terra_curio");
    public static final Supplier<ArgumentTypeInfo<?, ?>> VALUE_TYPE = INFOS.register("value_type", () -> ArgumentTypeInfos.registerByClass(ValueTypeArgument.class, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree(ValueTypeArgument::type)));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"terra_curio").requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.argument((String)"type", (ArgumentType)ValueTypeArgument.type()).executes(context -> {
            String type = (String)context.getArgument("type", String.class);
            ValueType<?, PrimitiveValue<?>> valueType = ValueType.TYPES.get(TerraCurio.asResource(type));
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            if (valueType == null) {
                source.sendFailure((Component)Component.translatable((String)"argument.terra_curio.unknown_type", (Object[])new Object[]{type}));
                return 0;
            }
            AccessoriesAttachment attachment = (AccessoriesAttachment)source.getEntityOrException().getData(TCAttachments.ACCESSORIES);
            if (valueType.defaultValue() == Unit.INSTANCE) {
                source.sendSystemMessage((Component)Component.literal((String)("Contains: " + attachment.contains(valueType))));
            } else {
                for (String description : attachment.getDescription(valueType)) {
                    source.sendSystemMessage((Component)Component.literal((String)description));
                }
            }
            return 1;
        })));
    }

    public static class ValueTypeArgument
    implements ArgumentType<String> {
        private static final DynamicCommandExceptionType UNKNOWN_TYPE = new DynamicCommandExceptionType(type -> Component.translatable((String)"argument.terra_curio.unknown_type", (Object[])new Object[]{type}));
        private static final List<String> EXAMPLES = Lists.newArrayList((Object[])new String[]{"auto_attack"});
        private static final Function<ValueType<?, ? extends PrimitiveValue<?>>, String> MAPPER = type -> type.key().getPath();
        private static Set<String> AVAILABLE;

        public String parse(StringReader reader) throws CommandSyntaxException {
            try {
                String id = reader.readUnquotedString();
                if (ValueType.TYPES.containsKey(TerraCurio.asResource(id))) {
                    return id;
                }
                throw UNKNOWN_TYPE.create((Object)id);
            }
            catch (Exception e) {
                throw UNKNOWN_TYPE.create((Object)e);
            }
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            if (AVAILABLE == null) {
                AVAILABLE = new HashSet<String>(AccessoriesAttachment.UNITS_REQUIRE_UPDATE.stream().map(MAPPER).toList());
                AVAILABLE.addAll(AccessoriesAttachment.OTHER_REQUIRE_UPDATE.stream().map(MAPPER).toList());
            }
            return SharedSuggestionProvider.suggest(AVAILABLE, (SuggestionsBuilder)builder);
        }

        public Collection<String> getExamples() {
            return EXAMPLES;
        }

        public static ValueTypeArgument type() {
            return new ValueTypeArgument();
        }
    }
}

