/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.component;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.datamaps.DataMapValueMerger;
import net.neoforged.neoforge.registries.datamaps.DataMapValueRemover;
import org.confluence.terra_curio.api.primitive.PrimitiveValue;
import org.confluence.terra_curio.api.primitive.UnitValue;
import org.confluence.terra_curio.api.primitive.ValueType;
import org.jetbrains.annotations.Nullable;

public record AccessoriesComponent(Map<ValueType<?, ? extends PrimitiveValue<?>>, PrimitiveValue<?>> types) implements DataComponentType<AccessoriesComponent>
{
    public static final Codec<AccessoriesComponent> CODEC = Codec.dispatchedMap((Codec)ResourceLocation.CODEC, ValueType.VALUE_CODECS::get).xmap(map -> {
        Hashtable table = new Hashtable();
        map.forEach((key, value) -> table.put(ValueType.TYPES.get(key), (PrimitiveValue<?>)value));
        return new AccessoriesComponent(table);
    }, component -> {
        Hashtable table = new Hashtable();
        component.types.forEach((type, value) -> table.put(type.key(), value));
        return table;
    });
    public static final StreamCodec<ByteBuf, AccessoriesComponent> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);

    public static <T, V extends PrimitiveValue<T>> AccessoriesComponent entry(ValueType<T, V> type, V value) {
        Hashtable map = new Hashtable();
        map.put(type, value);
        return new AccessoriesComponent(map);
    }

    public static <T, V extends PrimitiveValue<T>> AccessoriesComponent of(ValueType<T, V> type, T value) {
        Hashtable map = new Hashtable();
        map.put((ValueType<?, PrimitiveValue<?>>)type, (PrimitiveValue<?>)type.newInstance(value));
        return new AccessoriesComponent(map);
    }

    public static AccessoriesComponent units(ValueType<Unit, ? extends UnitValue> type, ValueType<Unit, ? extends UnitValue> ... types) {
        Hashtable table = new Hashtable(Map.of(type, UnitValue.INSTANCE));
        for (ValueType<Unit, ? extends UnitValue> type1 : types) {
            table.put(type1, UnitValue.INSTANCE);
        }
        return new AccessoriesComponent(table);
    }

    public <T, V extends PrimitiveValue<T>> boolean contains(ValueType<T, V> type) {
        return this.types.containsKey(type);
    }

    @Nullable
    public <T, V extends PrimitiveValue<T>> V get(ValueType<T, V> type) {
        return (V)this.types.get(type);
    }

    public <T, V extends PrimitiveValue<T>> void put(ValueType<T, V> type, V value) {
        if (value instanceof PrimitiveValue) {
            V value1 = value;
            this.types.put(type, value1);
        }
    }

    @Nullable
    public Codec<AccessoriesComponent> codec() {
        return CODEC;
    }

    public StreamCodec<ByteBuf, AccessoriesComponent> streamCodec() {
        return STREAM_CODEC;
    }

    public static class Merger
    implements DataMapValueMerger<Item, AccessoriesComponent> {
        public AccessoriesComponent merge(Registry<Item> registry, Either<TagKey<Item>, ResourceKey<Item>> either, AccessoriesComponent component, Either<TagKey<Item>, ResourceKey<Item>> either1, AccessoriesComponent component1) {
            Hashtable map = new Hashtable(component1.types());
            map.putAll(component.types());
            return new AccessoriesComponent(map);
        }
    }

    public record Remover(List<ValueType<?, ? extends PrimitiveValue<?>>> types) implements DataMapValueRemover<Item, AccessoriesComponent>
    {
        public static final Codec<Remover> CODEC = ValueType.CODEC.listOf().xmap(Remover::new, Remover::types);

        public Optional<AccessoriesComponent> remove(AccessoriesComponent component, Registry<Item> registry, Either<TagKey<Item>, ResourceKey<Item>> source, Item item) {
            HashMap map = new HashMap(component.types());
            for (ValueType<?, ? extends PrimitiveValue<?>> valueType : this.types) {
                map.remove(valueType);
            }
            return Optional.of(new AccessoriesComponent(map));
        }
    }
}

