/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.data.gen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.confluence.terra_curio.common.block.WorkshopBlock;
import org.confluence.terra_curio.common.init.TCBlocks;
import org.confluence.terra_curio.common.init.TCEffects;
import org.confluence.terra_curio.common.init.TCEntities;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.common.item.CellPhone;
import org.confluence.terra_curio.common.item.DemonHeart;
import org.confluence.terra_curio.common.item.DivingHelmet;
import org.confluence.terra_curio.common.item.MagicMirror;
import org.confluence.terra_curio.common.item.curio.BaseCurioItem;

public class ModLanguageProvider
extends LanguageProvider {
    public static final String[] ALL_INFO_EN = new String[]{"Tell the time", "Displays the weather", "Displays the phase of the moon", "Displays fishing information", "Displays the most valuable ore around you", "Displays the name of rare creatures around you", "Detects enemies around you", "Displays how many monsters have been killed", "Displays your damage per second", "Displays how fast the player is moving", "Displays horizontal position", "Displays depth"};
    public static final String[] ALL_INFO_ZH = new String[]{"\u62a5\u65f6", "\u663e\u793a\u5929\u6c14", "\u663e\u793a\u6708\u76f8", "\u663e\u793a\u9493\u9c7c\u4fe1\u606f", "\u663e\u793a\u4f60\u5468\u56f4\u6700\u8d35\u91cd\u7684\u77ff\u77f3", "\u663e\u793a\u60a8\u5468\u56f4\u7a00\u6709\u751f\u7269\u7684\u540d\u79f0", "\u63a2\u6d4b\u4f60\u5468\u56f4\u7684\u654c\u4eba", "\u663e\u793a\u602a\u7269\u51fb\u6740\u6570\u91cf", "\u663e\u793a\u4f60\u7684\u6bcf\u79d2\u4f24\u5bb3", "\u663e\u793a\u73a9\u5bb6\u7684\u79fb\u52a8\u901f\u5ea6", "\u663e\u793a\u6c34\u5e73\u4f4d\u7f6e", "\u663e\u793a\u6df1\u5ea6"};
    public static final String[] ALL_INFO_NAME = new String[]{"minute_watch", "weather_radio", "sextant", "fishermans_pocket_guide", "metal_detector", "life_form_analyzer", "radar", "tally_counter", "dps_meter", "stopwatch", "compass", "depth_meter"};
    private final Map<String, String> enData = new TreeMap<String, String>();
    private final Map<String, String> zhData = new TreeMap<String, String>();
    private final PackOutput output;
    private final String locale;

    public ModLanguageProvider(PackOutput output, String locale) {
        super(output, "terra_curio", locale);
        this.output = output;
        this.locale = locale;
    }

    protected void addTranslations() {
        this.add("creativetab.terra_curio", "Terra Curio", "\u6cf0\u62c9\u9970\u54c1");
        this.add("tooltip.terra_curio.requires_mod_loaded", "This item requires any of the following mods: %s", "\u8be5\u7269\u54c1\u9700\u8981\u4ee5\u4e0b\u4efb\u610f\u6a21\u7ec4\uff1a%s");
        this.add("tooltip.terra_curio.hold_and_scroll", "Hold [Left Shift] and scroll the mouse wheel", "\u6309\u4f4f[\u5de6Shift]\u5e76\u6eda\u52a8\u9f20\u6807\u6eda\u8f6e");
        this.add("tooltip.terra_curio.right_click", "Right click it on inventory to toggle", "\u5728\u7269\u54c1\u680f\u5185\u53f3\u952e\u4ee5\u5f00\u5173");
        for (int i = 0; i < ALL_INFO_EN.length; ++i) {
            this.add("tooltip.terra_curio." + ALL_INFO_NAME[i], ALL_INFO_EN[i], ALL_INFO_ZH[i]);
        }
        this.add("info.terra_curio.time", "Time: [%s:%s]", "\u65f6\u95f4: [%s:%s]");
        this.add("info.terra_curio.radar", "Enemies: %s", "\u654c\u4eba: %s");
        this.add("info.terra_curio.compass.east", "East: %s, ", "\u4e1c: %s, ");
        this.add("info.terra_curio.compass.west", "West: %s, ", "\u897f: %s, ");
        this.add("info.terra_curio.compass.south", "South: %s", "\u5357: %s");
        this.add("info.terra_curio.compass.north", "North: %s", "\u5317: %s");
        this.add("info.terra_curio.depth_meter.surface", "Surface: %s", "\u5730\u8868: %s");
        this.add("info.terra_curio.depth_meter.underground", "Underground: %s", "\u5730\u4e0b: %s");
        this.add("info.terra_curio.tally_counter.unknown", "Kill count unavailable", "\u51fb\u6740\u6570\u4e0d\u53ef\u7528");
        this.add("info.terra_curio.tally_counter", "Killed '", "\u5df2\u6740\u6b7b '");
        this.add("info.terra_curio.life_form_analyzer.none", "No rare creatures nearby!", "\u672a\u53d1\u73b0\u7a00\u6709\u751f\u7269");
        this.add("info.terra_curio.life_form_analyzer", "%s detected nearby!", "\u53d1\u73b0\u7a00\u6709\u751f\u7269: %s");
        this.add("info.terra_curio.metal_detector.none", "No treasure nearby!", "\u672a\u53d1\u73b0\u7a00\u6709\u65b9\u5757");
        this.add("info.terra_curio.metal_detector", "%s detected nearby!", "\u5728\u9644\u8fd1\u53d1\u73b0%s!");
        this.add("info.terra_curio.stopwatch", "Speed: %s m/s", "\u901f\u5ea6: %s m/s");
        this.add("info.terra_curio.dps_meter", "DPS: %s", "DPS: %s");
        this.add("info.terra_curio.sextant.0", "Moon phase: Full Moon", "\u6708\u76f8: \u6ee1\u6708");
        this.add("info.terra_curio.sextant.1", "Moon phase: Waning Gibbous", "\u6708\u76f8: \u4e8f\u51f8\u6708");
        this.add("info.terra_curio.sextant.2", "Moon phase: Third Quarter", "\u6708\u76f8: \u4e0b\u5f26\u6708");
        this.add("info.terra_curio.sextant.3", "Moon phase: Waning Crescent", "\u6708\u76f8: \u6b8b\u6708");
        this.add("info.terra_curio.sextant.4", "Moon phase: New Moon", "\u6708\u76f8: \u65b0\u6708");
        this.add("info.terra_curio.sextant.5", "Moon phase: Waxing Crescent", "\u6708\u76f8: \u5ce8\u7709\u6708");
        this.add("info.terra_curio.sextant.6", "Moon phase: First Quarter", "\u6708\u76f8: \u4e0a\u5f26\u6708");
        this.add("info.terra_curio.sextant.7", "Moon phase: Waxing Gibbous", "\u6708\u76f8: \u76c8\u51f8\u6708");
        this.add("info.terra_curio.weather_radio.clear", "Weather: Clear", "\u5929\u6c14: \u6674\u5929");
        this.add("info.terra_curio.weather_radio.cloudy", "Weather: Cloudy", "\u5929\u6c14: \u9634\u5929,");
        this.add("info.terra_curio.weather_radio.rain", "Weather: Rain", "\u5929\u6c14: \u4e0b\u96e8");
        this.add("info.terra_curio.weather_radio.snow", "Weather: Snow", "\u5929\u6c14: \u4e0b\u96ea");
        this.add("info.terra_curio.weather_radio.thunder", "Weather: Thunder", "\u5929\u6c14: \u96f7\u66b4");
        this.add("info.terra_curio.weather_radio.thunder_snow", "Weather: Thunder Snow", "\u5929\u6c14: \u96f7\u6253\u96ea");
        this.add("info.terra_curio.fishermans_pocket_guide", "Fishing Power: %s", "\u6e14\u529b: %s");
        this.add("attribute.name.generic.critical_chance", "Critical Chance", "\u66b4\u51fb\u7387");
        this.add("attribute.name.generic.ranged_velocity", "Ranged Velocity", "\u8fdc\u7a0b\u901f\u5ea6");
        this.add("attribute.name.generic.ranged_damage", "Ranged Damage", "\u8fdc\u7a0b\u4f24\u5bb3");
        this.add("attribute.name.generic.dodge_chance", "Dodge Chance", "\u95ea\u907f\u7387");
        this.add("attribute.name.generic.magic_damage", "Magic Damage", "\u9b54\u6cd5\u4f24\u5bb3");
        this.add("attribute.name.generic.armor_penetration", "Armor Penetration", "\u62a4\u7532\u7a7f\u900f");
        this.add("attribute.name.player.pickup_range", "Pickup Range", "\u62fe\u53d6\u8303\u56f4");
        this.add("attribute.name.player.aggro", "Aggro", "\u4ec7\u6068");
        this.add("death.attack.star_cloak", "%1$s was squashed by a falling star", "%1%s \u88ab\u5760\u661f\u538b\u6241\u4e86");
        this.add("key.terra_curio.gameplay", "Terra Curio", "\u6cf0\u62c9\u9970\u54c1");
        this.add("key.terra_curio.metal_detector", "Detect Metal", "\u68c0\u6d4b\u77ff\u7269");
        this.add("key.terra_curio.step_stool", "Step Stool", "\u4e0a\u68af\u51f3");
        this.add("key.terra_curio.cthulhu_sprinting", "Cthulhu Sprinting", "\u514b\u82cf\u9c81\u51b2\u523a");
        this.add("curios.identifier.accessory", "Accessory", "\u914d\u9970");
        this.add("accessories.slot.accessory", "Accessory", "\u914d\u9970");
        this.add("curios.modifiers.accessory", "When worn as accessory:", "\u4f69\u6234\u914d\u9970\u65f6\uff1a");
        this.add("container.terra_curio.workshop", "Workshop", "\u5de5\u5320\u4f5c\u574a");
        this.add("title.terra_curio.workshop", "Workshop", "\u5de5\u5320\u4f5c\u574a");
        this.add("title.confluence.workshop", "Workshop", "\u5de5\u5320\u4f5c\u574a");
        this.add("argument.terra_curio.unknown_type", "Unknown Value Type: %s", "\u672a\u77e5\u7684\u503c\u7c7b\u578b: %s");
        this.add("tooltip.item.terra_curio.demon_heart.1", "Remaining Times: %s", "\u5269\u4f59\u6b21\u6570: %s");
        this.add("terra_curio.subtitle.transmission", "Transmission Magic: Activated", "\u4f20\u9001\u9b54\u6cd5\uff1a\u5f00\u542f");
        this.add("terra_curio.subtitle.fart_sound", "Player: Fart Sound", "\u73a9\u5bb6\uff1a\u653e\u5c41\u58f0");
        this.add("terra_curio.subtitle.double_jump", "Player: Double Jump", "\u73a9\u5bb6\uff1a\u4e8c\u6bb5\u8df3");
        this.add("terra_curio.subtitle.shoes_walk", "Shoes: Walking", "\u978b\uff1a\u8dd1\u52a8");
        this.add("terra_curio.subtitle.rocket_boots_boost", "Rocket Boots: Boost", "\u706b\u7bad\u9774\uff1a\u52a9\u63a8");
        this.add("terra_curio.subtitle.rocket_boots_stop", "Rocket Boots: Stop", "\u706b\u7bad\u9774\uff1a\u5173\u95ed");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.BASE_POINT, "\u57fa\u70b9", "'Can you hear the sound in this silence?'", "\u201c\u4f60\u53ef\u542c\u95fb\u8fd9\u5bc2\u9759\u4e4b\u58f0\uff1f\u201d");
        this.add(((BaseCurioItem)((Object)TCItems.EVERLASTING.get())).getDescriptionId(), "Everlasting", "\u4e98\u53e4");
        this.add(((CellPhone)TCItems.CELL_PHONE.get()).getDescriptionId(), "Cell Phone", "\u624b\u673a");
        this.add(((MagicMirror)((Object)TCItems.MAGIC_MIRROR.get())).getDescriptionId(), "Magic Mirror", "\u9b54\u955c");
        this.add(((DemonHeart)((Object)TCItems.DEMON_HEART.get())).getDescriptionId(), "Demon Heart", "\u6076\u9b54\u4e4b\u5fc3");
        this.onlyJeiInfo((Supplier<? extends Item>)TCItems.AGLET, "\u978b\u5e26\u675f\u5934", "It can be found in Shipwreck Chests.", "\u5b83\u51fa\u73b0\u5728\u6c89\u8239\u5b9d\u7bb1\u4e2d");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.AMBER_HORSESHOE_BALLOON, "\u7425\u73c0\u9a6c\u638c\u6c14\u7403", new String[]{"Increases jump height", "Negates fall damage", "Releases bees and douses the user in honey when damaged"}, new String[]{"\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6", "\u6d88\u9664\u6389\u843d\u4f24\u5bb3", "\u53d7\u5230\u4f24\u5bb3\u540e\u91ca\u653e\u871c\u8702\u5e76\u5c06\u4f7f\u7528\u8005\u6d78\u5165\u8702\u871c\u4e2d"});
        this.onlyTooltips((Supplier<? extends Item>)TCItems.AMBHIPIAN_BOOTS, "\u6c34\u9646\u4e24\u7528\u9774", new String[]{"The wearer can run super fast", "Increases jump height", "Increases fall resistance"}, new String[]{"\u7a7f\u6234\u8005\u53ef\u98de\u901f\u5954\u8dd1", "\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6", "\u589e\u52a0\u6297\u5760\u843d\u6027"});
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.ANCIENT_CHISEL, "\u8fdc\u53e4\u51ff\u5b50", "\u201cAge-old problems require age-old solutions\u201d", "\u201c\u53e4\u8001\u7684\u95ee\u9898\u9700\u8981\u53e4\u8001\u7684\u89e3\u51b3\u65b9\u6848\u201d", "The item can be obtained through Archaeology.", "\u8be5\u7269\u54c1\u53ef\u4ee5\u901a\u8fc7\u8003\u53e4\u83b7\u5f97\u3002");
        this.onlyJeiInfo((Supplier<? extends Item>)TCItems.ANGLER_EARRING, "\u6e14\u592b\u8033\u73af", "This item can be located in the chests found within Fisherman Villagers' houses.", "\u8fd9\u4ef6\u7269\u54c1\u53ef\u4ee5\u5728\u6e14\u592b\u6751\u6c11\u5bb6\u4e2d\u7684\u7bb1\u5b50\u4e2d\u627e\u5230\u3002");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.ANKH_CHARM, "\u5341\u5b57\u7ae0\u62a4\u8eab\u7b26", "Grants immunity to most debuffs.", "\u5bf9\u5927\u90e8\u5206\u51cf\u76ca\u514d\u75ab\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.ANKH_SHIELD, "\u5341\u5b57\u7ae0\u62a4\u76fe", new String[]{"Grants immunity to most debuffs.", "Grants immunity to fire blocks"}, new String[]{"\u5bf9\u5927\u90e8\u5206\u51cf\u76ca\u514d\u75ab\u3002", "\u5bf9\u706b\u5757\u514d\u75ab"});
        this.onlyZhName((Supplier<? extends Item>)TCItems.ANKLET_OF_THE_WIND, "\u75be\u98ce\u811a\u956f");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.ARCHITECT_GIZMO_PACK, "\u5efa\u7b51\u5e08\u53d1\u660e\u80cc\u5305", "Decreased 'Right Click Delay' by 2, cannot stack the decrease of its materials", "\u53f3\u952e\u70b9\u51fb\u5ef6\u8fdf\u964d\u4f4e2\uff0c\u4e14\u964d\u4f4e\u6548\u679c\u4e0d\u80fd\u4e0e\u5176\u6750\u6599\u7684\u964d\u4f4e\u6548\u679c\u53e0\u52a0\u3002");
        this.onlyZhName((Supplier<? extends Item>)TCItems.AVENGER_EMBLEM, "\u590d\u4ec7\u8005\u5fbd\u7ae0");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.BALLOON_PUFFERFISH, "\u6c14\u7403\u6cb3\u8c5a\u9c7c", "Increases jump height", "\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.BAND_OF_REGENERATION, "\u518d\u751f\u624b\u73af", "Slowly regenerates life", "\u7f13\u6162\u518d\u751f\u751f\u547d", "The Band of Regeneration is an accessory that has a Chance to be dropped from Witch", "\u5b83\u6709\u51e0\u7387\u4ece\u5973\u5deb\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.BEE_CLOAK, "\u871c\u8702\u6597\u7bf7", new String[]{"Causes stars to fall after taking damage", "Releases bees and douses the user in honey when damaged"}, new String[]{"\u53d7\u5230\u4f24\u5bb3\u540e\u4f1a\u4f7f\u661f\u661f\u5760\u843d", "\u53d7\u5230\u4f24\u5bb3\u540e\u91ca\u653e\u871c\u8702\u5e76\u5c06\u4f7f\u7528\u8005\u6d78\u5165\u8702\u871c\u4e2d"});
        this.onlyTooltips((Supplier<? extends Item>)TCItems.BERSERKERS_GLOVE, "\u72c2\u6218\u58eb\u624b\u5957", new String[]{"Enables auto swing for melee weapons", "Enemies are more likely to target you"}, new String[]{"\u542f\u7528\u8fd1\u6218\u6b66\u5668\u81ea\u52a8\u6325\u52a8", "\u591a\u4eba\u6a21\u5f0f\u65f6\uff0c\u654c\u4eba\u66f4\u53ef\u80fd\u4ee5\u4f60\u4e3a\u76ee\u6807"});
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.BEZOAR, "\u725b\u9ec4", "Immunity to Poison", "\u5bf9\u4e2d\u6bd2\u514d\u75ab", "It has a Chance to be dropped from Cave Spider.", "\u5b83\u6709\u51e0\u7387\u4ece\u6d1e\u7a74\u8718\u86db\u8eab\u4e0a\u6389\u843d\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.BLACK_BELT, "\u9ed1\u8170\u5e26", "Gives a chance to dodge attacks", "\u6709\u51e0\u7387\u907f\u5f00\u653b\u51fb", "It has a Chance to be dropped from Wither Skeleton.", "\u5b83\u6709\u51e0\u7387\u4ece\u51cb\u96f6\u9ab7\u9ac5\u8eab\u4e0a\u6389\u843d\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.BLINDFOLD, "\u8499\u773c\u5e03", "Immunity to Blindness", "\u5bf9\u5931\u660e\u514d\u75ab", "It can be discovered in chests found within Ancient City.", "\u5b83\u53ef\u4ee5\u5728\u53e4\u4ee3\u57ce\u5185\u7684\u7bb1\u5b50\u4e2d\u627e\u5230\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.BLIZZARD_IN_A_BALLOON, "\u66b4\u96ea\u6c14\u7403", new String[]{"Allows the holder to double jump", "Increases jump height"}, new String[]{"\u53ef\u8ba9\u6301\u6709\u8005\u4e8c\u6bb5\u8df3", "\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6"});
        this.onlyTooltip((Supplier<? extends Item>)TCItems.BLIZZARD_IN_A_BOTTLE, "\u66b4\u96ea\u74f6", "Allows the holder to double jump", "\u53ef\u8ba9\u6301\u6709\u8005\u4e8c\u6bb5\u8df3");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.BLUE_HORSESHOE_BALLOON, "\u84dd\u9a6c\u638c\u6c14\u7403", new String[]{"Allows the holder to double jump", "Increases jump height", "Negates fall damage"}, new String[]{"\u53ef\u8ba9\u6301\u6709\u8005\u4e8c\u6bb5\u8df3", "\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6", "\u6d88\u9664\u6389\u843d\u4f24\u5bb3"});
        this.onlyTooltips((Supplier<? extends Item>)TCItems.WHITE_HORSESHOE_BALLOON, "\u767d\u9a6c\u638c\u6c14\u7403", new String[]{"Allows the holder to double jump", "Increases jump height", "Negates fall damage"}, new String[]{"\u53ef\u8ba9\u6301\u6709\u8005\u4e8c\u6bb5\u8df3", "\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6", "\u6d88\u9664\u6389\u843d\u4f24\u5bb3"});
        this.tooltipsAndJeiInfo((Supplier<? extends Item>)TCItems.BRAIN_OF_CONFUSION, "\u6df7\u4e71\u4e4b\u8111", new String[]{"Has a chance to create illusions and dodge an attack", "Temporarily increase critical chance for 4% after dodge", "May confuse nearby enemies after being struck"}, new String[]{"\u6709\u51e0\u7387\u5236\u9020\u5e7b\u89c9\u5e76\u8eb2\u907f\u653b\u51fb", "\u95ea\u907f\u540e\u6682\u65f6\u589e\u52a04%\u66b4\u51fb\u51e0\u7387", "\u88ab\u51fb\u4e2d\u540e\u53ef\u80fd\u4f1a\u8ff7\u60d1\u9644\u8fd1\u7684\u654c\u4eba"}, "It has a Chance to be dropped from Zombie Villager.", "\u5b83\u6709\u51e0\u7387\u4ece\u50f5\u5c38\u6751\u6c11\u8eab\u4e0a\u6389\u843d\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.BRICK_LAYER, "\u780c\u7816\u5200", "Decreased 'Right Click Delay' by 1", "\u53f3\u952e\u70b9\u51fb\u5ef6\u8fdf\u964d\u4f4e1", "This item can be located in the chests found within Toolsmith Villagers' houses.", "\u8fd9\u4ef6\u7269\u54c1\u53ef\u4ee5\u5728\u5de5\u5177\u5320\u6751\u6c11\u5bb6\u4e2d\u7684\u7bb1\u5b50\u4e2d\u627e\u5230\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.BUNDLE_OF_BALLOONS, "\u6c14\u7403\u675f", new String[]{"Allows the holder to quadruple jump", "Increases jump height"}, new String[]{"\u53ef\u8ba9\u6301\u6709\u8005\u56db\u6bb5\u8df3", "\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6"});
        this.onlyTooltips((Supplier<? extends Item>)TCItems.BUNDLE_OF_HORSESHOE_BALLOONS, "\u9a6c\u638c\u6c14\u7403\u675f", new String[]{"Allows the holder to quadruple jump", "Increases jump height", "Negates fall damage"}, new String[]{"\u53ef\u8ba9\u6301\u6709\u8005\u56db\u6bb5\u8df3", "\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6", "\u6d88\u9664\u6389\u843d\u4f24\u5bb3"});
        this.onlyTooltip((Supplier<? extends Item>)TCItems.CELESTIAL_STONE, "\u5929\u754c\u77f3", "Slightly increases the attribute value", "\u5c0f\u5e45\u63d0\u9ad8\u5c5e\u6027\u503c");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.CELL_PHONE, "\u624b\u673a", new String[]{"Displays everything", "Allows you to return home at will"}, new String[]{"\u663e\u793a\u6240\u6709\u4fe1\u606f", "\u53ef\u968f\u610f\u56de\u5bb6"});
        this.tooltipsAndJeiInfo((Supplier<? extends Item>)TCItems.CLIMBING_CLAWS, "\u6500\u722c\u722a", new String[]{"Allows the ability to slide down walls, hold Crouch key to slide down quickly", "Improved ability if combined with Shoe Spikes"}, new String[]{"\u53ef\u6cbf\u5899\u6ed1\u4e0b\uff0c\u6309\u4f4f\u6f5c\u884c\u952e\u53ef\u66f4\u5feb\u5730\u4e0b\u6ed1", "\u7ed3\u5408\u978b\u9489\u4f7f\u7528\u65f6\u80fd\u529b\u8fd8\u4f1a\u6709\u6240\u63d0\u5347"}, "It has a Chance to be dropped from Spider.", "\u5b83\u6709\u51e0\u7387\u4ece\u8718\u86db\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.CLOUD_IN_A_BALLOON, "\u4e91\u6735\u6c14\u7403", new String[]{"Allows the holder to double jump", "Increases jump height"}, new String[]{"\u53ef\u8ba9\u6301\u6709\u8005\u4e8c\u6bb5\u8df3", "\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6"});
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.CLOUD_IN_A_BOTTLE, "\u4e91\u6735\u74f6", "Allows the holder to double jump", "\u53ef\u8ba9\u6301\u6709\u8005\u4e8c\u6bb5\u8df3", "It can be found in Chests in the Mineshaft and Dungeon.", "\u5b83\u53ef\u4ee5\u5728\u77ff\u4e95\u548c\u5730\u7262\u7684\u5b9d\u7bb1\u4e2d\u627e\u5230\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.COBALT_SHIELD, "\u94b4\u62a4\u76fe", "Grants immunity to knockback", "\u5bf9\u51fb\u9000\u514d\u75ab", "It has a Chance to be dropped from Ravager.", "\u5b83\u6709\u51e0\u7387\u4ece\u52ab\u63a0\u517d\u8eab\u4e0a\u6389\u843d\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.COMPASS, "\u7f57\u76d8", "Displays horizontal position", "\u663e\u793a\u6c34\u5e73\u4f4d\u7f6e", "The Compass has a Chance to be dropped from Bats.", "\u5b83\u6709\u51e0\u7387\u4ece\u8759\u8760\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.COPPER_WATCH, "\u94dc\u8868", "Tell the time", "\u62a5\u65f6");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.TIN_WATCH, "\u9521\u8868", "Tell the time", "\u62a5\u65f6");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.TUNGSTEN_WATCH, "\u94a8\u8868", "Tell the time", "\u62a5\u65f6");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.CROSS_NECKLACE, "\u5341\u5b57\u9879\u94fe", "Increases length of invincibility after taking damage", "\u589e\u52a0\u53d7\u5230\u4f24\u5bb3\u540e\u7684\u65e0\u654c\u65f6\u95f4", "It has a Chance to be dropped from Evoker.", "\u5b83\u6709\u51e0\u7387\u4ece\u5524\u9b54\u8005\u8eab\u4e0a\u6389\u843d\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.DEMON_HEART, "\u6076\u9b54\u4e4b\u5fc3", "Permanently increases the number of accessory slots", "\u6c38\u4e45\u589e\u52a0\u914d\u9970\u680f\u6570\u91cf", "It is dropped by the Wither.", "\u5b83\u5fc5\u5b9a\u4ece\u51cb\u96f6\u8eab\u4e0a\u6389\u843d\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.DEPTH_METER, "\u6df1\u5ea6\u8ba1", "Displays depth", "\u663e\u793a\u6df1\u5ea6", "The Compass has a Chance to be dropped from Bats.", "\u5b83\u6709\u51e0\u7387\u4ece\u8759\u8760\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyZhName((Supplier<? extends Item>)TCItems.DESTROYER_EMBLEM, "\u6bc1\u706d\u8005\u5fbd\u7ae0");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.DETOXIFICATION_CAPSULE, "\u89e3\u6bd2\u56ca", "Immunity to Poison and Wither", "\u5bf9\u4e2d\u6bd2\u548c\u51cb\u96f6\u514d\u75ab");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.DPS_METER, "\u6bcf\u79d2\u4f24\u5bb3\u8ba1\u6570\u5668", "Displays your damage per second", "\u663e\u793a\u4f60\u7684\u6bcf\u79d2\u4f24\u5bb3", "The DPS Meter has a Chance to be dropped from Creeper.", "\u5b83\u6709\u51e0\u7387\u4ece\u82e6\u529b\u6015\u8eab\u4e0a\u6389\u843d\u3002");
        this.tooltipsAndJeiInfo((Supplier<? extends Item>)TCItems.DUNERIDER_BOOTS, "\u6c99\u4e18\u884c\u8005\u9774", new String[]{"The wearer can run super fast, and even faster on sand", "'Walk without rhythm and you won't attract the worm'"}, new String[]{"\u7a7f\u6234\u8005\u53ef\u98de\u901f\u5954\u8dd1\uff0c\u5728\u6c99\u5730\u4e0a\u8fd8\u80fd\u8dd1\u5f97\u66f4\u5feb", "\u201c\u65e0\u8282\u5f8b\u884c\u8d70\u5c31\u4e0d\u4f1a\u5f15\u6765\u8815\u866b\u201d"}, "It has a Chance to be dropped from Husk.", "\u5b83\u6709\u51e0\u7387\u4ece\u5c38\u58f3\u8eab\u4e0a\u6389\u843d\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.ENERGY_BAR, "\u80fd\u91cf\u68d2", "Immunity to Hunger", "\u5bf9\u9965\u997f\u514d\u75ab", "It has a Chance to be dropped from Zombified Piglin.", "\u5b83\u6709\u51e0\u7387\u4ece\u50f5\u5c38\u732a\u7075\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.EXPLORERS_EQUIPMENT, "\u63a2\u9669\u5bb6\u5b9d\u5177", "Immunity to Mining Fatigue and Levitation", "\u5bf9\u6316\u6398\u75b2\u52b3\u548c\u6f02\u6d6e\u514d\u75ab");
        this.onlyJeiInfo((Supplier<? extends Item>)TCItems.EXTENDO_GRIP, "\u52a0\u957f\u63e1\u722a", "It can be discovered in chests found within Desert Pyramids.", "\u5b83\u53ef\u4ee5\u5728\u6c99\u6f20\u795e\u6bbf\u5185\u7684\u7bb1\u5b50\u4e2d\u627e\u5230");
        this.onlyJeiInfo((Supplier<? extends Item>)TCItems.EYE_OF_THE_GOLEM, "\u77f3\u5de8\u4eba\u4e4b\u773c", "It can be discovered in chests found within Jungle Pyramids.", "\u5b83\u53ef\u4ee5\u5728\u4e1b\u6797\u795e\u5e99\u5185\u7684\u7bb1\u5b50\u4e2d\u627e\u5230");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.FAIRY_BOOTS, "\u4ed9\u7075\u9774", new String[]{"Allows flight, super fast running", "Flowers grow on the grass you walk on"}, new String[]{"\u53ef\u98de\u884c\u3001\u53ef\u98de\u901f\u5954\u8dd1", "\u4f60\u8d70\u8fc7\u7684\u8349\u5730\u4e0a\u4f1a\u957f\u51fa\u82b1\u6735"});
        this.onlyTooltips((Supplier<? extends Item>)TCItems.FART_IN_A_BALLOON, "\u81ed\u5c41\u6c14\u7403", new String[]{"Allows the holder to double jump", "Increases jump height"}, new String[]{"\u53ef\u8ba9\u6301\u6709\u8005\u4e8c\u6bb5\u8df3", "\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6"});
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.FART_IN_A_JAR, "\u7f50\u4e2d\u81ed\u5c41", "Allows the holder to double jump", "\u53ef\u8ba9\u6301\u6709\u8005\u4e8c\u6bb5\u8df3", "It has a Chance to be dropped from Ghost.", "\u5b83\u6709\u51e0\u7387\u4ece\u6076\u9b42\u8eab\u4e0a\u6389\u843d");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.FAST_CLOCK, "\u5feb\u8d70\u65f6\u949f", "Immunity to Slowness", "\u5bf9\u7f13\u6162\u514d\u75ab", "It has a Chance to be dropped from Stray.", "\u5b83\u6709\u51e0\u7387\u4ece\u6d41\u6d6a\u8005\u8eab\u4e0a\u6389\u843d\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.FERAL_CLAWS, "\u731b\u722a\u624b\u5957", "Enables auto swing for melee weapons", "\u542f\u7528\u8fd1\u6218\u6b66\u5668\u81ea\u52a8\u6325\u52a8", "It can be discovered in chests found within Jungle Pyramids.", "\u5b83\u53ef\u4ee5\u5728\u4e1b\u6797\u795e\u5e99\u5185\u7684\u7bb1\u5b50\u4e2d\u627e\u5230");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.FIRE_GAUNTLET, "\u70c8\u706b\u624b\u5957", new String[]{"Enables auto swing for melee weapons", "Increases melee knockback and melee attacks inflict fire damage"}, new String[]{"\u542f\u7528\u8fd1\u6218\u6b66\u5668\u81ea\u52a8\u6325\u52a8", "\u589e\u52a0\u8fd1\u6218\u51fb\u9000\u5e76\u4f7f\u653b\u51fb\u9644\u7740\u706b\u7130\u4f24\u5bb3"});
        this.onlyTooltips((Supplier<? extends Item>)TCItems.FISH_FINDER, "\u63a2\u9c7c\u5668", new String[]{"Displays fishing information", "Displays the weather", "Displays the phase of the moon"}, new String[]{"\u663e\u793a\u9493\u9c7c\u4fe1\u606f", "\u663e\u793a\u5929\u6c14", "\u663e\u793a\u6708\u76f8"});
        this.onlyTooltip((Supplier<? extends Item>)TCItems.TIGER_CLIMBING_GEAR, "\u731b\u864e\u6500\u722c\u88c5\u5907", "Allows the ability to climb walls, hold Crouch key to slide down", "\u53ef\u722c\u5899\uff0c\u6309\u4f4f\u6f5c\u884c\u952e\u53ef\u5feb\u901f\u4e0b\u6ed1");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.FISHERMANS_POCKET_GUIDE, "\u6e14\u6c11\u8896\u73cd\u5b9d\u5178", "Displays fishing information", "\u663e\u793a\u9493\u9c7c\u4fe1\u606f", "This item can be located in the chests found within Fisherman Villagers' houses.", "\u8fd9\u4ef6\u7269\u54c1\u53ef\u4ee5\u5728\u6e14\u592b\u6751\u6c11\u5bb6\u4e2d\u7684\u7bb1\u5b50\u4e2d\u627e\u5230\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.FLASHLIGHT, "\u624b\u7535\u7b52", "Immunity to Darkness", "\u5bf9\u9ed1\u6697\u514d\u75ab", "It can be discovered in chests found within Stronghold.", "\u5b83\u53ef\u4ee5\u5728\u8981\u585e\u5185\u7684\u7bb1\u5b50\u4e2d\u627e\u5230\u3002");
        this.tooltipsAndJeiInfo((Supplier<? extends Item>)TCItems.FLESH_KNUCKLES, "\u8840\u8089\u6307\u864e", new String[]{"Enemies are more likely to target you"}, new String[]{"\u591a\u4eba\u6a21\u5f0f\u65f6\uff0c\u654c\u4eba\u66f4\u53ef\u80fd\u4ee5\u4f60\u4e3a\u76ee\u6807"}, "It has a Chance to be dropped from Piglin Brute.", "\u5b83\u6709\u51e0\u7387\u4ece\u732a\u7075\u86ee\u5175\u8eab\u4e0a\u6389\u843d");
        this.onlyJeiInfo((Supplier<? extends Item>)TCItems.FLIPPER, "\u811a\u8e7c", "It can be found in Chests in the Shipwreck.", "\u5b83\u51fa\u73b0\u5728\u6c89\u8239\u5b9d\u7bb1\u4e2d");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.FLOWER_BOOTS, "\u82b1\u9774", "Flowers grow on the grass you walk on", "\u4f60\u8d70\u8fc7\u7684\u8349\u5730\u4e0a\u4f1a\u957f\u51fa\u82b1\u6735", "It has a chance of falling from digging through Moss Block.", "\u5b83\u6709\u51e0\u7387\u4ece\u6316\u6398\u82d4\u85d3\u5757\u65f6\u6389\u843d\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.FLURRY_BOOTS, "\u75be\u98ce\u96ea\u9774", "The wearer can run super fast", "\u7a7f\u6234\u8005\u53ef\u98de\u901f\u5954\u8dd1", "It can be found in Igloo's chest.", "\u5b83\u51fa\u73b0\u5728\u96ea\u5730\u5c0f\u5c4b\u4e2d\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.FROG_FLIPPER, "\u9752\u86d9\u811a\u8e7c", new String[]{"Increases jump height", "Increases fall resistance"}, new String[]{"\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6", "\u589e\u52a0\u6297\u5760\u843d\u6027"});
        this.onlyTooltips((Supplier<? extends Item>)TCItems.FROG_GEAR, "\u9752\u86d9\u88c5\u5907", new String[]{"'It ain't easy being green'", "Increases jump height", "Increases fall resistance", "Allows the ability to climb walls, hold Crouch key to slide down"}, new String[]{"\u201c\u8eab\u4e3a\u7eff\u76ae\u751f\u7269\u53ef\u592a\u96be\u4e86\u201d", "\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6", "\u589e\u52a0\u6297\u5760\u843d\u6027", "\u53ef\u722c\u5899\uff0c\u6309\u4f4f\u6f5c\u884c\u952e\u53ef\u5feb\u901f\u4e0b\u6ed1"});
        this.tooltipsAndJeiInfo((Supplier<? extends Item>)TCItems.FROG_LEG, "\u86d9\u817f", new String[]{"Increases jump height", "Increases fall resistance"}, new String[]{"\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6", "\u589e\u52a0\u6297\u5760\u843d\u6027"}, "The Frog Leg has a Chance to be dropped from Frog.", "\u5b83\u6709\u51e0\u7387\u4ece\u9752\u86d9\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.FROG_WEBBING, "\u9752\u86d9\u8e7c", new String[]{"Increases jump height", "Increases fall resistance", "Allows the ability to climb walls, hold Crouch key to slide down"}, new String[]{"\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6", "\u589e\u52a0\u6297\u5760\u843d\u6027", "\u53ef\u722c\u5899\uff0c\u6309\u4f4f\u6f5c\u884c\u952e\u53ef\u5feb\u901f\u4e0b\u6ed1"});
        this.onlyTooltip((Supplier<? extends Item>)TCItems.FROSTSPARK_BOOTS, "\u971c\u82b1\u9774", "Allows flight, super fast running, and extra mobility on ice", "\u53ef\u98de\u884c\u3001\u98de\u901f\u5954\u8dd1\u3001\u5e76\u63d0\u4f9b\u989d\u5916\u51b0\u9762\u884c\u52a8\u529b");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.FROZEN_SHIELD, "\u51b0\u51bb\u62a4\u76fe", new String[]{"Absorbs 25% of damage done to players on your team when above 25% life", "Puts a shell around the owner when below 50% life that reduces damage by 25%"}, new String[]{"\u5f53\u751f\u547d\u503c\u8d85\u8fc725%\u65f6\uff0c\u5438\u6536\u5bf9\u56e2\u961f\u4e2d\u73a9\u5bb6\u9020\u6210\u768425%\u4f24\u5bb3", "\u5f53\u751f\u547d\u503c\u4f4e\u4e8e50%\u65f6\uff0c\u5728\u4e3b\u4eba\u5468\u56f4\u653e\u7f6e\u4e00\u4e2a\u5916\u58f3\uff0c\u4f7f\u4f24\u5bb3\u964d\u4f4e25%"});
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.FROZEN_TURTLE_SHELL, "\u51b0\u51bb\u6d77\u9f9f\u58f3", "Puts a shell around the owner when below 50% life that reduces damage by 25%", "\u5f53\u751f\u547d\u503c\u4f4e\u4e8e50%\u65f6\uff0c\u5728\u4e3b\u4eba\u5468\u56f4\u653e\u7f6e\u4e00\u4e2a\u5916\u58f3\uff0c\u4f7f\u4f24\u5bb3\u964d\u4f4e25%", "When the Turtle died for Freezing chance to dropped this item.", "\u5f53\u6d77\u9f9f\u56e0\u51b0\u51bb\u800c\u6b7b\u65f6\uff0c\u6709\u51e0\u7387\u6389\u843d\u8fd9\u4e2a\u9970\u54c1\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.GOBLIN_TECH, "\u54e5\u5e03\u6797\u6570\u636e\u4eea", new String[]{"Displays the most valuable ore around you", "Displays how fast the player is moving", "Displays your damage per second"}, new String[]{"\u663e\u793a\u4f60\u5468\u56f4\u6700\u8d35\u91cd\u7684\u77ff\u77f3", "\u663e\u793a\u73a9\u5bb6\u7684\u79fb\u52a8\u901f\u5ea6", "\u663e\u793a\u4f60\u7684\u6bcf\u79d2\u4f24\u5bb3"});
        this.onlyTooltip((Supplier<? extends Item>)TCItems.GOLD_WATCH, "\u91d1\u8868", "Tell the time", "\u62a5\u65f6");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.GPS, "\u5168\u7403\u5b9a\u4f4d\u7cfb\u7edf", new String[]{"Tell the time", "Displays depth", "Displays horizontal position"}, new String[]{"\u62a5\u65f6", "\u663e\u793a\u6df1\u5ea6", "\u663e\u793a\u6c34\u5e73\u4f4d\u7f6e"});
        this.tooltipsAndJeiInfo((Supplier<? extends Item>)TCItems.GRAVITY_GLOBE, "\u91cd\u529b\u7403", new String[]{"Allows the holder to reverse gravity", "Press Jump to change gravity"}, new String[]{"\u53ef\u8ba9\u6301\u6709\u8005\u53cd\u8f6c\u91cd\u529b", "\u6309\u8df3\u8dc3\u952e\u53ef\u6539\u53d8\u91cd\u529b"}, "It has a Chance to be dropped from Shulker.", "\u5b83\u6709\u51e0\u7387\u4ece\u6f5c\u5f71\u8d1d\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.GREEN_HORSESHOE_BALLOON, "\u7eff\u9a6c\u638c\u6c14\u7403", new String[]{"Allows the holder to double jump", "Increases jump height", "Negates fall damage"}, new String[]{"\u53ef\u8ba9\u6301\u6709\u8005\u4e8c\u6bb5\u8df3", "\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6", "\u6d88\u9664\u6389\u843d\u4f24\u5bb3"});
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.HAND_DRILL, "\u624b\u94bb", "Immunity to Mining Fatigue", "\u5bf9\u6316\u6398\u75b2\u52b3\u514d\u75ab", "It has a Chance to be dropped from Elder Guardian.", "\u5b83\u6709\u51e0\u7387\u4ece\u8fdc\u53e4\u5b88\u536b\u8005\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.HAND_OF_CREATION, "\u521b\u9020\u4e4b\u624b", new String[]{"Decreased 'Right Click Delay' by 3, cannot stack the decrease of its material", "Press \u2191 key to stand higher, and press Crouch key to down"}, new String[]{"\u53f3\u952e\u70b9\u51fb\u5ef6\u8fdf\u964d\u4f4e3\uff0c\u4e14\u964d\u4f4e\u6548\u679c\u4e0d\u80fd\u4e0e\u5176\u6750\u6599\u7684\u964d\u4f4e\u6548\u679c\u53e0\u52a0", "\u6309\u2191\u952e\u7ad9\u5f97\u66f4\u9ad8\uff0c\u6309\u6f5c\u884c\u952e\u4e0b\u6765"});
        this.onlyTooltip((Supplier<? extends Item>)TCItems.HAND_WARMER, "\u6696\u624b\u5b9d", "Provides immunity to powder snow", "\u5bf9\u7ec6\u96ea\u514d\u75ab");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.HERMES_BOOTS, "\u8d6b\u5c14\u58a8\u65af\u9774", "The wearer can run super fast", "\u7a7f\u6234\u8005\u53ef\u98de\u901f\u5954\u8dd1", "It can be found in Chests in the Village Armorer.", "\u5b83\u53ef\u4ee5\u5728\u6751\u5e84\u76d4\u7532\u5320\u7684\u5b9d\u7bb1\u4e2d\u627e\u5230");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.HERO_SHIELD, "\u82f1\u96c4\u62a4\u76fe", "Enemies are more likely to target you", "\u591a\u4eba\u6a21\u5f0f\u65f6\uff0c\u654c\u4eba\u66f4\u53ef\u80fd\u4ee5\u4f60\u4e3a\u76ee\u6807");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.HIVE_PACK, "\u8702\u5de2\u80cc\u5305", "Increases the strength of friendly bees", "\u589e\u52a0\u53cb\u597d\u871c\u8702\u7684\u529b\u91cf", "It has a Chance to be dropped from Bee.", "\u5b83\u6709\u51e0\u7387\u4ece\u871c\u8702\u8eab\u4e0a\u6389\u843d\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.HOLY_WATER, "\u5723\u6c34", "Immunity to Wither", "\u5bf9\u51cb\u96f6\u514d\u75ab", "It has a Chance to be dropped from Wither Skeleton.", "\u5b83\u6709\u51e0\u7387\u4ece\u51cb\u96f6\u9ab7\u9ac5\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.HONEY_BALLOON, "\u8702\u871c\u6c14\u7403", new String[]{"Releases bees and douses the user in honey when damaged", "Increases jump height"}, new String[]{"\u53d7\u5230\u4f24\u5bb3\u540e\u91ca\u653e\u871c\u8702\u5e76\u5c06\u4f7f\u7528\u8005\u6d78\u5165\u8702\u871c\u4e2d", "\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6"});
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.HONEY_COMB, "\u8702\u7a9d", "Releases bees and douses the user in honey when damaged", "\u53d7\u5230\u4f24\u5bb3\u540e\u91ca\u653e\u871c\u8702\u5e76\u5c06\u4f7f\u7528\u8005\u6d78\u5165\u8702\u871c\u4e2d", "It has a Chance to be dropped from Bee.", "\u5b83\u6709\u51e0\u7387\u4ece\u871c\u8702\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.ICE_SKATES, "\u6e9c\u51b0\u978b", "Provides extra mobility on ice", "\u63d0\u4f9b\u989d\u5916\u51b0\u9762\u884c\u52a8\u529b");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.LAVA_CHARM, "\u7194\u5ca9\u62a4\u8eab\u7b26", "Provides 7 seconds of immunity to lava", "\u5bf9\u7194\u5ca9\u514d\u75ab7\u79d2", "It has a Chance to be dropped from Blaze.", "\u5b83\u6709\u51e0\u7387\u4ece\u70c8\u7130\u4eba\u6389\u843d");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.LAVA_WADERS, "\u7194\u5ca9\u9774", new String[]{"Allows flight, super fast running, and extra mobility on ice", "Grants immunity to fire blocks and 7 seconds of immunity to lava"}, new String[]{"\u63d0\u4f9b\u5728\u6c34\u3001\u8702\u871c\u3001\u7194\u5ca9\u4e0a\u884c\u8d70\u7684\u80fd\u529b", "\u5bf9\u706b\u5757\u514d\u75ab\u3001\u5bf9\u7194\u5ca9\u514d\u75ab7\u79d2"});
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.LIFE_FORM_ANALYZER, "\u751f\u547d\u4f53\u5206\u6790\u673a", "Displays the name of rare creatures around you", "\u663e\u793a\u60a8\u5468\u56f4\u7a00\u6709\u751f\u7269\u7684\u540d\u79f0", "The Lifeform Analyzer has a Chance to be dropped from Glow Squid.", "\u5b83\u6709\u51e0\u7387\u4ece\u53d1\u5149\u9c7f\u9c7c\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.LIGHTNING_BOOTS, "\u95ea\u7535\u9774", "Allows flight, super fast running", "\u53ef\u98de\u884c\u3001\u53ef\u98de\u901f\u5954\u8dd1");
        this.tooltipsAndJeiInfo((Supplier<? extends Item>)TCItems.LUCKY_HORSESHOE, "\u5e78\u8fd0\u9a6c\u638c", new String[]{"'Said to bring good fortune and keep evil spirits at bay'", "Negates fall damage"}, new String[]{"\u201c\u636e\u8bf4\u80fd\u5e26\u6765\u597d\u8fd0\u3001\u9a71\u9664\u90aa\u7075\u201d", "\u6d88\u9664\u6389\u843d\u4f24\u5bb3"}, "It can be discovered in chests found within Desert Pyramids, End City, Jungle Pyramids, or Ancient Cities.", "\u5b83\u53ef\u4ee5\u5728\u6c99\u6f20\u795e\u6bbf\uff0c\u672b\u5730\u57ce\uff0c\u4e1b\u6797\u9057\u8ff9\u6216\u53e4\u4ee3\u57ce\u5e02\u7684\u7bb1\u5b50\u4e2d\u627e\u5230\u3002");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.MAGIC_MIRROR, "\u9b54\u955c", "Gaze in the mirror to return home", "\u76ef\u7740\u955c\u5b50\u4fbf\u53ef\u56de\u5bb6");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.MAGIC_QUIVER, "\u9b54\u6cd5\u7bad\u888b", "20% chance to not consume arrows", "20%\u51e0\u7387\u4e0d\u6d88\u8017\u7bad", "This item has a Chance to be dropped from Skeleton.", "\u8fd9\u4ef6\u7269\u54c1\u6709\u51e0\u7387\u4ece\u9ab7\u9ac5\u8eab\u4e0a\u6389\u843d");
        this.tooltipsAndJeiInfo((Supplier<? extends Item>)TCItems.MAGILUMINESCENCE, "\u9b54\u5149\u62a4\u7b26", new String[]{"Increases movement speed and acceleration", "'A brief light in my dark life.'"}, new String[]{"\u63d0\u9ad8\u79fb\u52a8\u901f\u5ea6\u548c\u52a0\u901f\u5ea6", "\u201c\u6211\u9ed1\u6697\u751f\u547d\u4e2d\u7684\u4e00\u9053\u77ed\u6682\u66d9\u5149\u201d"}, "It can be found in End City Chests.", "\u5b83\u53ef\u4ee5\u5728\u672b\u5730\u57ce\u7684\u5b9d\u7bb1\u4e2d\u627e\u5230\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.MAGMA_SKULL, "\u5ca9\u6d46\u9ab7\u9ac5\u5934", new String[]{"Provides 7 seconds of immunity to lava", "Grants immunity to fire blocks"}, new String[]{"\u5bf9\u7194\u5ca9\u514d\u75ab7\u79d2", "\u5bf9\u706b\u5757\u514d\u75ab"});
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.MAGMA_STONE, "\u5ca9\u6d46\u77f3", "Melee attacks inflict fire damage", "\u8fd1\u6218\u653b\u51fb\u9020\u6210\u706b\u7130\u4f24\u5bb3", "It has a Chance to be dropped from Blaze.", "\u5b83\u6709\u51e0\u7387\u4ece\u70c8\u7130\u4eba\u6389\u843d");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.MASTER_NINJA_GEAR, "\u5fcd\u8005\u5927\u5e08\u88c5\u5907", new String[]{"Allows the ability to climb walls, hold Crouch key to slide down", "Allows the ability to dash while double tap a direction", "Gives a chance to dodge attacks"}, new String[]{"\u53ef\u722c\u5899\uff0c\u6309\u4f4f\u6f5c\u884c\u952e\u53ef\u5feb\u901f\u4e0b\u6ed1", "\u53cc\u51fb\u4e00\u4e2a\u65b9\u5411\u53ef\u731b\u51b2", "\u6709\u51e0\u7387\u907f\u5f00\u653b\u51fb"});
        this.onlyTooltip((Supplier<? extends Item>)TCItems.MECHANICAL_GLOVE, "\u673a\u68b0\u624b\u5957", "Enables auto swing for melee weapons", "\u542f\u7528\u8fd1\u6218\u6b66\u5668\u81ea\u52a8\u6325\u52a8");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.METAL_DETECTOR, "\u91d1\u5c5e\u63a2\u6d4b\u5668", "Displays the most valuable ore around you", "\u663e\u793a\u4f60\u5468\u56f4\u6700\u8d35\u91cd\u7684\u77ff\u77f3", "The Metal Detector has a Chance to be dropped from Warden.", "\u5b83\u5fc5\u5b9a\u4ece\u76d1\u5b88\u8005\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.MOLTEN_CHARM, "\u7194\u706b\u62a4\u8eab\u7b26", new String[]{"Grants immunity to fire blocks", "Provides 7 seconds of immunity to lava"}, new String[]{"\u5bf9\u706b\u5757\u514d\u75ab", "\u5bf9\u7194\u5ca9\u514d\u75ab7\u79d2"});
        this.onlyTooltips((Supplier<? extends Item>)TCItems.MOLTEN_QUIVER, "\u7194\u706b\u7bad\u888b", new String[]{"20% chance to not consume arrows", "Lights wooden arrows ablaze", "'Quiver in fear!'"}, new String[]{"20%\u51e0\u7387\u4e0d\u6d88\u8017\u7bad", "\u70b9\u71c3\u6728\u7bad\uff0c\u706b\u5149\u718a\u718a", "\u201c\u5728\u6050\u60e7\u4e2d\u98a4\u6296\u5427\uff01\u201d"});
        this.onlyTooltips((Supplier<? extends Item>)TCItems.MOLTEN_SKULL_ROSE, "\u7194\u706b\u9ab7\u9ac5\u5934\u73ab\u7470", new String[]{"Grants immunity to fire blocks", "Provides 7 seconds of immunity to lava", "Reduces damage from touching lava"}, new String[]{"\u5bf9\u706b\u5757\u514d\u75ab", "\u5bf9\u7194\u5ca9\u514d\u75ab7\u79d2", "\u51cf\u5c11\u56e0\u89e6\u78b0\u7194\u5ca9\u800c\u9020\u6210\u7684\u4f24\u5bb3"});
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.MOON_STONE, "\u6708\u4eae\u77f3", "It has a Chance to be dropped from Phantom.", "\u5728\u591c\u665a\u65f6\u7565\u5fae\u589e\u5f3a\u5c5e\u6027\u503c", "It has a Chance to be dropped from Phantom.", "\u5b83\u6709\u51e0\u7387\u4ece\u5e7b\u7ffc\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.NUTRIENT_SOLUTION, "\u8425\u517b\u6db2", "Immunity to Weakness and Hunger", "\u5bf9\u865a\u5f31\u548c\u9965\u997f\u514d\u75ab");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.OBSIDIAN_HORSESHOE, "\u9ed1\u66dc\u77f3\u9a6c\u638c", new String[]{"Negates fall damage", "Grants immunity to fire blocks"}, new String[]{"\u6d88\u9664\u6389\u843d\u4f24\u5bb3", "\u5bf9\u706b\u5757\u514d\u75ab"});
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.OBSIDIAN_ROSE, "\u9ed1\u66dc\u77f3\u73ab\u7470", "Reduces damage from touching lava", "\u51cf\u5c11\u56e0\u89e6\u78b0\u7194\u5ca9\u800c\u9020\u6210\u7684\u4f24\u5bb3", "It can be discovered in chests found within Bastion Remnant.", "\u5b83\u53ef\u4ee5\u5728\u5821\u5792\u9057\u8ff9\u4e2d\u53d1\u73b0\u7684\u7bb1\u5b50\u4e2d\u627e\u5230");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.OBSIDIAN_SHIELD, "\u9ed1\u66dc\u77f3\u62a4\u76fe", "Grants immunity to fire blocks", "\u5bf9\u706b\u5757\u514d\u75ab");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.OBSIDIAN_SKULL, "\u9ed1\u66dc\u77f3\u9ab7\u9ac5\u5934", "Grants immunity to fire blocks", "\u5bf9\u706b\u5757\u514d\u75ab");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.OBSIDIAN_SKULL_ROSE, "\u9ed1\u66dc\u77f3\u9ab7\u9ac5\u5934\u73ab\u7470", new String[]{"Grants immunity to fire blocks", "Reduces damage from touching lava"}, new String[]{"\u5bf9\u706b\u5757\u514d\u75ab", "\u51cf\u5c11\u56e0\u89e6\u78b0\u7194\u5ca9\u800c\u9020\u6210\u7684\u4f24\u5bb3"});
        this.onlyTooltips((Supplier<? extends Item>)TCItems.OBSIDIAN_WATER_WALKING_BOOTS, "\u9ed1\u66dc\u77f3\u6c34\u4e0a\u6f02\u9774", new String[]{"Provides the ability to walk on water & honey", "Grants immunity to fire blocks"}, new String[]{"\u63d0\u4f9b\u5728\u6c34\u548c\u8702\u871c\u4e0a\u884c\u8d70\u7684\u80fd\u529b", "\u5bf9\u706b\u5757\u514d\u75ab"});
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.PALADINS_SHIELD, "\u5723\u9a91\u58eb\u62a4\u76fe", "Absorbs 25% of damage done to players on your team when above 25% life", "\u5f53\u751f\u547d\u503c\u8d85\u8fc725%\u65f6\uff0c\u5438\u6536\u5bf9\u56e2\u961f\u4e2d\u73a9\u5bb6\u9020\u6210\u768425%\u4f24\u5bb3", "It is dropped by the Ender Dragon.", "\u5b83\u5fc5\u5b9a\u4ece\u672b\u5f71\u9f99\u8eab\u4e0a\u6389\u843d\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.PANIC_NECKLACE, "\u6050\u614c\u9879\u94fe", "Increases movement speed after taking damage", "\u53d7\u5230\u4f24\u5bb3\u540e\u589e\u52a0\u79fb\u52a8\u901f\u5ea6", "It can be found in Chests in the Dungeon.", "\u5b83\u53ef\u4ee5\u5728\u5730\u7262\u4e2d\u7684\u5b9d\u7bb1\u4e2d\u627e\u5230\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.PDA, "\u4e2a\u4eba\u6570\u5b57\u52a9\u624b", ALL_INFO_EN, ALL_INFO_ZH);
        this.onlyTooltips((Supplier<? extends Item>)TCItems.PINK_HORSESHOE_BALLOON, "\u7c89\u9a6c\u638c\u6c14\u7403", new String[]{"Allows the holder to double jump", "Increases jump height", "Negates fall damage"}, new String[]{"\u53ef\u8ba9\u6301\u6709\u8005\u4e8c\u6bb5\u8df3", "\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6", "\u6d88\u9664\u6389\u843d\u4f24\u5bb3"});
        this.onlyTooltips((Supplier<? extends Item>)TCItems.YELLOW_HORSESHOE_BALLOON, "\u9ec4\u9a6c\u638c\u6c14\u7403", new String[]{"Allows the holder to double jump", "Increases jump height", "Negates fall damage"}, new String[]{"\u53ef\u8ba9\u6301\u6709\u8005\u4e8c\u6bb5\u8df3", "\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6", "\u6d88\u9664\u6389\u843d\u4f24\u5bb3"});
        this.onlyTooltip((Supplier<? extends Item>)TCItems.PLATINUM_WATCH, "\u94c2\u91d1\u8868", "Tell the time", "\u62a5\u65f6");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.PORTABLE_CEMENT_MIXER, "\u4fbf\u643a\u5f0f\u6c34\u6ce5\u6405\u62cc\u673a", "Decreased 'Right Click Delay' by 1", "\u53f3\u952e\u70b9\u51fb\u5ef6\u8fdf\u964d\u4f4e1", "This item can be located in the chests found within Toolsmith Villagers' houses.", "\u8fd9\u4ef6\u7269\u54c1\u53ef\u4ee5\u5728\u5de5\u5177\u5320\u6751\u6c11\u5bb6\u4e2d\u7684\u7bb1\u5b50\u4e2d\u627e\u5230\u3002");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.POWER_GLOVE, "\u5f3a\u529b\u624b\u5957", "Enables auto swing for melee weapons", "\u542f\u7528\u8fd1\u6218\u6b66\u5668\u81ea\u52a8\u6325\u52a8");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.PUTRID_SCENT, "\u8150\u9999\u56ca", "Enemies are less likely to target you", "\u591a\u4eba\u6a21\u5f0f\u4e0b\uff0c\u654c\u602a\u4e0d\u592a\u53ef\u80fd\u4ee5\u4f60\u4e3a\u76ee\u6807", "It can be found in Chests in the Dungeon.", "\u5b83\u53ef\u4ee5\u5728\u5730\u7262\u4e2d\u7684\u5b9d\u7bb1\u4e2d\u627e\u5230\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.RADAR, "\u96f7\u8fbe", "Detects enemies around you", "\u63a2\u6d4b\u4f60\u5468\u56f4\u7684\u654c\u4eba", "The Radar has a Chance to be dropped from Bats.", "\u5b83\u6709\u51e0\u7387\u4ece\u8759\u8760\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyJeiInfo((Supplier<? extends Item>)TCItems.RANGER_EMBLEM, "\u6e38\u4fa0\u5fbd\u7ae0", "It has a Chance to be dropped from Skeleton.", "\u5b83\u6709\u51e0\u7387\u4ece\u9ab7\u9ac5\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.RECON_SCOPE, "\u4fa6\u5bdf\u955c", new String[]{"Increases view range for ranged weapons", "Hold ranged weapon and crouch to zoom out", "Enemies are less likely to target you", "'Enemy spotted'"}, new String[]{"\u6269\u5927\u8fdc\u7a0b\u6b66\u5668\u7684\u89c6\u91ce\u8303\u56f4", "\u624b\u6301\u8fdc\u7a0b\u6b66\u5668\u5e76\u6f5c\u884c\u53ef\u62c9\u8fdc\u89c6\u91ce", "\u591a\u4eba\u6a21\u5f0f\u4e0b\uff0c\u654c\u602a\u4e0d\u592a\u53ef\u80fd\u4ee5\u4f60\u4e3a\u76ee\u6807", "\u201c\u53d1\u73b0\u654c\u4eba\u201d"});
        this.onlyTooltips((Supplier<? extends Item>)TCItems.REK_3000, "R.E.K.3000", new String[]{"Detects enemies around you", "Displays the name of rare creatures around you", "Displays how many monsters have been killed"}, new String[]{"\u63a2\u6d4b\u4f60\u5468\u56f4\u7684\u654c\u4eba", "\u663e\u793a\u60a8\u5468\u56f4\u7a00\u6709\u751f\u7269\u7684\u540d\u79f0", "\u663e\u793a\u602a\u7269\u51fb\u6740\u6570\u91cf"});
        this.onlyTooltips((Supplier<? extends Item>)TCItems.SNIPER_SCOPE, "\u72d9\u51fb\u955c", new String[]{"Increases view range for ranged weapons", "Hold ranged weapon and crouch to zoom out"}, new String[]{"\u6269\u5927\u8fdc\u7a0b\u6b66\u5668\u7684\u89c6\u91ce\u8303\u56f4", "\u624b\u6301\u8fdc\u7a0b\u6b66\u5668\u5e76\u6f5c\u884c\u53ef\u62c9\u8fdc\u89c6\u91ce"});
        this.tooltipsAndJeiInfo((Supplier<? extends Item>)TCItems.RIFLE_SCOPE, "\u6b65\u67aa\u7784\u51c6\u955c", new String[]{"Increases view range for ranged weapons", "Hold ranged weapon and crouch to zoom out"}, new String[]{"\u6269\u5927\u8fdc\u7a0b\u6b66\u5668\u7684\u89c6\u91ce\u8303\u56f4", "\u624b\u6301\u8fdc\u7a0b\u6b66\u5668\u5e76\u6f5c\u884c\u53ef\u62c9\u8fdc\u89c6\u91ce"}, "It has a Chance to be dropped from Enderman.", "\u5b83\u6709\u51e0\u7387\u4ece\u672b\u5f71\u4eba\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.ROCKET_BOOTS, "\u706b\u7bad\u9774", "Allows flight", "\u53ef\u98de\u884c");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.ROYAL_GEL, "\u7687\u5bb6\u51dd\u80f6", "Slimes become friendly", "\u53f2\u83b1\u59c6\u5c06\u53d8\u6210\u53cb\u597d\u751f\u7269", "It has a Chance to be dropped from Slime.", "\u6709\u51e0\u7387\u4ece\u53f2\u83b1\u59c6\u8eab\u4e0a\u6389\u843d\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.SAILFISH_BOOTS, "\u65d7\u9c7c\u9774", "The wearer can run super fast", "\u7a7f\u6234\u8005\u53ef\u98de\u901f\u5954\u8dd1", "It can be found in Shipwreck Chests.", "\u5b83\u53ef\u4ee5\u5728\u6c89\u8239\u5b9d\u7bb1\u4e2d\u627e\u5230\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.SANDSTORM_IN_A_BALLOON, "\u6c99\u66b4\u6c14\u7403", new String[]{"Allows the holder to double jump", "Increases jump height"}, new String[]{"\u53ef\u8ba9\u6301\u6709\u8005\u4e8c\u6bb5\u8df3", "\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6"});
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.SANDSTORM_IN_A_BOTTLE, "\u6c99\u66b4\u74f6", "Allows the holder to double jump", "\u53ef\u8ba9\u6301\u6709\u8005\u4e8c\u6bb5\u8df3", "It can be found in Chests in the Desert Pyramid.", "\u5b83\u53ef\u4ee5\u5728\u6c99\u6f20\u795e\u6bbf\u7684\u5b9d\u7bb1\u4e2d\u627e\u5230\u3002");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.SEARCHLIGHT, "\u63a2\u7167\u706f", "Immunity to Blindness and Darkness", "\u5bf9\u5931\u660e\u548c\u9ed1\u6697\u514d\u75ab");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.SEXTANT, "\u516d\u5206\u4eea", "Displays the phase of the moon", "\u663e\u793a\u6708\u76f8", "This item can be located in the chests found within Fisherman Villagers' houses.", "\u8fd9\u4ef6\u7269\u54c1\u53ef\u4ee5\u5728\u6e14\u592b\u6751\u6c11\u5bb6\u4e2d\u7684\u7bb1\u5b50\u4e2d\u627e\u5230\u3002");
        this.onlyJeiInfo((Supplier<? extends Item>)TCItems.SHACKLE, "\u811a\u9563", "It can be found in Chests in the Dungeon.", "\u5b83\u53ef\u4ee5\u5728\u5730\u7262\u4e2d\u7684\u5b9d\u7bb1\u4e2d\u627e\u5230\u3002");
        this.onlyJeiInfo((Supplier<? extends Item>)TCItems.SHARK_TOOTH_NECKLACE, "\u9ca8\u7259\u9879\u94fe", "It has a chance to drop from Drowned.", "\u5b83\u6709\u51e0\u7387\u4ece\u6eba\u5c38\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.SHARKRON_BALLOON, "\u9ca8\u9c7c\u9f99\u6c14\u7403", new String[]{"Allows the holder to double jump", "Increases jump height"}, new String[]{"\u53ef\u8ba9\u6301\u6709\u8005\u4e8c\u6bb5\u8df3", "\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6"});
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.SHIELD_OF_CTHULHU, "\u514b\u82cf\u9c81\u62a4\u76fe", "Allows the player to dash into the enemy, tap [%s] once to dash", "\u5141\u8bb8\u51b2\u523a\uff0c\u6309\u4e00\u6b21[%s]\u4ee5\u51b2\u523a", "It has a Chance to be dropped from Ravager.", "\u5b83\u6709\u51e0\u7387\u4ece\u52ab\u63a0\u517d\u8eab\u4e0a\u6389\u843d\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.SHINY_RED_BALLOON, "\u95ea\u4eae\u7ea2\u6c14\u7403", "Allows the holder to double jump", "\u589e\u52a0\u8df3\u8dc3\u9ad8\u5ea6", "When the player has the Hero of the Village effect, the librarian has a chance to give the player this item.It can be found in chests in plains villages.", "\u5b83\u53ef\u4ee5\u5728\u5e73\u539f\u6751\u5e84\u4e2d\u7684\u5b9d\u7bb1\u4e2d\u627e\u5230\u3002\u5f53\u73a9\u5bb6\u62e5\u6709\u6751\u5e84\u82f1\u96c4\u6548\u679c\u65f6\uff0c\u56fe\u4e66\u7ba1\u7406\u5458\u6709\u51e0\u7387\u5c06\u6b64\u7269\u54c1\u4ea4\u7ed9\u73a9\u5bb6\u3002");
        this.tooltipsAndJeiInfo((Supplier<? extends Item>)TCItems.SHOE_SPIKES, "\u978b\u9489", new String[]{"Allows the ability to slide down walls, hold Crouch key to slide down quickly", "Improved ability if combined with Climbing Claws"}, new String[]{"\u53ef\u6cbf\u5899\u6ed1\u4e0b\uff0c\u6309\u4f4f\u6f5c\u884c\u952e\u53ef\u66f4\u5feb\u5730\u4e0b\u6ed1", "\u7ed3\u5408\u6500\u722c\u722a\u4f7f\u7528\u65f6\u80fd\u529b\u8fd8\u4f1a\u6709\u6240\u63d0\u5347"}, "It has a Chance to be dropped from Cave Spider.", "\u5b83\u6709\u51e0\u7387\u4ece\u6d1e\u7a74\u8718\u86db\u8eab\u4e0a\u6389\u843d\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.SHOT_PUT, "\u94c5\u7403", "Immunity to Levitation", "\u5bf9\u6f02\u6d6e\u514d\u75ab", "It can be found in Chests in the Stronghold.", "\u5b83\u53ef\u4ee5\u5728\u8981\u585e\u7684\u5b9d\u7bb1\u4e2d\u627e\u5230\u3002");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.SILVER_WATCH, "\u94f6\u8868", "Tell the time", "\u62a5\u65f6");
        this.onlyJeiInfo((Supplier<? extends Item>)TCItems.SORCERER_EMBLEM, "\u5deb\u5e08\u5fbd\u7ae0", "It has a Chance to be dropped from Evoker.", "\u5b83\u6709\u51e0\u7387\u4ece\u5524\u9b54\u8005\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.SPECTRE_BOOTS, "\u5e7d\u7075\u9774", "Allows flight, super fast running", "\u53ef\u98de\u884c\u3001\u53ef\u98de\u901f\u5954\u8dd1");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.STALKERS_QUIVER, "\u6f5c\u884c\u8005\u7bad\u888b", new String[]{"20% chance to not consume arrows", "Enemies are less likely to target you"}, new String[]{"20%\u51e0\u7387\u4e0d\u6d88\u8017\u7bad", "\u591a\u4eba\u6a21\u5f0f\u4e0b\uff0c\u654c\u602a\u4e0d\u592a\u53ef\u80fd\u4ee5\u4f60\u4e3a\u76ee\u6807"});
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.STAR_CLOAK, "\u661f\u661f\u6597\u7bf7", "Causes stars to fall after taking damage", "\u53d7\u5230\u4f24\u5bb3\u540e\u4f1a\u4f7f\u661f\u661f\u5760\u843d", "It can be discovered in chests found within Woodland Mansion.", "\u5b83\u53ef\u4ee5\u5728\u6797\u5730\u5e9c\u90b8\u5185\u7684\u7bb1\u5b50\u4e2d\u627e\u5230\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.STAR_VEIL, "\u661f\u661f\u9762\u7eb1", new String[]{"Increases length of invincibility after taking damage", "Causes stars to fall after taking damage"}, new String[]{"\u589e\u52a0\u53d7\u5230\u4f24\u5bb3\u540e\u7684\u65e0\u654c\u65f6\u95f4", "\u53d7\u5230\u4f24\u5bb3\u540e\u4f1a\u4f7f\u661f\u661f\u5760\u843d"});
        this.tooltipsAndJeiInfo((Supplier<? extends Item>)TCItems.MAGILUMINESCENCE, "\u9b54\u5149\u62a4\u7b26", new String[]{"Increases movement speed and acceleration", "'A brief light in my dark life.'"}, new String[]{"\u63d0\u9ad8\u79fb\u52a8\u901f\u5ea6\u548c\u52a0\u901f\u5ea6", "\u2018\u6211\u9ed1\u6697\u751f\u547d\u4e2d\u7684\u4e00\u9053\u77ed\u6682\u66d9\u5149\u2019"}, "It can be found in End City Chests.", "\u5b83\u53ef\u4ee5\u5728\u672b\u5730\u57ce\u7684\u5b9d\u7bb1\u4e2d\u627e\u5230\u3002");
        this.tooltipsAndJeiInfo((Supplier<? extends Item>)TCItems.STEP_STOOL, "\u68af\u51f3", new String[]{"Press \u2191 key to stand higher, and press Crouch key to down", "Extra Step: %s"}, new String[]{"\u6309\u2191\u952e\u7ad9\u5f97\u66f4\u9ad8\uff0c\u6309\u6f5c\u884c\u952e\u4e0b\u6765", "\u989d\u5916\u9ad8\u5ea6\uff1a%s"}, "You can use Step Stool to upgrade its Extra Step from Smithing Table.", "\u4f60\u53ef\u4ee5\u5728\u953b\u9020\u53f0\u4f7f\u7528\u68af\u51f3\u5347\u7ea7\u5b83\u7684\u989d\u5916\u9ad8\u5ea6\u3002");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.STINGER_NECKLACE, "\u6bd2\u523a\u9879\u94fe", "Releases bees and douses the user in honey when damaged.", "\u53d7\u5230\u4f24\u5bb3\u540e\u91ca\u653e\u871c\u8702\u5e76\u5c06\u4f7f\u7528\u8005\u6d78\u5165\u8702\u871c\u4e2d\u3002");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.STOPWATCH, "\u79d2\u8868", "Displays how fast the player is moving", "\u663e\u793a\u73a9\u5bb6\u7684\u79fb\u52a8\u901f\u5ea6");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.SUN_STONE, "\u592a\u9633\u77f3", "During daytime, grants minor increase.", "\u5728\u767d\u5929\u65f6\u7565\u5fae\u589e\u5f3a\u5c5e\u6027\u503c", "It has a Chance to be dropped from Blaze.", "\u5b83\u6709\u51e0\u7387\u7531\u70c8\u7130\u4eba\u6389\u843d\u3002");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.SWEETHEART_NECKLACE, "\u751c\u5fc3\u9879\u94fe", "When damaged, the bee is released and the user is immersed in honey and increases movement speed.", "\u53d7\u5230\u4f24\u5bb3\u540e\u91ca\u653e\u871c\u8702\u5e76\u5c06\u4f7f\u7528\u8005\u6d78\u5165\u8702\u871c\u4e2d\u3001\u5e76\u63d0\u9ad8\u79fb\u52a8\u901f\u5ea6\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.TABI, "\u5206\u8dbe\u539a\u5e95\u889c", "Allows the ability to dash while double tap a direction", "\u53cc\u51fb\u4e00\u4e2a\u65b9\u5411\u53ef\u731b\u51b2", "It can be found in Chests in the Nether Bridge.", "\u5b83\u53ef\u4ee5\u5728\u4e0b\u5c4a\u8981\u585e\u7684\u5b9d\u7bb1\u4e2d\u627e\u5230\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.TALLY_COUNTER, "\u6740\u602a\u8ba1\u6570\u5668", "Displays how many monsters have been killed", "\u663e\u793a\u602a\u7269\u51fb\u6740\u6570\u91cf", "The Tally Counter a Chance to be dropped from Creeper.", "\u5b83\u6709\u51e0\u7387\u4ece\u82e6\u529b\u6015\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.TERRASPARK_BOOTS, "\u6cf0\u62c9\u95ea\u8000\u9774", new String[]{"Allows flight, super fast running, and extra mobility on ice", "Provides the ability t walk on water, honey & lava", "Grants immunity to fire blocks and 7 seconds of immunity to lava", "Reduces damage from touching lava"}, new String[]{"\u53ef\u98de\u884c\u3001\u98de\u901f\u5954\u8dd1\u3001\u5e76\u63d0\u4f9b\u989d\u5916\u51b0\u9762\u884c\u52a8\u529b", "\u63d0\u4f9b\u5728\u6c34\u3001\u8702\u871c\u3001\u7194\u5ca9\u4e0a\u884c\u8d70\u7684\u80fd\u529b", "\u5bf9\u706b\u5757\u514d\u75ab\u5e76\u57287\u79d2\u5185\u5bf9\u7194\u5ca9\u514d\u75ab", "\u51cf\u5c11\u56e0\u89e6\u78b0\u7194\u5ca9\u800c\u9020\u6210\u7684\u4f24\u5bb3"});
        this.onlyTooltip((Supplier<? extends Item>)TCItems.THE_PLAN, "\u8ba1\u5212\u4e66", "Immunity to Slowness and Nausea", "\u5bf9\u7f13\u6162\u548c\u53cd\u80c3\u514d\u75ab");
        this.onlyJeiInfo((Supplier<? extends Item>)TCItems.TITAN_GLOVE, "\u6cf0\u5766\u624b\u5957", "It can be found in Chests in the Mineshaft.", "\u5b83\u53ef\u4ee5\u5728\u5e9f\u5f03\u77ff\u4e95\u7684\u5b9d\u7bb1\u4e2d\u627e\u5230\u3002");
        this.onlyJeiInfo((Supplier<? extends Item>)TCItems.TOOLBELT, "\u5de5\u5177\u8170\u5e26", "It can be located in the chests found within Toolsmith Villagers' houses.", "\u5b83\u53ef\u4ee5\u5728\u5de5\u5177\u5320\u6751\u6c11\u5bb6\u4e2d\u7684\u7bb1\u5b50\u4e2d\u627e\u5230\u3002");
        this.onlyJeiInfo((Supplier<? extends Item>)TCItems.TOOLBOX, "\u5de5\u5177\u7bb1", "It can be located in the chests found within Toolsmith Villagers' houses.", "\u5b83\u53ef\u4ee5\u5728\u5de5\u5177\u5320\u6751\u6c11\u5bb6\u4e2d\u7684\u7bb1\u5b50\u4e2d\u627e\u5230");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.TREASURE_MAGNET, "\u5b9d\u85cf\u78c1\u77f3", "Expanded item pickup", "\u6269\u5927\u7269\u54c1\u62fe\u53d6\u8303\u56f4", "It can be discovered in chests found within Desert Pyramids, End City, Jungle Pyramids, or Ancient Cities.", "\u5b83\u53ef\u4ee5\u5728\u6c99\u6f20\u795e\u6bbf\u3001\u672b\u5730\u57ce\u3001\u4e1b\u6797\u795e\u5e99\u6216\u53e4\u4ee3\u57ce\u5185\u7684\u5b9d\u7bb1\u4e2d\u627e\u5230\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.TRIFOLD_MAP, "\u4e09\u6298\u5730\u56fe", "Immunity to Nausea", "\u5bf9\u53cd\u80c3\u514d\u75ab", "It can be found in Chests in the Stronghold Library.", "\u5b83\u53ef\u4ee5\u5728\u8981\u585e\u56fe\u4e66\u9986\u7684\u5b9d\u7bb1\u4e2d\u627e\u5230\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.TSUNAMI_IN_A_BOTTLE, "\u6d77\u5578\u74f6", "Allows the holder to double jump", "\u53ef\u8ba9\u6301\u6709\u8005\u4e8c\u6bb5\u8df3", "It can be found in Shipwreck Chests.", "\u5b83\u53ef\u4ee5\u5728\u6c89\u8239\u5b9d\u7bb1\u4e2d\u627e\u5230\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.VITAMINS, "\u7ef4\u751f\u7d20", "Immunity to Weakness", "\u5bf9\u865a\u5f31\u514d\u75ab", "It has a Chance to be dropped from Witch.", "\u5b83\u6709\u51e0\u7387\u4ece\u5973\u5deb\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyJeiInfo((Supplier<? extends Item>)TCItems.WARRIOR_EMBLEM, "\u6218\u58eb\u5fbd\u7ae0", "It has a Chance to be dropped from Vindicator.", "\u5b83\u6709\u51e0\u7387\u4ece\u536b\u9053\u58eb\u8eab\u4e0a\u6389\u843d\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.WATER_WALKING_BOOTS, "\u6c34\u4e0a\u6f02\u9774", "Provides the ability to walk on water & honey", "\u63d0\u4f9b\u5728\u6c34\u548c\u8702\u871c\u4e0a\u884c\u8d70\u7684\u80fd\u529b", "It can be found in Ocean Ruins Chests.", "\u5b83\u53ef\u4ee5\u5728\u6d77\u6d0b\u5e9f\u589f\u5b9d\u7bb1\u4e2d\u627e\u5230\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.WEATHER_RADIO, "\u5929\u6c14\u6536\u97f3\u673a", "Displays the weather", "\u663e\u793a\u5929\u6c14", "This item can be located in the chests found within Fisherman Villagers' houses.", "\u8fd9\u4ef6\u7269\u54c1\u53ef\u4ee5\u5728\u6e14\u592b\u6751\u6c11\u5bb6\u4e2d\u7684\u7bb1\u5b50\u4e2d\u627e\u5230\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.WORM_SCARF, "\u8815\u866b\u56f4\u5dfe", "Reduces damage taken by 17%", "\u6240\u53d7\u4f24\u5bb3\u51cf\u5c1117%", "When a player has a tamed cat, the cat may give the player this item when they wake up.", "\u5f53\u73a9\u5bb6\u6709\u4e00\u53ea\u88ab\u9a6f\u670d\u7684\u732b\u65f6\uff0c\u732b\u53ef\u80fd\u4f1a\u5728\u73a9\u5bb6\u9192\u6765\u65f6\u7ed9\u73a9\u5bb6\u8fd9\u4e2a\u7269\u54c1\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.BONE_GLOVE, "\u9aa8\u5934\u624b\u5957", "Shoots crossbones at enemies while you are attacking", "\u5728\u4f60\u653b\u51fb\u65f6\u5411\u654c\u4eba\u5c04\u51fa\u4ea4\u53c9\u9aa8", "It has a Chance to be dropped from Skeleton Horse.", "\u5b83\u6709\u51e0\u7387\u4ece\u9ab7\u9ac5\u9a6c\u8eab\u4e0a\u6389\u843d\u3002");
        this.tooltipAndJeiInfos((Supplier<? extends Item>)TCItems.DIVING_HELMET, "\u6f5c\u6c34\u5934\u76d4", "Greatly extends underwater breathing", "\u5927\u5927\u5ef6\u957f\u6c34\u4e0b\u547c\u5438\u65f6\u95f4", new String[]{"When equipped, it causes the breath meter to deplete much slower and slows the rate at which drowning damage is taken.", "When the drowned wears it, you can take it away."}, new String[]{"\u5f53\u88c5\u5907\u65f6\uff0c\u5b83\u4f1a\u8ba9\u547c\u5438\u8ba1\u4ee5\u6162\u5f97\u591a\u7684\u901f\u5ea6\u6d88\u8017\uff0c\u5e76\u4e14\u8fd8\u80fd\u51cf\u6162\u6eba\u6c34\u4f24\u5bb3\u7684\u901f\u5ea6\u3002", "\u5f53\u6eba\u5c38\u7a7f\u6234\u5b83\u65f6\uff0c\u4f60\u53ef\u4ee5\u593a\u8d70\u5b83\u3002"});
        this.onlyTooltip((Supplier<? extends Item>)TCItems.DIVING_GEAR, "\u6f5c\u6c34\u88c5\u5907", "Greatly extends underwater breathing", "\u5927\u5927\u5ef6\u957f\u6c34\u4e0b\u547c\u5438\u65f6\u95f4");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.JELLYFISH_NECKLACE, "\u6c34\u6bcd\u9879\u94fe", "Generates a very subtle glow which becomes more vibrant underwater", "\u53d1\u51fa\u975e\u5e38\u5fae\u5f31\u7684\u5149\u8292\uff0c\u8fd9\u79cd\u5149\u8292\u5728\u6c34\u4e0b\u4f1a\u53d8\u5f97\u66f4\u9192\u76ee", "It has a Chance to be dropped from Glow Squid.", "\u5b83\u6709\u51e0\u7387\u4ece\u53d1\u5149\u9c7f\u9c7c\u8eab\u4e0a\u6389\u843d\u3002");
        this.onlyTooltips((Supplier<? extends Item>)TCItems.JELLYFISH_DIVING_GEAR, "\u6c34\u6bcd\u6f5c\u6c34\u88c5\u5907", new String[]{"Greatly extends underwater breathing", "Generates a very subtle glow which becomes more vibrant underwater"}, new String[]{"\u5927\u5927\u5ef6\u957f\u6c34\u4e0b\u547c\u5438\u65f6\u95f4", "\u53d1\u51fa\u975e\u5e38\u5fae\u5f31\u7684\u5149\u8292\uff0c\u8fd9\u79cd\u5149\u8292\u5728\u6c34\u4e0b\u4f1a\u53d8\u5f97\u66f4\u9192\u76ee"});
        this.tooltipsAndJeiInfo((Supplier<? extends Item>)TCItems.ARCTIC_DIVING_GEAR, "\u5317\u6781\u6f5c\u6c34\u88c5\u5907", new String[]{"Greatly extends underwater breathing", "Provides extra mobility on ice", "Generates a very subtle glow which becomes more vibrant underwater"}, new String[]{"\u5927\u5927\u5ef6\u957f\u6c34\u4e0b\u547c\u5438\u65f6\u95f4", "\u63d0\u4f9b\u989d\u5916\u51b0\u9762\u884c\u52a8\u529b", "\u53d1\u51fa\u975e\u5e38\u5fae\u5f31\u7684\u5149\u8292\uff0c\u8fd9\u79cd\u5149\u8292\u5728\u6c34\u4e0b\u4f1a\u53d8\u5f97\u66f4\u9192\u76ee"}, "Provides immunity to powder snow", "\u5bf9\u7ec6\u96ea\u514d\u75ab");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.INNER_TUBE, "\u6d6e\u6e38\u5708", "Grants the ability to float in water", "\u53ef\u8ba9\u4eba\u6d6e\u5728\u6c34\u9762", "It has a Chance to be dropped from Slime.", "\u5b83\u6709\u51e0\u7387\u4ece\u53f2\u83b1\u59c6\u8eab\u4e0a\u6389\u843d\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.FLYING_CARPET, "\u98de\u6bef", "Allows the owner to float for a few seconds", "\u53ef\u8ba9\u6301\u6709\u8005\u6f02\u6d6e\u51e0\u79d2\u949f", "It can be discovered in chests found within Desert Pyramids.", "\u5b83\u53ef\u4ee5\u5728\u6c99\u6f20\u795e\u6bbf\u5185\u7684\u7bb1\u5b50\u4e2d\u627e\u5230");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.SHINY_STONE, "\u95ea\u4eae\u77f3", "Greatly increases life regen when not moving", "\u4e0d\u79fb\u52a8\u65f6\uff0c\u5927\u5927\u63d0\u9ad8\u751f\u547d\u518d\u751f\u901f\u5ea6", "When an Iron Golem is killed by an explosion", "\u94c1\u5080\u5121\u88ab\u7206\u70b8\u51fb\u6740\u65f6");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.SOARING_INSIGNIA, "\u7ff1\u7fd4\u5fbd\u7ae0", "Grants infinite wing and rocket boot flight", "\u7ed9\u4e88\u65e0\u9650\u7fc5\u8180\u98de\u884c\u65f6\u95f4\u548c\u65e0\u9650\u706b\u7bad\u9774\u98de\u884c\u65f6\u95f4", "Kill Wither with elytra", "\u4f7f\u7528\u9798\u7fc5\u7684\u60c5\u51b5\u4e0b\u51fb\u6740\u51cb\u96f6");
        this.tooltipsAndJeiInfo((Supplier<? extends Item>)TCItems.CELESTIAL_STARBOARD, "\u5929\u754c\u661f\u76d8", new String[]{"Allows flight and slow fall", "Hold Crouch and Jump key to horizontal flight", "'The more you know'"}, new String[]{"\u53ef\u98de\u884c\u548c\u7f13\u6162\u5760\u843d", "\u6309\u4f4f\u6f5c\u884c\u4e0e\u8df3\u8dc3\u952e\u4ee5\u6c34\u5e73\u98de\u884c", "\u201c\u4f60\u61c2\u5f97\u8d8a\u591a\u201d"}, "Kill the Ender Dragon with elytra", "\u4f7f\u7528\u9798\u7fc5\u7684\u60c5\u51b5\u4e0b\u51fb\u6740\u672b\u5f71\u9f99");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.NEPTUNES_SHELL, "\u6d77\u795e\u8d1d\u58f3", "Transforms the holder into merfolk when entering water", "\u5165\u6c34\u65f6\u5c06\u6301\u6709\u8005\u53d8\u6210\u4eba\u9c7c", "It has a Chance to be dropped from Guardian.", "\u5b83\u6709\u51e0\u7387\u4ece\u5b88\u536b\u8005\u8eab\u4e0a\u6389\u843d\u3002");
        this.tooltipAndJeiInfo((Supplier<? extends Item>)TCItems.MOON_CHARM, "\u6708\u5149\u62a4\u8eab\u7b26", "Turns the holder into a werewolf at night", "\u5728\u665a\u4e0a\u5c06\u6301\u6709\u8005\u53d8\u6210\u72fc\u4eba", "When zombies are killed by wolves.", "\u50f5\u5c38\u88ab\u72fc\u51fb\u6740\u65f6");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.MOON_SHELL, "\u6708\u4eae\u8d1d\u58f3", "Turns the holder into a werewolf at night and a merfolk when entering water", "\u5728\u665a\u4e0a\u5c06\u6301\u6709\u8005\u53d8\u6210\u72fc\u4eba\uff0c\u5165\u6c34\u65f6\u5c06\u6301\u6709\u8005\u53d8\u6210\u4eba\u9c7c");
        this.onlyTooltip((Supplier<? extends Item>)TCItems.CELESTIAL_SHELL, "\u5929\u754c\u58f3", "Turns the holder into a werewolf at night and a merfolk when entering water", "\u5728\u665a\u4e0a\u5c06\u6301\u6709\u8005\u53d8\u6210\u72fc\u4eba\uff0c\u5165\u6c34\u65f6\u5c06\u6301\u6709\u8005\u53d8\u6210\u4eba\u9c7c");
        if (this.locale.equals("en_us")) {
            this.sidedAdd(((BaseCurioItem)((Object)TCItems.EXPLORERS_EQUIPMENT.get())).getDescriptionId(), "Explorer's Equipment", this.enData);
            this.sidedAdd(((BaseCurioItem)((Object)TCItems.PALADINS_SHIELD.get())).getDescriptionId(), "Paladin's Shield", this.enData);
            this.sidedAdd(((BaseCurioItem)((Object)TCItems.STALKERS_QUIVER.get())).getDescriptionId(), "Stalker's Quiver", this.enData);
            this.sidedAdd(((BaseCurioItem)((Object)TCItems.DPS_METER.get())).getDescriptionId(), "DPS Meter", this.enData);
            this.sidedAdd(((BaseCurioItem)((Object)TCItems.FISHERMANS_POCKET_GUIDE.get())).getDescriptionId(), "Fisherman's Pocket Guide", this.enData);
            this.sidedAdd(((BaseCurioItem)((Object)TCItems.GPS.get())).getDescriptionId(), "GPS", this.enData);
            this.sidedAdd(((BaseCurioItem)((Object)TCItems.PDA.get())).getDescriptionId(), "PDA", this.enData);
            this.sidedAdd(((BaseCurioItem)((Object)TCItems.REK_3000.get())).getDescriptionId(), "R.E.K.3000", this.enData);
            this.sidedAdd(((BaseCurioItem)((Object)TCItems.NEPTUNES_SHELL.get())).getDescriptionId(), "Neptune's Shell", this.enData);
            this.sidedAdd(((DivingHelmet)((Object)TCItems.DIVING_HELMET.get())).getDescriptionId(), "Diving Helmet", this.enData);
            TCItems.CURIOS.getEntries().forEach(item -> {
                Item item1 = (Item)item.get();
                this.sidedAdd(item1.getDescriptionId(), ModLanguageProvider.toTitleCase(item.getId().getPath()), this.enData);
            });
            TCEntities.ENTITIES.getEntries().forEach(entity -> this.sidedAdd(((EntityType)entity.get()).getDescriptionId(), ModLanguageProvider.toTitleCase(entity.getId().getPath()), this.enData));
            TCEffects.EFFECTS.getEntries().forEach(effect -> this.sidedAdd(((MobEffect)effect.get()).getDescriptionId(), ModLanguageProvider.toTitleCase(effect.getId().getPath()), this.enData));
        } else if (this.locale.equals("zh_cn")) {
            this.sidedAdd(((MobEffect)TCEffects.CONFUSED.get()).getDescriptionId(), "\u56f0\u60d1", this.zhData);
            this.sidedAdd(((MobEffect)TCEffects.CEREBRAL_MINDTRICK.get()).getDescriptionId(), "\u63a7\u8111\u672f", this.zhData);
            this.sidedAdd(((MobEffect)TCEffects.HONEY.get()).getDescriptionId(), "\u8702\u871c", this.zhData);
            this.sidedAdd(((MobEffect)TCEffects.PALADINS_SHIELD.get()).getDescriptionId(), "\u5723\u9a91\u58eb\u62a4\u76fe", this.zhData);
            this.sidedAdd(((MobEffect)TCEffects.GRAVITATION.get()).getDescriptionId(), "\u91cd\u529b", this.zhData);
            this.sidedAdd(((EntityType)TCEntities.BEE_PROJECTILE.get()).getDescriptionId(), "\u871c\u8702\u5c04\u5f39", this.zhData);
            this.sidedAdd(((EntityType)TCEntities.STAR_CLOAK.get()).getDescriptionId(), "\u661f\u661f\u6597\u7bf7", this.zhData);
            this.sidedAdd(((EntityType)TCEntities.STEP_STOOL.get()).getDescriptionId(), "\u68af\u51f3", this.zhData);
        }
        this.add(((WorkshopBlock)((Object)TCBlocks.WORKSHOP.get())).getDescriptionId(), "Workshop", "\u5de5\u5320\u4f5c\u574a");
        this.add("terra_curio.configuration.Speed Shoes", "Speed Shoes", "\u52a0\u901f\u9774");
        this.add("terra_curio.configuration.rareBlocks", "Rare Blocks", "\u7a00\u6709\u65b9\u5757");
        this.add("terra_curio.configuration.attributeReplacements", "Attribute Replacements", "\u5c5e\u6027\u66ff\u6362");
        this.add("terra_curio.configuration.enable", "Enable", "\u542f\u7528");
        this.add("terra_curio.configuration.Random Attack Damage", "Random Attack Damage", "\u968f\u673a\u653b\u51fb\u4f24\u5bb3");
        this.add("terra_curio.configuration.Max Accessory Amount", "Max Accessory Amount", "\u6700\u5927\u914d\u9970\u6570\u91cf");
        this.add("terra_curio.configuration.min", "Min damage multiplier", "\u6700\u4f4e\u4f24\u5bb3\u4e58\u7b97");
        this.add("terra_curio.configuration.rareCreatures", "Rare Creatures", "\u7a00\u6709\u751f\u7269");
        this.add("terra_curio.configuration.Information HUD", "Information HUD", "\u4fe1\u606fHUD");
        this.add("terra_curio.configuration.max", "Max damage multiplier", "\u6700\u9ad8\u4f24\u5bb3\u4e58\u7b97");
        this.add("terra_curio.configuration.Functional", "Functional", "\u529f\u80fd\u6027");
        this.add("terra_curio.configuration.rareBlocks.button", "Configurations for Metal Detector", "\u91d1\u5c5e\u63a2\u6d4b\u5668\u7684\u914d\u7f6e");
        this.add("terra_curio.configuration.Speed Shoes.tooltip", "Configurations for Speed Shoes", "\u52a0\u901f\u7c7b\u9774\u5b50\u7684\u914d\u7f6e");
        this.add("terra_curio.configuration.Functional.tooltip", "Configurations for functional accessories", "\u529f\u80fd\u7c7b\u914d\u9970\u7684\u914d\u7f6e");
        this.add("terra_curio.configuration.attributeReplacements.button", "Allows you to replace some attributes", "\u5141\u8bb8\u90e8\u5206\u5c5e\u6027\u7684\u66ff\u6362");
        this.add("terra_curio.configuration.top", "Relative to the top of the screen as a percentage of distance", "\u76f8\u5bf9\u5c4f\u5e55\u9876\u90e8\u8ddd\u79bb\u767e\u5206\u6bd4");
        this.add("terra_curio.configuration.isLeft", "Whether it is placed on the left", "\u662f\u5426\u7f6e\u4e8e\u5de6\u8fb9");
        this.add("terra_curio.configuration.rightClickDelay", "Right Click Delay Decrease", "\u53f3\u51fb\u5ef6\u8fdf\u964d\u4f4e");
        this.add("terra_curio.configuration.rightClickDelay.tooltip", "Configurations for construction accessories", "\u5efa\u7b51\u7c7b\u914d\u9970\u7684\u914d\u7f6e");
        this.add("terra_curio.configuration.speedUp", "Enable speed up", "\u542f\u7528\u52a0\u901f");
        this.add("terra_curio.configuration.playSound", "Play sound", "\u64ad\u653e\u97f3\u6548");
        this.add("terra_curio.configuration.showParticle", "Show Particle", "\u663e\u793a\u7c92\u5b50");
        this.add("terra_curio.configuration.shoesSoundVolume", "Shoes Sound Volume", "\u9774\u5b50\u97f3\u6548\u97f3\u91cf");
        this.add("terra_curio.configuration.autoAttack", "Auto Attack", "\u81ea\u52a8\u653b\u51fb");
        this.add("terra_curio.configuration.autoAttack.tooltip", "Auto Attack", "\u542f\u7528\u8fd1\u6218\u6b66\u5668\u81ea\u52a8\u6325\u52a8");
    }

    private static String toTitleCase(String raw) {
        return Arrays.stream(raw.split("_")).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        this.addTranslations();
        Path path = this.output.getOutputFolder(PackOutput.Target.RESOURCE_PACK).resolve("terra_curio").resolve("lang");
        if (this.locale.equals("en_us") && !this.enData.isEmpty()) {
            return this.save(this.enData, cache, path.resolve("en_us.json"));
        }
        if (this.locale.equals("zh_cn") && !this.zhData.isEmpty()) {
            return this.save(this.zhData, cache, path.resolve("zh_cn.json"));
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    private CompletableFuture<?> save(Map<String, String> data, CachedOutput cache, Path target) {
        JsonObject json = new JsonObject();
        data.forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)target);
    }

    private void tooltipsAndJeiInfos(Supplier<? extends Item> item, String zhName, String[] enTooltip, String[] zhTooltip, String[] enJeiInfo, String[] zhJeiInfo) {
        String key = item.get().getDescriptionId();
        this.sidedAdd(key, zhName, this.zhData);
        this.addTooltips(key, enTooltip, zhTooltip);
        this.addJeiInfos(key, enJeiInfo, zhJeiInfo);
    }

    private void tooltipsAndJeiInfo(Supplier<? extends Item> item, String zhName, String[] enTooltip, String[] zhTooltip, String enJeiInfo, String zhJeiInfo) {
        String key = item.get().getDescriptionId();
        this.sidedAdd(key, zhName, this.zhData);
        this.addTooltips(key, enTooltip, zhTooltip);
        this.add("jei.tooltip." + key + ".0", enJeiInfo, zhJeiInfo);
    }

    private void tooltipAndJeiInfo(Supplier<? extends Item> item, String zhName, String enTooltip, String zhTooltip, String enJeiInfo, String zhJeiInfo) {
        String key = item.get().getDescriptionId();
        this.sidedAdd(key, zhName, this.zhData);
        this.add("tooltip." + key + ".0", enTooltip, zhTooltip);
        this.add("jei.tooltip." + key + ".0", enJeiInfo, zhJeiInfo);
    }

    private void tooltipAndJeiInfos(Supplier<? extends Item> item, String zhName, String enTooltip, String zhTooltip, String[] enJeiInfo, String[] zhJeiInfo) {
        String key = item.get().getDescriptionId();
        this.sidedAdd(key, zhName, this.zhData);
        this.add("tooltip." + key + ".0", enTooltip, zhTooltip);
        this.addJeiInfos(key, enJeiInfo, zhJeiInfo);
    }

    private void onlyTooltips(Supplier<? extends Item> item, String zhName, String[] enTooltip, String[] zhTooltip) {
        String key = item.get().getDescriptionId();
        this.sidedAdd(key, zhName, this.zhData);
        this.addTooltips(key, enTooltip, zhTooltip);
    }

    private void onlyJeiInfos(Supplier<? extends Item> item, String zhName, String[] enJeiInfo, String[] zhJeiInfo) {
        String key = item.get().getDescriptionId();
        this.sidedAdd(key, zhName, this.zhData);
        this.addJeiInfos(key, enJeiInfo, zhJeiInfo);
    }

    private void onlyZhName(Supplier<? extends Item> item, String zhName) {
        this.sidedAdd(item.get().getDescriptionId(), zhName, this.zhData);
    }

    private void onlyTooltip(Supplier<? extends Item> item, String zhName, String enTooltip, String zhTooltip) {
        String key = item.get().getDescriptionId();
        this.sidedAdd(key, zhName, this.zhData);
        this.add("tooltip." + key + ".0", enTooltip, zhTooltip);
    }

    private void onlyJeiInfo(Supplier<? extends Item> item, String zhName, String enJeiInfo, String zhJeiInfo) {
        String key = item.get().getDescriptionId();
        this.sidedAdd(key, zhName, this.zhData);
        this.add("jei.tooltip." + key + ".0", enJeiInfo, zhJeiInfo);
    }

    private void addTooltip(Supplier<? extends Item> key, int index, String en, String zh) {
        this.add("tooltip." + key.get().getDescriptionId() + "." + index, en, zh);
    }

    private void addTooltips(String key, String[] enTooltip, String[] zhTooltip) {
        if (enTooltip.length == zhTooltip.length) {
            String tooltip = "tooltip." + key + ".";
            for (int i = 0; i < enTooltip.length; ++i) {
                String enLang = enTooltip[i];
                String cnLang = zhTooltip[i];
                this.add(tooltip + i, enLang, cnLang);
            }
        }
    }

    private void addJeiInfos(String key, String[] enJeiInfo, String[] zhJeiInfo) {
        if (enJeiInfo.length == zhJeiInfo.length) {
            String jeiInfo = "jei.tooltip." + key + ".";
            for (int i = 0; i < enJeiInfo.length; ++i) {
                String enLang = enJeiInfo[i];
                String zhLang = zhJeiInfo[i];
                this.add(jeiInfo + i, enLang, zhLang);
            }
        }
    }

    private void add(String key, String en, String zh) {
        if (this.locale.equals("en_us") && !this.enData.containsKey(key)) {
            this.enData.put(key, en);
        } else if (this.locale.equals("zh_cn") && !this.zhData.containsKey(key)) {
            this.zhData.put(key, zh);
        }
    }

    private void sidedAdd(String key, String value, Map<String, String> side) {
        if (!side.containsKey(key)) {
            side.put(key, value);
        }
    }
}

