/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.entity;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.terra_curio.common.init.TCEntities;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BeeProjectile
extends Projectile {
    private static final EntityDataAccessor<Boolean> DATA_IS_GIANT = SynchedEntityData.defineId(BeeProjectile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDimensions SMALL = ((EntityType)TCEntities.BEE_PROJECTILE.get()).getDimensions().scale(0.5f);
    private static final EntityDimensions GIANT = ((EntityType)TCEntities.BEE_PROJECTILE.get()).getDimensions();
    private int blockHitCount = 0;
    private float baseDamage = 5.0f;
    private transient Entity target;

    public BeeProjectile(EntityType<BeeProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public BeeProjectile(Level level, @Nullable LivingEntity owner, boolean isGiant) {
        this((EntityType<BeeProjectile>)((EntityType)TCEntities.BEE_PROJECTILE.get()), level);
        this.setOwner((Entity)owner);
        this.blockHitCount = 0;
        this.entityData.set(DATA_IS_GIANT, (Object)isGiant);
    }

    public void setBaseDamage(float baseDamage) {
        this.baseDamage = baseDamage;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_IS_GIANT, (Object)false);
    }

    public boolean isGiant() {
        return (Boolean)this.entityData.get(DATA_IS_GIANT);
    }

    public void tick() {
        if (this.target == null) {
            double d0 = -1.0;
            Entity enemy = null;
            for (Entity entity : this.level().getEntities((Entity)this, new AABB(this.blockPosition()).inflate(8.0))) {
                if (!(entity instanceof Enemy)) continue;
                double d1 = entity.distanceToSqr(this.getX(), this.getY(), this.getZ());
                if (d0 != -1.0 && !(d1 < d0)) continue;
                d0 = d1;
                enemy = entity;
            }
            this.target = enemy;
        }
        if (this.target != null) {
            LivingEntity living;
            Entity entity;
            if (this.target.isSpectator() || (entity = this.target) instanceof LivingEntity && (living = (LivingEntity)entity).isDeadOrDying()) {
                this.target = null;
            }
            if (this.target != null) {
                Vec3 vec3 = this.target.getEyePosition().subtract(this.position()).normalize();
                this.addDeltaMovement(vec3.scale(0.95).scale(this.isGiant() ? 0.15 : 0.05));
            }
        }
        if (this.tickCount % 4 == 0) {
            AABB boundingBox = this.getBoundingBox().inflate(1.0);
            EntityHitResult hitresult = ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)boundingBox.getMinPosition(), (Vec3)boundingBox.getMaxPosition(), (AABB)boundingBox, this::canHitEntity);
            if (hitresult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = hitresult;
                this.onHitEntity(entityHitResult);
            }
        }
        this.checkInsideBlocks();
        this.updateRotation();
        Vec3 vec3 = this.getDeltaMovement();
        this.move(MoverType.SELF, vec3);
        Vec3 motion = this.getDeltaMovement();
        if (motion.x != vec3.x || motion.y != vec3.y || motion.z != vec3.z) {
            if (motion.x != vec3.x) {
                motion = new Vec3(-vec3.x, vec3.y, vec3.z);
            }
            if (motion.y != vec3.y) {
                motion = new Vec3(vec3.x, -vec3.y, vec3.z);
            }
            if (motion.z != vec3.z) {
                motion = new Vec3(vec3.x, vec3.y, -vec3.z);
            }
            this.setDeltaMovement(motion);
            ++this.blockHitCount;
        }
        if (this.getInBlockState().liquid()) {
            this.discard();
        } else if (this.blockHitCount > (this.isGiant() ? 2 : 1) || this.tickCount > (this.isGiant() ? 220 : 200)) {
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.getEntity();
        if (this.getOwner() != null) {
            float damage = this.baseDamage + (float)(this.isGiant() ? this.random.nextInt(1, 4) : (this.random.nextBoolean() ? 1 : 0));
            entity.hurt(this.damageSources().indirectMagic((Entity)this, this.getOwner()), damage);
            if (this.isGiant()) {
                Vec3 motion = entity.position().subtract(this.position()).normalize().scale(0.5);
                entity.push(motion.x, motion.y, motion.z);
            }
        }
    }

    public EntityDimensions getDimensions(Pose pPose) {
        return this.isGiant() ? GIANT : SMALL;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (DATA_IS_GIANT.equals(key)) {
            this.refreshDimensions();
            this.setBoundingBox(this.makeBoundingBox());
        }
    }

    protected boolean canHitEntity(Entity target) {
        Entity owner = this.getOwner();
        if (!target.canBeHitByProjectile() || target instanceof ArmorStand || target instanceof Npc) {
            return false;
        }
        return owner == null || owner != target && !owner.isPassengerOfSameVehicle(target);
    }

    public void shootFromRotation(Entity shooter, float x, float y, float z, float velocity, float inaccuracy) {
        float cos = Mth.cos((float)(x * ((float)Math.PI / 180)));
        float value = y * ((float)Math.PI / 180);
        float f = -Mth.sin((float)value) * cos;
        float f1 = -Mth.sin((float)((x + z) * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)value) * cos;
        this.shoot(f, f1, f2, velocity, inaccuracy);
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.tickCount = compound.getInt("Age");
        this.blockHitCount = compound.getInt("BlockHitCount");
        this.baseDamage = compound.getFloat("BaseDamage");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Age", this.tickCount);
        compound.putInt("BlockHitCount", this.blockHitCount);
        compound.putFloat("BaseDamage", this.baseDamage);
    }
}

