/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.entity;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.LibUtils;
import org.confluence.terra_curio.common.init.TCDamageTypes;
import org.confluence.terra_curio.common.init.TCEntities;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StarCloakEntity
extends Projectile {
    private static final EntityDataAccessor<Boolean> DATA_MANA = SynchedEntityData.defineId(StarCloakEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final boolean hasMana;
    private int age;

    public StarCloakEntity(EntityType<StarCloakEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.hasMana = false;
    }

    public StarCloakEntity(Level level, LivingEntity living, Entity target, boolean hasMana) {
        super((EntityType)TCEntities.STAR_CLOAK.get(), level);
        this.hasMana = hasMana;
        this.setOwner((Entity)living);
        this.setPos(target.position().add(0.0, 32.0, 0.0));
        this.setDeltaMovement(0.0, -2.0, 0.0);
        this.setNoGravity(true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_MANA, (Object)false);
    }

    public void tick() {
        boolean mana;
        if (this.getOwner() == null) {
            this.discard();
            return;
        }
        super.tick();
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        Vec3 vec3 = this.getDeltaMovement();
        HitResult.Type hitresult$type = hitresult.getType();
        if (hitresult$type == HitResult.Type.BLOCK) {
            if (this.hasMana) {
                this.entityData.set(DATA_MANA, (Object)true);
            } else {
                this.discard();
                return;
            }
        }
        if (hitresult.getLocation().y < this.getOwner().getY()) {
            this.discard();
            return;
        }
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)hitresult);
        }
        if (mana = this.isManaState().booleanValue()) {
            this.addDeltaMovement(this.getOwner().position().subtract(this.position()).normalize().scale(0.05));
        }
        double offX = this.getX() + vec3.x;
        double offY = this.getY() + vec3.y;
        double offZ = this.getZ() + vec3.z;
        this.setPos(offX, offY, offZ);
        if (mana && this.age++ > 100 || this.tickCount > 200) {
            this.discard();
        }
    }

    protected void onHitEntity(EntityHitResult pResult) {
        if (this.isManaState().booleanValue()) {
            LibUtils.forMixin$Inject();
        } else {
            pResult.getEntity().hurt(TCDamageTypes.of(this.level(), TCDamageTypes.STAR_CLOAK, this.getOwner()), 10.0f);
        }
    }

    @NotNull
    private Boolean isManaState() {
        return (Boolean)this.entityData.get(DATA_MANA);
    }

    protected boolean canHitEntity(Entity pTarget) {
        if (!pTarget.canBeHitByProjectile()) {
            return false;
        }
        if (this.isManaState().booleanValue()) {
            return pTarget == this.getOwner();
        }
        Entity owner = this.getOwner();
        return pTarget != owner || !owner.isPassengerOfSameVehicle(pTarget);
    }
}

