/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.confluence.terra_curio.common.init.TCEntities;
import org.confluence.terra_curio.network.s2c.StepStoolSteppingPacketS2C;

public class StepStoolEntity
extends Entity
implements TraceableEntity {
    private static final EntityDataAccessor<Integer> DATA_STEP_ID = SynchedEntityData.defineId(StepStoolEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final Vec3 GRAVITY = new Vec3(0.0, -0.08, 0.0);
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;

    public StepStoolEntity(EntityType<StepStoolEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.blocksBuilding = true;
    }

    public StepStoolEntity(Player player) {
        this((EntityType<StepStoolEntity>)((EntityType)TCEntities.STEP_STOOL.get()), player.level());
        this.setPos(player.getX(), player.getY(), player.getZ());
        this.setOwner((Entity)player);
    }

    public void tick() {
        Entity owner;
        super.tick();
        if (!(this.level().isClientSide || (owner = this.getOwner()) != null && owner.getVehicle() == null)) {
            this.discard();
        }
        this.addDeltaMovement(GRAVITY);
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    public void remove(Entity.RemovalReason pReason) {
        super.remove(pReason);
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            StepStoolSteppingPacketS2C.resetStep((Entity)serverPlayer);
        }
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_STEP_ID, (Object)1);
    }

    public void setStep(int step) {
        this.entityData.set(DATA_STEP_ID, (Object)step);
    }

    public int getStep() {
        return (Integer)this.entityData.get(DATA_STEP_ID);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        if (DATA_STEP_ID.equals(pKey)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(pKey);
    }

    public void setOwner(@Nullable Entity pOwner) {
        this.ownerUUID = pOwner == null ? null : pOwner.getUUID();
        this.cachedOwner = pOwner;
    }

    @Nullable
    public Entity getOwner() {
        Level level;
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.cachedOwner = serverLevel.getEntity(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
        if (pCompound.hasUUID("Owner")) {
            this.ownerUUID = pCompound.getUUID("Owner");
            this.cachedOwner = null;
        }
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
        if (this.ownerUUID != null) {
            pCompound.putUUID("Owner", this.ownerUUID);
        }
    }

    public EntityDimensions getDimensions(Pose pPose) {
        return super.getDimensions(pPose).scale(1.0f, (float)this.getStep());
    }

    public void updateFluidHeightAndDoFluidPushing() {
    }
}

