/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.entity;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.common.entitiy.IAxisZRotate;

public class XBoneProjectile
extends Projectile
implements IAxisZRotate {
    public final IAxisZRotate.Rotate rotate = new IAxisZRotate.Rotate();
    private int collideCount = 0;
    private final Set<Entity> passThrough = new HashSet<Entity>();

    public XBoneProjectile(EntityType<XBoneProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        Entity entity = this.getOwner();
        if (!(entity instanceof LivingEntity)) {
            this.discard();
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        super.tick();
        Vec3 vec3 = this.getDeltaMovement();
        this.move(MoverType.SELF, vec3.add(0.0, -this.getDefaultGravity(), 0.0));
        Vec3 motion = this.getDeltaMovement();
        if (!vec3.equals((Object)motion)) {
            if (motion.x != vec3.x) {
                motion = new Vec3(-vec3.x, vec3.y, vec3.z);
            }
            if (motion.y != vec3.y) {
                motion = new Vec3(vec3.x, -vec3.y, vec3.z);
            }
            if (motion.z != vec3.z) {
                motion = new Vec3(vec3.x, vec3.y, -vec3.z);
            }
            if (this.collideCount++ >= 3) {
                this.discard();
                return;
            }
        }
        this.setDeltaMovement(motion.scale(0.96).add(0.0, -this.getDefaultGravity(), 0.0));
        if (this.level().isClientSide) {
            this.rotateZ(this.rotate, () -> ((XBoneProjectile)this).getDeltaMovement(), (float)this.getDefaultGravity(), 0.125f);
        } else {
            AABB boundingBox = this.getBoundingBox().inflate(1.0);
            EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Level)this.level(), (Entity)this, (Vec3)boundingBox.getMinPosition(), (Vec3)boundingBox.getMaxPosition(), (AABB)boundingBox, this::canHitEntity, (float)0.5f);
            if (entityHitResult instanceof EntityHitResult) {
                EntityHitResult entityHitResult2 = entityHitResult;
                Entity entity2 = entityHitResult2.getEntity();
                entity2.hurt(this.damageSources().mobProjectile((Entity)this, owner), 5.0f);
                if (this.passThrough.add(entity2) && this.passThrough.size() >= 3) {
                    this.discard();
                }
            }
        }
    }

    protected void updateRotation() {
        if (this.rotate.different()) {
            super.updateRotation();
        }
    }

    protected boolean canHitEntity(Entity target) {
        Entity owner = this.getOwner();
        if (!target.canBeHitByProjectile() || target instanceof ArmorStand || target instanceof Npc) {
            return false;
        }
        return owner == null || owner != target && !owner.isPassengerOfSameVehicle(target);
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.collideCount = compound.getInt("CollideCount");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("CollideCount", this.collideCount);
    }
}

