/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.event;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.util.LibUtils;
import org.confluence.terra_curio.client.handler.GravitationHandler;
import org.confluence.terra_curio.client.handler.TCClientPacketHandler;
import org.confluence.terra_curio.common.attachment.AccessoriesAttachment;
import org.confluence.terra_curio.common.attachment.AccessoriesValueCommand;
import org.confluence.terra_curio.common.init.TCAttachments;
import org.confluence.terra_curio.common.init.TCAttributes;
import org.confluence.terra_curio.common.init.TCCommonConfigs;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.common.init.TCTags;
import org.confluence.terra_curio.common.init.TCTriggers;
import org.confluence.terra_curio.common.item.DivingHelmet;
import org.confluence.terra_curio.common.item.curio.combat.PaladinsShield;
import org.confluence.terra_curio.common.item.curio.combat.PanicNecklace;
import org.confluence.terra_curio.mixin.accessor.ItemEntityAccessor;
import org.confluence.terra_curio.network.s2c.AttackDamagePacketS2C;
import org.confluence.terra_curio.network.s2c.EntityKilledPacketS2C;
import org.confluence.terra_curio.network.s2c.InfoCurioCheckPacketS2C;
import org.confluence.terra_curio.network.s2c.SetItemEntityPickupDelayPacketS2C;
import org.confluence.terra_curio.util.TCUtils;
import top.theillusivec4.curios.api.event.CurioChangeEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="terra_curio")
public final class GameEvents {
    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        AccessoriesValueCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void curios(CurioChangeEvent event) {
        LivingEntity living = event.getEntity();
        if (!living.level().isClientSide && !ItemStack.isSameItem((ItemStack)event.getFrom(), (ItemStack)event.getTo())) {
            ((AccessoriesAttachment)living.getData(TCAttachments.ACCESSORIES)).flushAbility(living);
            if (living instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)living;
                TCUtils.resetClientPacket(serverPlayer);
                TCTriggers.CURIOS_EQUIPPED.get().trigger(serverPlayer, event.getTo());
            }
        }
    }

    @SubscribeEvent
    public static void entityInvulnerabilityCheck(EntityInvulnerabilityCheckEvent event) {
        if (event.isInvulnerable()) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.is(DamageTypes.FELL_OUT_OF_WORLD) || damageSource.is(DamageTypes.GENERIC_KILL)) {
            return;
        }
        if (TCUtils.isInvulnerableTo(event.getEntity(), damageSource)) {
            event.setInvulnerable(true);
        }
    }

    @SubscribeEvent
    public static void livingIncomingDamage(LivingIncomingDamageEvent event) {
        DamageContainer container = event.getContainer();
        float invulnerableTicksMultiplier = TCUtils.getAccessoriesValue(event.getEntity(), TCItems.INVULNERABLE$TICKS$MULTIPLIER).floatValue();
        container.setPostAttackInvulnerabilityTicks((int)((float)container.getPostAttackInvulnerabilityTicks() * invulnerableTicksMultiplier));
    }

    @SubscribeEvent
    public static void livingDamage$Pre(LivingDamageEvent.Pre event) {
        float amount = event.getNewDamage();
        if (amount <= 0.0f) {
            return;
        }
        LivingEntity living = event.getEntity();
        if (living.level().isClientSide) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return;
        }
        RandomSource random = living.level().random;
        TCUtils.applyHoneyComb(living, random);
        TCUtils.applyStarClock(living, random);
        PanicNecklace.apply(living);
        amount = DivingHelmet.apply(living, damageSource, amount);
        amount = TCAttributes.applyMagicDamage(random, damageSource, amount);
        amount = TCAttributes.applyRangedDamage(random, damageSource, amount);
        amount = PaladinsShield.apply(living, damageSource, amount);
        amount = TCUtils.applyFrozenTurtleShell(living, amount);
        amount = TCUtils.applyLavaHurtReduce(living, damageSource, amount);
        amount = TCUtils.applyInjuryFree(living, amount);
        amount = TCUtils.applyBrainOfConfusion(living, random, damageSource, amount);
        if (((Boolean)TCCommonConfigs.RANDOM_ATTACK_DAMAGE.get()).booleanValue()) {
            amount *= Mth.nextFloat((RandomSource)random, (float)((Double)TCCommonConfigs.RANDOM_ATTACK_DAMAGE_MIN.get()).floatValue(), (float)((Double)TCCommonConfigs.RANDOM_ATTACK_DAMAGE_MAX.get()).floatValue());
        }
        event.setNewDamage(amount);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void livingDamage$Post(LivingDamageEvent.Post event) {
        if (!event.getEntity().level().isClientSide) {
            AttackDamagePacketS2C.sendToClient(event.getNewDamage(), event.getSource().getEntity());
        }
    }

    @SubscribeEvent
    public static void livingDeath(LivingDeathEvent event) {
        DamageSource damageSource = event.getSource();
        Entity entity = damageSource.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            EntityType entityType = event.getEntity().getType();
            EntityKilledPacketS2C.sendToClient(serverPlayer, entityType);
        }
    }

    @SubscribeEvent
    public static void livingChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity self = event.getEntity();
        if (!(self instanceof Enemy)) {
            return;
        }
        LivingEntity livingEntity = event.getNewAboutToBeSetTarget();
        if (livingEntity instanceof Player) {
            Player playerO = (Player)livingEntity;
            double range = self.getAttributeValue(Attributes.FOLLOW_RANGE);
            double rangeSqr = range * range;
            self.level().players().stream().filter(player -> player.distanceToSqr((Entity)self) < rangeSqr && self.canAttack((LivingEntity)player)).max((playerA, playerB) -> {
                AttributeInstance instanceA = playerA.getAttribute(TCAttributes.AGGRO);
                AttributeInstance instanceB = playerB.getAttribute(TCAttributes.AGGRO);
                if (instanceA != null && instanceB != null) {
                    return (int)(instanceA.getValue() - instanceB.getValue());
                }
                return 0;
            }).ifPresent(player -> {
                if (player == playerO) {
                    return;
                }
                AttributeInstance instanceO = playerO.getAttribute(TCAttributes.AGGRO);
                AttributeInstance instance = player.getAttribute(TCAttributes.AGGRO);
                if (instanceO != null && instance != null && instanceO.getValue() < instance.getValue()) {
                    event.setNewAboutToBeSetTarget((LivingEntity)player);
                }
            });
        }
    }

    @SubscribeEvent
    public static void entityJoinLevel(EntityJoinLevelEvent event) {
        AbstractArrow arrow;
        if (event.loadedFromDisk() || event.getLevel().isClientSide) {
            Entity entity = event.getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                ((AccessoriesAttachment)living.getData(TCAttachments.ACCESSORIES)).flushAbility(living);
            }
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)entity).getOwner()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            TCAttributes.applyToArrow(living, arrow);
            TCUtils.applyIgniteArrow(living, arrow);
        }
    }

    @SubscribeEvent
    public static void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        ((AccessoriesAttachment)player.getData(TCAttachments.ACCESSORIES)).flushAbility((LivingEntity)player);
        ServerPlayer serverPlayer = (ServerPlayer)player;
        TCUtils.resetClientPacket(serverPlayer);
        InfoCurioCheckPacketS2C.sendToClient(serverPlayer, serverPlayer.getInventory());
    }

    @SubscribeEvent
    public static void playerTick$Pre(PlayerTickEvent.Pre event) {
        if (event.getEntity().isLocalPlayer()) {
            GravitationHandler.unCrouching(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void playerTick$Post(PlayerTickEvent.Post event) {
        ServerPlayer serverPlayer;
        Player player = event.getEntity();
        TCAttributes.applyPickupRange(player);
        if (!player.isPassenger()) {
            TCUtils.applyFluidWalk(player);
        }
        if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).level().getGameTime() % 200L == 0L) {
            InfoCurioCheckPacketS2C.sendToOthers(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void attackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            TCUtils.applyFireAttack(player, event.getTarget());
        }
    }

    @SubscribeEvent
    public static void criticalHit(CriticalHitEvent event) {
        Player player;
        if (TCAttributes.hasCustomAttribute(TCAttributes.CRIT_CHANCE) || ((Boolean)ConfluenceMagicLib.IS_CONFLUENCE_LOADED.get()).booleanValue()) {
            return;
        }
        if (!event.isVanillaCritical() && LibUtils.checkChance((double)(player = event.getEntity()).getAttributeValue(TCAttributes.CRIT_CHANCE), (RandomSource)player.getRandom())) {
            event.setDamageMultiplier(1.5f);
            event.setCriticalHit(true);
        }
    }

    @SubscribeEvent
    public static void itemToss(ItemTossEvent event) {
        ItemEntity itemEntity = event.getEntity();
        SetItemEntityPickupDelayPacketS2C.sendToAll(itemEntity.getId(), ((ItemEntityAccessor)itemEntity).getPickupDelay());
    }

    @SubscribeEvent
    public static void livingBreathe(LivingBreatheEvent event) {
        LivingEntity living = event.getEntity();
        if (event.canBreathe()) {
            return;
        }
        if (living.level().isClientSide) {
            if (living.getClass() == LocalPlayer.class && TCClientPacketHandler.isHasNeptunesShell()) {
                event.setCanBreathe(true);
                event.setRefillAirAmount(4);
            }
        } else if (TCUtils.hasAccessoriesType(living, TCItems.NEPTUNES$SHELL)) {
            event.setCanBreathe(true);
            event.setRefillAirAmount(4);
        } else if (living.getAirSupply() > 0 && living.level().getGameTime() % 8L != 0L && (living.getItemBySlot(EquipmentSlot.HEAD).is(TCTags.DIVING) || TCUtils.hasAccessoriesType(living, TCItems.DIVING))) {
            event.setConsumeAirAmount(0);
        }
    }

    @SubscribeEvent
    public static void finalizeSpawn(FinalizeSpawnEvent event) {
        Drowned drowned;
        if (event.isSpawnCancelled()) {
            return;
        }
        Mob mob = event.getEntity();
        if (mob instanceof Drowned && (drowned = (Drowned)mob).getItemBySlot(EquipmentSlot.HEAD).isEmpty() && drowned.getRandom().nextFloat() < 0.05f) {
            drowned.setItemSlot(EquipmentSlot.HEAD, ((DivingHelmet)((Object)TCItems.DIVING_HELMET.get())).getDefaultInstance());
            drowned.setDropChance(EquipmentSlot.HEAD, 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void mobEffect$Applicable(MobEffectEvent.Applicable event) {
        if (event.getResult() != MobEffectEvent.Applicable.Result.DO_NOT_APPLY && TCUtils.getAccessoriesValue(event.getEntity(), TCItems.EFFECT$IMMUNITIES).contains(event.getEffectInstance().getEffect())) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }
}

