/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.init;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.PercentageAttribute;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.util.LibUtils;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.common.init.TCDamageTypes;
import org.confluence.terra_curio.common.init.TCStartupConfigs;
import org.confluence.terra_curio.integration.apothic.ApothicHelper;

public final class TCAttributes {
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((Registry)BuiltInRegistries.ATTRIBUTE, (String)"terra_curio");
    public static final DeferredHolder<Attribute, Attribute> CRIT_CHANCE = ATTRIBUTES.register("generic.crit_chance", () -> new PercentageAttribute("attribute.name.generic.critical_chance", 0.0, 0.0, 10.0).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> RANGED_VELOCITY = ATTRIBUTES.register("generic.ranged_velocity", () -> new RangedAttribute("attribute.name.generic.ranged_velocity", 1.0, 0.0, 10.0).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> RANGED_DAMAGE = ATTRIBUTES.register("generic.ranged_damage", () -> new RangedAttribute("attribute.name.generic.ranged_damage", 1.0, 0.0, 10.0).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> DODGE_CHANCE = ATTRIBUTES.register("generic.dodge_chance", () -> new PercentageAttribute("attribute.name.generic.dodge_chance", 0.0, 0.0, 1.0).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> MAGIC_DAMAGE = ATTRIBUTES.register("generic.magic_damage", () -> new RangedAttribute("attribute.name.generic.magic_damage", 1.0, 0.0, 10.0).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> ARMOR_PENETRATION = ATTRIBUTES.register("generic.armor_penetration", () -> new RangedAttribute("attribute.name.generic.armor_penetration", 0.0, 0.0, 10000.0).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> PICKUP_RANGE = ATTRIBUTES.register("player.pickup_range", () -> new RangedAttribute("attribute.name.player.pickup_range", 0.0, 0.0, 64.0).setSyncable(true));
    public static final DeferredHolder<Attribute, Attribute> AGGRO = ATTRIBUTES.register("player.aggro", () -> new RangedAttribute("attribute.name.player.aggro", 0.0, -10000.0, 10000.0).setSyncable(true).setSentiment(Attribute.Sentiment.NEGATIVE));
    private static final Map<Holder<Attribute>, Holder<Attribute>> MAP = (Map)Util.make(new HashMap(), table -> {
        table.put(CRIT_CHANCE, null);
        table.put(RANGED_DAMAGE, null);
        table.put(RANGED_VELOCITY, null);
        table.put(DODGE_CHANCE, null);
        table.put(MAGIC_DAMAGE, null);
        table.put(ARMOR_PENETRATION, null);
    });

    public static Holder<Attribute> getCriticalChance() {
        return TCAttributes.getCustomAttribute(CRIT_CHANCE);
    }

    public static Holder<Attribute> getRangedVelocity() {
        return TCAttributes.getCustomAttribute(RANGED_VELOCITY);
    }

    public static Holder<Attribute> getRangedDamage() {
        return TCAttributes.getCustomAttribute(RANGED_DAMAGE);
    }

    public static Holder<Attribute> getDodgeChance() {
        return TCAttributes.getCustomAttribute(DODGE_CHANCE);
    }

    public static Holder<Attribute> getMagicDamage() {
        return TCAttributes.getCustomAttribute(MAGIC_DAMAGE);
    }

    public static Holder<Attribute> getArmorPenetration() {
        return TCAttributes.getCustomAttribute(ARMOR_PENETRATION);
    }

    public static Holder<Attribute> getCustomAttribute(Holder<Attribute> attribute) {
        Holder<Attribute> target = MAP.get(attribute);
        if (target == null) {
            return attribute;
        }
        return target;
    }

    public static boolean hasCustomAttribute(Holder<Attribute> attribute) {
        Holder<Attribute> holder = MAP.get(attribute);
        return holder != null && holder.value() != attribute.value();
    }

    public static void registerAttribute(Holder<Attribute> attribute, BiConsumer<EntityType<? extends LivingEntity>, Holder<Attribute>> consumer) {
        if (!TCAttributes.hasCustomAttribute(attribute)) {
            consumer.accept((EntityType<? extends LivingEntity>)EntityType.PLAYER, attribute);
        }
    }

    public static void applyToArrow(LivingEntity living, AbstractArrow abstractArrow) {
        AttributeInstance instance;
        if (!TCAttributes.hasCustomAttribute(RANGED_VELOCITY) && (instance = living.getAttribute(RANGED_VELOCITY)) != null) {
            abstractArrow.setDeltaMovement(abstractArrow.getDeltaMovement().scale(instance.getValue()));
        }
        if (!abstractArrow.isCritArrow() && !TCAttributes.hasCustomAttribute(CRIT_CHANCE) && (instance = living.getAttribute(CRIT_CHANCE)) != null) {
            abstractArrow.setCritArrow(LibUtils.checkChance((double)instance.getValue(), (RandomSource)living.getRandom()));
        }
    }

    public static double applyArrowKnockback(Entity attacker, double original) {
        LivingEntity living;
        AttributeInstance instance;
        if (attacker instanceof LivingEntity && (instance = (living = (LivingEntity)attacker).getAttribute(Attributes.ATTACK_KNOCKBACK)) != null) {
            original *= 1.0 + instance.getValue();
        }
        return original;
    }

    public static boolean applyDodge(LivingEntity living, RandomSource random) {
        if (TCAttributes.hasCustomAttribute(DODGE_CHANCE) || !living.getAttributes().hasAttribute(DODGE_CHANCE)) {
            return false;
        }
        AttributeInstance instance = living.getAttribute(DODGE_CHANCE);
        if (instance == null) {
            return false;
        }
        return LibUtils.checkChance((double)instance.getValue(), (RandomSource)random);
    }

    public static float applyCritDamage(RandomSource random, LivingEntity living, float amount) {
        if (((Boolean)ConfluenceMagicLib.IS_CONFLUENCE_LOADED.get()).booleanValue() || TCAttributes.hasCustomAttribute(CRIT_CHANCE)) {
            return amount;
        }
        AttributeInstance instance = living.getAttribute(CRIT_CHANCE);
        if (instance != null && LibUtils.checkChance((double)instance.getValue(), (RandomSource)random)) {
            amount *= 1.5f;
        }
        return amount;
    }

    public static float applyRangedDamage(RandomSource random, DamageSource damageSource, float amount) {
        Entity entity;
        if (TCAttributes.hasCustomAttribute(RANGED_DAMAGE)) {
            return amount;
        }
        if (damageSource.is(DamageTypeTags.IS_PROJECTILE) && (entity = damageSource.getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            AttributeInstance instance = living.getAttribute(RANGED_DAMAGE);
            if (instance != null) {
                amount *= (float)instance.getValue();
            }
            if (!(damageSource.getDirectEntity() instanceof AbstractArrow)) {
                amount = TCAttributes.applyCritDamage(random, living, amount);
            }
        }
        return amount;
    }

    public static float applyMagicDamage(RandomSource random, DamageSource damageSource, float amount) {
        Entity entity;
        if (TCAttributes.hasCustomAttribute(MAGIC_DAMAGE)) {
            return amount;
        }
        if (damageSource.is(Tags.DamageTypes.IS_MAGIC) && (entity = damageSource.getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            AttributeInstance instance = living.getAttribute(MAGIC_DAMAGE);
            if (instance != null) {
                amount *= (float)instance.getValue();
            }
            if (!(damageSource.getDirectEntity() instanceof AbstractArrow)) {
                amount = TCAttributes.applyCritDamage(random, living, amount);
            }
        }
        return amount;
    }

    public static void applyPickupRange(Player player) {
        float range;
        AttributeInstance instance = player.getAttribute(PICKUP_RANGE);
        float[] ranges = new float[3];
        float f = range = instance == null ? 0.0f : (float)instance.getValue();
        if (range <= 0.0f) {
            return;
        }
        player.level().getEntitiesOfClass(ItemEntity.class, new AABB(player.blockPosition()).inflate((double)Math.max(Math.max(Math.max(range, ranges[0]), ranges[1]), ranges[2])), itemEntity -> !itemEntity.hasPickUpDelay()).forEach(itemEntity -> {
            if (itemEntity.isRemoved() || TCAttributes.forMixin$skip(player, itemEntity, ranges)) {
                return;
            }
            itemEntity.addDeltaMovement(player.position().subtract(itemEntity.getX(), itemEntity.getY(), itemEntity.getZ()).normalize().scale((double)0.05f).add(0.0, (double)0.04f, 0.0));
            itemEntity.move(MoverType.SELF, itemEntity.getDeltaMovement());
        });
    }

    private static boolean forMixin$skip(Player player, ItemEntity itemEntity, float[] ranges) {
        return false;
    }

    public static float applyArmorPenetration(DamageSource damageSource, float armorValue) {
        Entity entity;
        if (!TCAttributes.hasCustomAttribute(ARMOR_PENETRATION) && (entity = damageSource.getEntity()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            AttributeInstance attributeInstance = attacker.getAttribute(ARMOR_PENETRATION);
            if (attributeInstance != null) {
                armorValue -= (float)attributeInstance.getValue();
            }
            if (damageSource.is(TCDamageTypes.STAR_CLOAK)) {
                armorValue -= 3.0f;
            }
            return Math.max(armorValue, 0.0f);
        }
        return armorValue;
    }

    public static void prepareReplacements() {
        Map<String, DeferredHolder<Attribute, Attribute>> available = Map.of("crit_chance", CRIT_CHANCE, "ranged_velocity", RANGED_VELOCITY, "ranged_damage", RANGED_DAMAGE, "dodge_chance", DODGE_CHANCE, "magic_damage", MAGIC_DAMAGE, "armor_penetration", ARMOR_PENETRATION);
        ApothicHelper.preset(MAP);
        List attributes = (List)TCStartupConfigs.ATTRIBUTE_REPLACE.get();
        for (String attribute : attributes) {
            String[] split = attribute.split("=");
            if (split.length != 2) {
                TerraCurio.LOGGER.warn("Bad format of '{}', which must contains exactly one '='", (Object)attribute);
                continue;
            }
            Holder holder = (Holder)available.get(split[0].strip());
            if (holder == null) {
                TerraCurio.LOGGER.warn("Unsupported attribute: {}", (Object)split[0].strip());
                continue;
            }
            Optional optional = BuiltInRegistries.ATTRIBUTE.getHolder(ResourceLocation.parse((String)split[1].strip()));
            if (optional.isEmpty()) {
                TerraCurio.LOGGER.warn("Unknown attribute: {}", (Object)split[1].strip());
                continue;
            }
            MAP.replace((Holder<Attribute>)holder, (Holder<Attribute>)((Holder)optional.get()));
        }
    }
}

