/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.item;

import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.LibUtils;
import org.confluence.terra_curio.TerraCurio;
import org.confluence.terra_curio.common.init.TCCommonConfigs;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class DemonHeart
extends Item {
    public static final ResourceLocation ID = TerraCurio.asResource("demon_heart");

    public DemonHeart() {
        super(new Item.Properties().component(ConfluenceMagicLib.MOD_RARITY, (Object)ModRarity.EXPERT).stacksTo(1).fireResistant());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(iCuriosItemHandler -> {
                ICurioStacksHandler iCurioStacksHandler = (ICurioStacksHandler)iCuriosItemHandler.getCurios().get("accessory");
                if (iCurioStacksHandler != null && iCurioStacksHandler.getSlots() < (Integer)TCCommonConfigs.MAX_ACCESSORIES.get()) {
                    itemStack.shrink(1);
                    Map modifiers = iCurioStacksHandler.getModifiers();
                    double before = modifiers.containsKey(ID) ? ((AttributeModifier)modifiers.get(ID)).amount() : 0.0;
                    iCurioStacksHandler.removeModifier(ID);
                    iCuriosItemHandler.addPermanentSlotModifier("accessory", ID, before + 1.0, AttributeModifier.Operation.ADD_VALUE);
                    LibUtils.forMixin$ModifyExpression((Object)serverPlayer);
                }
            });
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.terra_curio.demon_heart.0").withStyle(ChatFormatting.GREEN));
        CuriosApi.getCuriosInventory((LivingEntity)Minecraft.getInstance().player).ifPresent(iCuriosItemHandler -> {
            ICurioStacksHandler iCurioStacksHandler = (ICurioStacksHandler)iCuriosItemHandler.getCurios().get("accessory");
            MutableComponent remainingTimes = Component.translatable((String)"tooltip.item.terra_curio.demon_heart.1", (Object[])new Object[]{(Integer)TCCommonConfigs.MAX_ACCESSORIES.get() - iCurioStacksHandler.getSlots()}).withColor(0xAAAAAA);
            tooltipComponents.add((Component)remainingTimes);
        });
    }
}

