/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.common.item;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.confluence.lib.util.LibUtils;
import org.confluence.terra_curio.api.primitive.TooltipComponentsValue;
import org.confluence.terra_curio.common.component.AccessoriesComponent;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.util.TCUtils;
import org.jetbrains.annotations.Nullable;

public interface IFunctionCouldEnable {
    public static final String DISABLE = "disable";

    default public String getDisableKey() {
        return DISABLE;
    }

    default public boolean isEnabled(ItemStack itemStack, @Nullable TooltipComponentsValue.Storage storage) {
        return !LibUtils.getItemStackNbtNoCopy((ItemStack)itemStack).getBoolean(this.getDisableKey());
    }

    default public void cycleEnable(ItemStack itemStack) {
        LibUtils.updateItemStackNbt((ItemStack)itemStack, tag -> {
            String key;
            tag.putBoolean(key, !tag.getBoolean(key = this.getDisableKey()));
        });
    }

    @Nullable
    default public TooltipComponent getTooltipComponent(ItemStack itemStack) {
        AccessoriesComponent component = TCUtils.getAccessoriesComponent(itemStack);
        if (component == null) {
            return null;
        }
        TooltipComponentsValue value = component.get(TCItems.INFORMATION);
        if (value == null) {
            return null;
        }
        return new TooltipComponentsValue.Multi((List<TooltipComponentsValue.Storage>)value.get());
    }

    public static interface Multi
    extends IFunctionCouldEnable {
        public static final Object2IntMap<TooltipComponentsValue.Storage> INDEX_MAP = (Object2IntMap)Util.make((Object)new Object2IntArrayMap(), map -> {
            map.put((Object)TCItems.MINUTE$WATCH, 0);
            map.put((Object)TCItems.WEATHER$RADIO, 1);
            map.put((Object)TCItems.$SEXTANT, 2);
            map.put((Object)TCItems.FISHERMANS$POCKET$GUIDE, 3);
            map.put((Object)TCItems.METAL$DETECTOR, 4);
            map.put((Object)TCItems.LIFE$FORM$ANALYZER, 5);
            map.put((Object)TCItems.$RADAR, 6);
            map.put((Object)TCItems.TALLY$COUNTER, 7);
            map.put((Object)TCItems.DPS$METER, 8);
            map.put((Object)TCItems.$STOPWATCH, 9);
            map.put((Object)TCItems.$COMPASS, 10);
            map.put((Object)TCItems.DEPTH$METER, 11);
        });

        @Override
        default public boolean isEnabled(ItemStack itemStack, @Nullable TooltipComponentsValue.Storage storage) {
            if (storage == null) {
                return false;
            }
            int index = INDEX_MAP.getOrDefault((Object)storage, -1);
            if (index == -1) {
                return false;
            }
            return !LibUtils.getItemStackNbtNoCopy((ItemStack)itemStack).getBoolean(Integer.toString(index));
        }

        @Override
        default public void cycleEnable(ItemStack itemStack) {
        }
    }
}

